
/*
 *           PVM 3.2:  Parallel Virtual Machine System 3.2
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.2 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	task.h
 *
 *	Task descriptors.
 *
$Log: task.h,v $
 * Revision 1.1  1993/08/30  23:26:52  manchek
 * Initial revision
 *
 */


/* descriptor for a pvm task */

struct task {
	struct task *t_link;		/* complete list ordered by tid */
	struct task *t_rlink;
	struct task *t_plink;		/* partial list ordered by pid */
	struct task *t_prlink;
	int t_tid;					/* task id */
	int t_ptid;					/* parent task id */
	int t_flag;					/* status */
	int t_pid;					/* unix pid */
	int t_sock;					/* t-d tcp socket */
	struct sockaddr_in t_sad;	/* addr of sock */
	int t_salen;				/* addr length */
	struct waitc *t_wait;		/* wait channel */
	struct pkt *t_txq;			/* to task */
	struct pkt *t_rxp;			/* pkt reassembly from task */
	struct mesg *t_rxm;			/* to-us msg reassembly from task */
	int t_out;					/* pipe from stdout/err */
	char *t_authnam;			/* d-auth file name */
	int t_authfd;				/* d-auth file desc */
	char *t_a_out;				/* a.out name (info only) */
	struct mca *t_mca;			/* mca currently in use by task */
	int t_outtid;				/* dst and code for stdout data */
	int t_outcod;
	int t_trctid;				/* dst and code for trace data */
	int t_trccod;
};

/* t_flag bits */

#define	TF_CONN		4			/* task is connected */
#define	TF_AUTH		8			/* task needs to auth */
#define	TF_CLOSE	16			/* should delete context after flushing msgs */

#define	ISLOCLTASK(x)	(((x)&tidhmask)==(hosts->ht_local<<(ffs(tidhmask)-1)))

void task_init __ProtoGlarp__(( void ));
int tid_new __ProtoGlarp__(( void ));
struct task *task_new __ProtoGlarp__(( int tid ));
struct task *task_find __ProtoGlarp__(( int tid ));
struct task *task_findpid __ProtoGlarp__(( int pid ));
void task_setpid __ProtoGlarp__(( struct task *tp, int pid ));
void task_cleanup __ProtoGlarp__(( struct task *tp ));
void task_free __ProtoGlarp__(( struct task *tp ));

