
/*
 *           PVM 3.2:  Parallel Virtual Machine System 3.2
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.2 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	ddpro.h
 *
 *	Pvmd-pvmd protocol
 *
$Log: ddpro.h,v $
 * Revision 1.1  1993/08/30  23:26:47  manchek
 * Initial revision
 *
 */


/* protocol version */

#ifndef	DDPROTOCOL
#define	DDPROTOCOL	2312
#endif

#define	DDMINRETRIES	10
#define	DDMAXRTT		9		/* seconds */
#define	DDMINTIMEOUT	(DDMINRETRIES*DDMAXRTT*2)	/* seconds */
#define	DDERRRETRY		300000	/* uSec */
#define	DDPINGTIME		60		/* (sec) between keepalive pings */
#define	DDBAILTIME		300		/* (sec) for new slave to bail if no config */

#define	NEXTSEQNUM(x)		(((x)+1)&0xffff)
#define	SEQNUMCOMPARE(x,y)	((x)<(y)||(((x)>0x8000)&&((y)<0x8000)))

/* message/frag hdr sizes */

#define	DDFRAGHDR		16
#define	DDMSGHDR		8

/* frag flags */

#define	FFDAT			4		/* packet contains data, seq num is valid */
#define	FFFIN			8		/* sender closing connection */
#define	FFACK			16		/* ack num is valid */

/* d-d message flavors */

#define	DM_ADDHOST		1		/* add hosts to machine */
#define	DM_ADDHOSTACK	2
#define	DM_SPAWN		3		/* spawn tasks */
#define	DM_SPAWNACK		4
#define	DM_SENDSIG		5		/* signal a task */
#define	DM_HTUPD		6		/* define new host table */
#define	DM_HTUPDACK		7
#define	DM_HTCOMMIT		8		/* switch to new host table */
#define	DM_SLCONF		9		/* config slave pvmd */
#define	DM_STARTACK		10		/* pvmd' completed slave startup */
#define	DM_TASK			11		/* get list of tasks */
#define	DM_TASKACK		12
#define	DM_DELHOST		13		/* delete hosts from machine */
#define	DM_DELHOSTACK	14
#define	DM_NULL			15		/* null message */
#define	DM_TASKOUT		16		/* task standard out/err data */
#define	DM_PSTAT		17		/* query status of task */
#define	DM_PSTATACK		18
#define	DM_HALT			19		/* request master pvmd to halt */
#define	DM_MCA			20		/* define multicast tid */
#define	DM_NOTIFY		21		/* request notify */
#define	DM_NOTIFYACK	22
#define	DM_DB			23		/* name-server request */
#define	DM_DBACK		24
#define	DM_HTDEL		25		/* delete hosts from host table */

/* DM_SLCONF fields - don't use 0 */

#define	DM_SLCONF_EP	1		/* set epath */
#define	DM_SLCONF_BP	2		/* set bpath */

/* pvmd debug mask */

#define	PDMPACKET		1		/* packet tracing */
#define	PDMMESSAGE		2		/* message tracing */
#define	PDMTASK			4		/* task tracing */
#define	PDMSTARTUP		8		/* new slave startup */
#define	PDMHOST			16		/* host table stuff */
#define	PDMSELECT		32		/* select/fd set stuff */
#define	PDMNET			64		/* ip stuff */

/* pvmd run states */

#define	PVMDNORMAL		1		/* normal running state */
#define	PVMDHTUPD		2		/* getting host table update */
#define	PVMDSTARTUP		3		/* slave just started, not fully configured */
#define	PVMDPRIME		4		/* am pvmd' */
#define	PVMDHALTING		5		/* stopping rsn */
#define	PVMDSHUTDOWN	6		/* in timeout to halt, waiting for FIN|ACK */

