
/*
 *           PVM 3.2:  Parallel Virtual Machine System 3.2
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.2 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	job.h
 *
 *	Job descriptors.
 *
$Log: job.h,v $
 * Revision 1.1  1993/08/30  23:30:32  manchek
 * Initial revision
 *
 */


struct job {
	struct job *j_link, *j_rlink;		/* chain of all jobs */
	int j_jid;							/* unique job id */
	struct obuf *j_obufs;				/* head of obuf list */
	FILE *j_ff;							/* if writing to file, else -1 */
};

#define	GOTSPAWN	1
#define	GOTEOF		2

/*
*	used to collect output from a task
*/

struct obuf {
	struct obuf *o_link, *o_rlink;		/* chain of all tasks in job */
	int o_tid;							/* task id */
	char *o_buf;						/* buffered partial line */
	int o_len;							/* length of buf */
	int o_maxl;							/* space in buf */
	int o_flag;							/* task state */
};


int job_init __ProtoGlarp__(( void ));
struct job *job_new __ProtoGlarp__(( int jid ));
struct job *job_find __ProtoGlarp__(( int jid ));
int job_free __ProtoGlarp__(( struct job *jp ));
struct obuf * obuf_new __ProtoGlarp__(( struct job *jp, int tid ));
struct obuf * obuf_find __ProtoGlarp__(( struct job *jp, int tid ));
int obuf_free __ProtoGlarp__(( struct job *jp, struct obuf *op ));
int obuf_dump __ProtoGlarp__(( struct job *jp ));
int checkoutput __ProtoGlarp__(( struct job *jp, int cc, int len, int cod, int src ));

