
/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	host.h
 *
 *	Host table data structures.
 *
$Log$
 */


/* Host descriptor */

struct hostd {
	int hd_ref;					/* num refs to this struct */
	int hd_hostpart;			/* host tid base */
	char *hd_name;				/* name */
	char *hd_arch;				/* cpu arch class */
	char *hd_login;				/* loginname  [used master only] */
	char *hd_dpath;				/* daemon executable  [used master only] */
	char *hd_epath;				/* task exec search path  [used master only] */
	int hd_flag;
	int hd_err;					/* error code */
	int hd_mtu;					/* max snd/rcv length */
	struct sockaddr_in hd_sad;	/* UDP address/port */
	int hd_rxseq;				/* expected next seq num from host */
	int hd_txseq;				/* next tx seq num to host */
	struct pkt *hd_txq;			/* packet queue to host */
#if 0  /* XXX not used yet */
	struct pkt *hd_rxq;			/* packet reordering queue from host */
#endif
	struct mesg *hd_rxm;		/* to-us msg reassembly from host */
	struct timeval hd_rtv;		/* time to retry */
	struct timeval hd_rta;		/* next retry accumulator */
	struct timeval hd_rto;		/* time spent on current packet */
	struct timeval hd_rtt;		/* estd round-trip time to host */
	struct timeval hd_last;		/* time last pkt sent */
	int hd_nrty;				/* num retries to go */
	int hd_speed;				/* cpu relative speed */
	struct mca *hd_mcas;		/* from-host mca cache */
};

/* hd_flag values */

#define	HF_DOACK	1			/* need to ack to host */
#define	HF_SHUTDOWN	2			/* shut down the connection  */
/* for advisory host table */
#define	HF_NOSTART	0x100		/* don't start pvmd */
#define	HF_ASKPW	0x200		/* ask for passwd */
#define	HF_MANUAL	0x400		/* manual startup */


/* Host table */

struct htab {
	int ht_serial;				/* serial number */
	int ht_last;				/* highest entry */
	int ht_cnt;					/* number of entries (not incl [0]) */
	int ht_master;				/* master host */
	int ht_cons;				/* console host */
	int ht_local;				/* this host */
	int ht_narch;				/* count of different data reps */
	struct hostd **ht_hosts;	/* hosts */
};

struct hostd *hd_new __ProtoGlarp__((int ind));
void hd_free __ProtoGlarp__((struct hostd *hp));
void hd_unref __ProtoGlarp__((struct hostd *hp));

struct hostd *nametohost __ProtoGlarp__((struct htab *htp, char *name));
struct hostd *indtohost __ProtoGlarp__((struct htab *htp, int tid));
struct hostd *tidtohost __ProtoGlarp__((struct htab *htp, int tid));
struct htab *ht_new __ProtoGlarp__((int len));
int ht_insert __ProtoGlarp__((struct htab *htp, struct hostd *hp));
int ht_delete __ProtoGlarp__((struct htab *htp, struct hostd *hp));
void ht_free __ProtoGlarp__((struct htab *htp));
struct htab *readhostfile __ProtoGlarp__((char *fn));
int ht_merge __ProtoGlarp__((struct htab *dst, struct htab *src));

