
/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	global.h
 *
 *	Generic includes.
 *
$Log$
 */


/* release version */

#define	PVM_VER	"3.0"

/* UDPMAXLEN should be set to the largest UDP message length
   your system can handle. */

#ifndef	UDPMAXLEN

#ifdef	IMA_CRAY
#include <sys/tcp_config.h>
#define	UDPMAXLEN	UDPSENDSPACE/2
#endif

#endif	/*!UDPMAXLEN*/

#ifndef	UDPMAXLEN
#define	UDPMAXLEN	4096	/* generic max message length */
#endif

#define	LASTPORT	65535	/* last inet port number to try binding to */

/* tid:  s,g,h..h,p..p */

#define	TIDHOST		0x3ffc0000
#define	TIDLOCAL	0x0003ffff
#define	TIDGID		0x40000000
#define	TIDPVMD		0x80000000

#define	TIDISTASK(x)	(!((x) & (TIDGID|TIDPVMD)))

/* frag and packet flags */

#define	FFSOM		1		/* first frag of msg */
#define	FFEOM		2		/* final frag of msg */
#define	FFDATA		4		/* packet contains data */

