
/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	ddpro.h
 *
 *	Pvmd-pvmd protocol
 *
$Log$
 */


/* protocol version */

#ifndef	DDPROTOCOL
#define	DDPROTOCOL	2309
#endif

#define	RETRYLIMIT		10		/* XXX const */
#define	NEXTSEQNUM(x)		(((x)+1)&0xffff)
#define	SEQNUMCOMPARE(x,y)	((x)<(y)||(((x)>0x8000)&&((y)<0x8000)))

/* message/frag hdr sizes */

#define	DDFRAGHDR	16
#define	DDMSGHDR	8

/* d-d message flavors */

#define	DM_ADDHOST		1		/* add hosts to machine */
#define	DM_ADDHOSTACK	2
#define	DM_SPAWN		3		/* spawn tasks */
#define	DM_SPAWNACK		4
#define	DM_SENDSIG		5		/* signal a task */
#define	DM_HTUPD		6		/* define new host table */
#define	DM_HTUPDACK		7
#define	DM_HTCOMMIT		8		/* switch to new host table */
#define	DM_SLCONF		9		/* config new slave pvmd */
#define	DM_STARTACK		10		/* pvmd' completed slave startup */
#define	DM_BAIL			11		/* bail warning */
#define	DM_TASK			12		/* get list of tasks */
#define	DM_TASKACK		13
#define	DM_DELHOST		14		/* delete hosts from machine */
#define	DM_DELHOSTACK	15
#define	DM_NULL			16		/* null message */
#define	DM_TASKOUT		17		/* task standard out/err data */
#define	DM_PSTAT		18		/* query status of task */
#define	DM_PSTATACK		19
#define	DM_HALT			20		/* request master pvmd to halt */
#define	DM_MCA			21		/* define multicast tid */
#define	DM_NOTIFY		22		/* request notify */
#define	DM_NOTIFYACK	23
#define	DM_DB			24		/* name-server request */
#define	DM_DBACK		25

/* pvmd debug mask */

#define	PDMPACKET	1		/* packet tracing */
#define	PDMMESSAGE	2		/* message tracing */
#define	PDMTASK		4		/* task tracing */
#define	PDMSTARTUP	8		/* new slave startup */
#define	PDMHOST		16		/* host table stuff */

/* pvmd run states */

#define	PVMDNORMAL		1		/* normal running */
#define	PVMDHTUPD		2		/* doing host table update */
#define	PVMDSTARTUP		3		/* slave just started, do talk to tasks */
#define	PVMDPRIME		4		/* am pvmd' */
#define	PVMDHALTING		5		/* halting as quickly as possible */

