/* The header file MON_LINDA.H includes the common structures used
in the monitors model.  Of primary concern are the structures
space_q and aggregate: space_q contains a tuple as it appears in
tuple space, while aggregate holds complex tuple elements.
*/

/* MON_LINDA.H: */

#include <varargs.h>
#include "p4.h" 
 
#define linda_init mon_linda_init
#define linda_end  mon_linda_end

#define HANGER_SIZE 80 
#define KEY_SIZE 80  
#define IN 0
#define RD 1
#define OUT 3
 
int *pinum2; 
 
struct globals{ 
  char template[80];  
  int type;  
  char mask[80];  
  } global; 
 
struct space_q { 
    char hanger[HANGER_SIZE]; 
    char mask[80]; 
    struct space_q *next; 
    }; 
 
struct aggregate { 
    int size;  
    char data; 
}*ag_ptr; 
 
struct globmem { 
    struct space_q *tuple_space[256], *space_tails[256];    
    struct work_struct *pool, *pool_tail; 
    int numprocs; 
    p4_askfor_monitor_t TS; 
}*glob; 
 
 
struct work_struct { 
  char work[80]; 
  char mask[20]; 
  struct work_struct *next; 
  };  
 
struct space_q *head_avl_nodeq; 


struct linda_eval_table
{
    int (*ptr)();
    char name[64];
} mon_linda_functions_table[50];

