#include <rpc/rpc.h>
#include <sys/time.h>
#include "rpcint.h"

/* Default timeout can be changed using clnt_control() */
static struct timeval TIMEOUT = { 25, 0 };

int *
rinit_1(argp, clnt)
	char *argp;
	CLIENT *clnt;
{
	static int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RINIT, xdr_fname, argp, xdr_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


int *
rsave_1(argp, clnt)
	char *argp;
	CLIENT *clnt;
{
	static int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RSAVE, xdr_fname, argp, xdr_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


int *
rload_1(argp, clnt)
	char *argp;
	CLIENT *clnt;
{
	static int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RLOAD, xdr_fname, argp, xdr_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


confres *
rsysconf_1(argp, clnt)
	char *argp;
	CLIENT *clnt;
{
	static confres res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RSYSCONF, xdr_fname, argp, xdr_confres, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


rec *
rnetstat_1(argp, clnt)
	strctname *argp;
	CLIENT *clnt;
{
	static rec res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RNETSTAT, xdr_strctname, argp, xdr_rec, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


int *
rexecute_1(argp, clnt)
	int *argp;
	CLIENT *clnt;
{
	static int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, REXECUTE, xdr_int, argp, xdr_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


patres *
rreadinp_1(argp, clnt)
	patfile *argp;
	CLIENT *clnt;
{
	static patres res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RREADINP, xdr_patfile, argp, xdr_patres, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


patres *
rreadall_1(argp, clnt)
	patfile *argp;
	CLIENT *clnt;
{
	static patres res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RREADALL, xdr_patfile, argp, xdr_patres, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


int *
rrandweight_1(argp, clnt)
	char *argp;
	CLIENT *clnt;
{
	static int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RRANDWEIGHT, xdr_char, argp, xdr_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


rec *
rgetanyweight_1(argp, clnt)
	twoindx *argp;
	CLIENT *clnt;
{
	static rec res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RGETANYWEIGHT, xdr_twoindx, argp, xdr_rec, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


rec *
rgetbitweight_1(argp, clnt)
	twoindx *argp;
	CLIENT *clnt;
{
	static rec res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RGETBITWEIGHT, xdr_twoindx, argp, xdr_rec, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


rec *
rgetsparse_1(argp, clnt)
	roadsize *argp;
	CLIENT *clnt;
{
	static rec res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RGETSPARSE, xdr_roadsize, argp, xdr_rec, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


int *
rterminateserv_1(argp, clnt)
	int *argp;
	CLIENT *clnt;
{
	static int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RTERMINATESERV, xdr_int, argp, xdr_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

