/******************************************************************************/
/**									     **/
/**		      Copyright 1989 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission.    **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.0 24/11/89 mjh
 *
 * pgm net level graphic drawing
 *
 * net_level.c
 ******************************************************************************/

#include "mike_display.h"
#include "everything.h"

extern confres *conf;
extern float FindThreshold() ;

/* function that draws the net level in the graphic window.  Takes 
 * the full area, unless a connection matrix being shown, in which case 
 * the horizontal shrinks to half the window width. - needs to be passed
 * an area_width which is half that of xwa.width
 */

void draw_net(w, gc, cmap, mikepath, area_width, win_height, net_low_color, net_high_color)
Widget w;
GC gc;
Colormap cmap;
int mikepath[4];
int area_width;
int win_height;
char net_low_color;
char net_high_color;
{

	int total_net_neurons;
	int net_neurons_drawn;
	int number_layers;
	int number_layer_neurons;
	int number_cluster_neurons;
	int number_clusters;

	int neuron_width, neuron_height;
	int neuron_drawing_width, neuron_drawing_height;
	int temp1, temp2, layer_number, longest_layer_clusters;
	int h,i,j,k;
	int curr_x_pos, curr_y_pos;
	rpcsys *rpcconf;
	float *first_attribute;
	int *color_attribute;
	char textlabel[512];
	float neuron_color_scale[2];
	float neuron_color_multiply;
	int color_map_multiply;	
	/* temp */
	int number_of_shades = 20;
	int label_increment = 10;
	rpcconf = conf->confres_u.sys;

	number_layers = rpcconf->rpcsys_val[mikepath[0]].rpcnet_len;




/* deal with error case first. That is, if called with zero layers.  Then deal
 * with the simple one layer case , before doing the rest.  What the following
 * bit of stuff does is to set the width of a neuron, so that clusters can
 * be drawn the correct size.  The height is then set
 */


	if(number_layers  == 0)
	{
		/* no layers to display - somethings rotten in Denmark */
		Error(18);
		return;
	}
	else if(number_layers == 1)
	     {
  		number_clusters = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[0].rpclay_len;
		for(i=0, total_net_neurons=0; i< number_clusters; i++)
		{
			total_net_neurons += rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[0].rpclay_val[i].rpcclu_len;
		}
		neuron_width = area_width / (total_net_neurons + number_clusters + 3);
	     }
	     else if(number_layers > 1)
	     	  {
			/* to find largest layer & so to find a suitable
			 * neuron size for all
			 */

			number_layer_neurons = 0;
			number_clusters = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[0].rpclay_len;
			for(i=0; i< number_clusters; i++)
			{
				number_layer_neurons += rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[0].rpclay_val[i].rpcclu_len;
			}
			total_net_neurons = number_layer_neurons;
		  	temp1 = (number_layer_neurons + number_clusters);

			if(number_layers != 1)
			{
				for(j=1; j<number_layers; j++)
				{
					number_clusters = 0;
					number_layer_neurons = 0;
					number_clusters = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[j].rpclay_len;
					for(i=0; i< number_clusters; i++)
					{
						number_layer_neurons += rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[j].rpclay_val[i].rpcclu_len;
					}
					total_net_neurons += number_layer_neurons;
					temp2 = number_layer_neurons + number_clusters;
					if(temp2 > temp1)
					{
						temp1 = temp2;
						layer_number = j;
						longest_layer_clusters = number_clusters;
					}
				}
			}

			neuron_width = area_width / (temp1+1);
			
			if(neuron_width < 2) 
			{
				/* window too  narrow */
				Error(15);
				return;
			}
		  }



	first_attribute = (float *) calloc(sizeof(float), total_net_neurons);
	color_attribute = (int *) calloc(sizeof(int), total_net_neurons);

	SetToState(mikepath, first_attribute);


	GiveNeuronScaleFamily(mikepath, neuron_color_scale);
	neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
	color_map_multiply = 199*neuron_color_multiply;
	
	for(i=0; i< total_net_neurons; i++)
	{
		color_attribute[i] = BB_OFFSET + color_map_multiply*(first_attribute[i]-neuron_color_scale[0]);
	}
	neuron_height = ((win_height-60) / (number_layers+1));

	if(neuron_height < 2) 
	{
		/* window too short */
		Error(16);
		return;
	}

	neuron_drawing_width = ((9*neuron_width)/10);
	neuron_drawing_height = ((9*neuron_height)/10);

/*	neuron_drawing_width = neuron_width;
	neuron_drawing_height = neuron_height;
*/
	XSetForeground(dpy, gc, my_red.pixel);
	XClearArea(dpy, gra_win, 0, win_height-18, area_width, 17, False);
        XDrawImageString(dpy, gra_win, gc,  5, win_height -5, "wait...", strlen("wait..."));


/* now we know the size of a neuron building block, we can draw the layers.
 * rather a convoluted way, but we want a gap between clusters.
 */
	XSetLineAttributes(dpy, gc, 1, LineSolid, CapRound, JoinMiter);

/* loop to draw the neuron numbers */
/*	for(j=0, curr_x_pos = neuron_width; j<longest_layer_clusters; j++)
	{
		for(k=0; k<rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[layer_number].rpclay_val[j].rpcclu_len; k++, net_neurons_drawn += label_increment)
		{
			XDrawLine(dpy, gra_win, gc, curr_x_pos, 14, curr_x_pos, 24);
			sprintf(textlabel, "%i", net_neurons_drawn);
			XDrawImageString(dpy, gra_win, gc, curr_x_pos, 13, textlabel, strlen(textlabel));			
			curr_x_pos += label_increment*neuron_width;
		}
		curr_x_pos += neuron_width;
	}
*/

	for(i=0, curr_y_pos = (neuron_height/2), net_neurons_drawn=0; i<number_layers; i++)
	{

		/* this diddy loop +2 lines produces a box round the layer - liked by many to aid clarity */
		
		for(h=0, number_layer_neurons = 0; h< number_clusters; h++)
		{
			number_layer_neurons += rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[i].rpclay_val[h].rpcclu_len;
		}
		XSetForeground(dpy, gc, my_fg.pixel);
/*		XDrawRectangle(dpy, gra_win, gc, neuron_width-2, (neuron_height/2)-2+(i*neuron_height), ((number_layer_neurons*neuron_width)+3), (neuron_drawing_height+3));*/
		XDrawRectangle(dpy, gra_win, gc, (3*neuron_width)-2, (neuron_height/2)-2+(i*neuron_height), ((number_layer_neurons*neuron_width)+3), (neuron_drawing_height+3));
		
		if(DisplayCells(dpy, DefaultScreen(dpy)) == 2)
		{
			for(j=0, curr_x_pos = (3*neuron_width); j<number_clusters; j++)
			{
				for(k=0; k<rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[i].rpclay_val[j].rpcclu_len; k++, net_neurons_drawn++)
				{
					set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, ((first_attribute[net_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
					XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_drawing_height);
					curr_x_pos += neuron_width;
				}
				curr_x_pos += neuron_width;
			}
		}
		else
		{
			for(j=0, curr_x_pos = (3*neuron_width); j<number_clusters; j++)
			{
				for(k=0; k<rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[i].rpclay_val[j].rpcclu_len; k++, net_neurons_drawn++)
				{
					my_drawing_color.pixel = color_attribute[net_neurons_drawn];
		XSetForeground(dpy, gc, my_drawing_color.pixel);
					XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_drawing_height);
					curr_x_pos += neuron_width;
				}
				curr_x_pos += neuron_width;
			}
		}
	
	if(neuron_height > 16)
		{
			XSetForeground(dpy, gc, my_fg.pixel);
			sprintf(textlabel, "%i", i+1);
			XDrawImageString(dpy, gra_win, gc, 1, curr_y_pos, textlabel, strlen(textlabel));
		}

		curr_y_pos += neuron_height;
	}

	free(color_attribute);
	free(first_attribute);

	shade_scale(w, mikepath, area_width, win_height, net_low_color, net_high_color, number_of_shades);
	XSetForeground(dpy, gc, my_fg.pixel);
	XClearArea(dpy, gra_win, 0, win_height-18, area_width, 17, False);
	sprintf(textlabel, "%c ->  %c  Shading, State (%f,%f)", net_low_color, net_high_color, neuron_color_scale[0], neuron_color_scale[1]);
	XDrawImageString(dpy, gra_win, gc, 5, win_height -5, textlabel, strlen(textlabel));

	return;
}


/* function that draws a matrix of the connection and weights of aforementioned 
 * between the output neurons of one layer and the input neurons of another.  The 
 * two layers are selected by widget stuff.  If this function is called then
 * the above function, draw_net must be called also, with a win_width half that
 * of the actual window.  Then the system will be drawn, scaled horizontally to fit
 * in the left half of the window
 */



void draw_net_connection(w, gc, cmap, mikepath, connpath1, connpath2, area_width, win_height, net_low_color, net_high_color)
Widget w;
GC gc;
Colormap cmap;
int mikepath[4];
int connpath1[4];
int connpath2[4];
int area_width;
int win_height;
char net_low_color;
char net_high_color;
{
	int i,j;
	int neuron_width, neuron_height;
	int neuron_drawing_width, neuron_drawing_height;
	int layerA, layerB;
	int total_neurons_drawnA, total_neurons_drawnB;
	int layer_neuronsA, cluster_neuronsA, clustersA;
	int layer_neuronsB, cluster_neuronsB, clustersB;
	int clusters_drawnA, clusters_drawnB, neurons_drawnA, neurons_drawnB;
	int curr_x_pos, curr_y_pos;
	int shift;		/* right shift for the coords, as this function only uses */
	rpcsys *rpcconf;
	char textlabel[512];
	float *first_attribute;
	float *second_attribute;
	float *weight_attribute;
	int *color1_attribute;
	int *color2_attribute;
	int *color_attribute;
	int label_increment;
	float neuron_color_scale[2];
	float weight_color_scale[2];
	float neuron_color_multiply;
	float weight_color_multiply;
	int color_map_multiply;
	int weight_color_map_multiply;
	int normalize[2];

/* five lines for magali's bit thingy */
    	int sparse;
	unsigned *weight_bit;
	int intbits, number_of_ints, number_of_bits;
	int connect_number;
	float *weight_value;
	int conn_weight;
	int location_of_int, location_of_bit;

    	rpcconf = conf->confres_u.sys;

sparse = 0;

/* deal with the error cases first - ie layerA and or layerB have no connection */
	
	shift = area_width/2;

	/* want to divide the two areas, so draw a line on the left of this area */
	
	XSetLineAttributes(dpy, gc, 0, LineSolid, CapRound, JoinMiter);
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawLine(dpy, gra_win, gc, shift, 0, shift, win_height);


/* find the width of neurons by looking at layerA, and height by looking
 * at layerB
 */
	clustersA = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_len;
	for(i=0, layer_neuronsA=0; i<clustersA; i++)
	{
		layer_neuronsA += rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_val[i].rpcclu_len;
	}

	clustersB = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_len;
	for(i=0, layer_neuronsB=0; i<clustersB; i++)
	{
		layer_neuronsB += rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_val[i].rpcclu_len;
	}

	first_attribute = (float *) calloc(sizeof(float), layer_neuronsA);
	second_attribute = (float *) calloc(sizeof(float), layer_neuronsB);
	SetToState(connpath1, first_attribute);
	SetToState(connpath2, second_attribute);
	color1_attribute = (int *) calloc(sizeof(int), layer_neuronsA);
	color2_attribute = (int *) calloc(sizeof(int), layer_neuronsB);

	

	
	if(!sparse)
	{
		weight_attribute = (float *) calloc(sizeof(float), (layer_neuronsA*layer_neuronsB));
		SetToWeight(connpath1, connpath2, weight_attribute);
		color_attribute = (int *) calloc(sizeof(int), (layer_neuronsA*layer_neuronsB));
	}
	else
	{

		intbits = sizeof(int) *8;

		number_of_ints = layer_neuronsA*layer_neuronsB / (intbits+1);
		weight_bit = (unsigned *) calloc(sizeof(unsigned), number_of_ints);
		SetToBit(connpath1, connpath2, weight_bit);
		for(connect_number=0,i=0;i<number_of_ints;i++)
		{
			connect_number += Mybitcount(weight_bit[i]);
		}
		weight_value = (float *) calloc(sizeof(float), connect_number);
		SetSparseWeight(connpath1, connpath2, weight_value, connect_number);
	}

	GiveNeuronScaleFamily(mikepath, neuron_color_scale);
	GiveWeightScaleFamily(mikepath, weight_color_scale);

	
	neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
	weight_color_multiply = 1/(weight_color_scale[1]-weight_color_scale[0]);

	color_map_multiply = 199*neuron_color_multiply;
	weight_color_map_multiply = 199*weight_color_multiply;

	for(i=0; i< layer_neuronsA; i++)
	{
		color2_attribute[i] = BB_OFFSET +color_map_multiply*(first_attribute[i]-neuron_color_scale[0]);
	}

	for(i=0; i< layer_neuronsB; i++)
	{
		color1_attribute[i] = BB_OFFSET +color_map_multiply*(second_attribute[i]-neuron_color_scale[0]);
	}

	for(i=0; i< (layer_neuronsB*layer_neuronsA); i++)
	{
		color_attribute[i] = BB_OFFSET + weight_color_map_multiply*(weight_attribute[i]-weight_color_scale[0]);
	}
	


	neuron_width = shift / (layer_neuronsA + clustersA +10);
		if(neuron_width < 2) 
		{
			/* window too narrow */
			Error(15);
			return;
		}
		
		neuron_height = (win_height-60) / (layer_neuronsB + clustersB +10);
		if(neuron_height < 2) 
		{
			/* window too short */
			Error(16);
			return;
		}

		label_increment = 10; /* will be dynamic soon*/

	neuron_drawing_width = ((9*neuron_width)/10);
	neuron_drawing_height = ((9*neuron_height)/10);

/*	neuron_drawing_width = neuron_width;
	neuron_drawing_height =neuron_height;
*/
	XSetForeground(dpy, gc, my_red.pixel);
	XClearArea(dpy, gra_win, shift+5, win_height-19, area_width, 18, False);
        XDrawImageString(dpy, gra_win, gc, shift+5, win_height -5, "wait...", strlen("wait..."));

	/* so now we know the size of a neuron, we can draw horizontal and 
	 * vertical bars for the matrix. This is quite a revolting for loop
	 */
		/* but label the axis first! */

		XSetForeground(dpy, gc, my_fg.pixel);
		sprintf(textlabel, "Layer %i", connpath1[1]+1);
		XDrawImageString(dpy, gra_win, gc, (area_width - 50), 12, textlabel, strlen(textlabel));

		
		for(clusters_drawnB=0, curr_x_pos=(shift+50)+(3*neuron_width); clusters_drawnB<clustersB; clusters_drawnB++)
		{
			cluster_neuronsB = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_val[clusters_drawnB].rpcclu_len;
			for(neurons_drawnB=0; neurons_drawnB<cluster_neuronsB; neurons_drawnB +=label_increment)
			{
				XDrawLine(dpy, gra_win, gc, (((3+neurons_drawnB)*neuron_width)+shift+50), 14, (((3+neurons_drawnB)*neuron_width)+shift+50), 30);		
				sprintf(textlabel, "%i", neurons_drawnB+1);
				XDrawImageString(dpy, gra_win, gc, (((3+neurons_drawnB)*neuron_width)+shift+50), 12, textlabel, strlen(textlabel));
				curr_x_pos += (label_increment*neuron_width);
			}

			curr_x_pos += neuron_width;

		}

		XSetForeground(dpy, gc, my_drawing_color.pixel);
		if(DisplayCells(dpy, DefaultScreen(dpy)) == 2)
		{
		for(clusters_drawnB=0, curr_x_pos=(shift+50+(3*neuron_width)); clusters_drawnB<clustersB; clusters_drawnB++)
		{
			cluster_neuronsB = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_val[clusters_drawnB].rpcclu_len;
			for(neurons_drawnB=0; neurons_drawnB<cluster_neuronsB; neurons_drawnB++)
			{
				set_color(w, connpath2, gc, cmap, net_low_color, net_high_color, ((first_attribute[neurons_drawnB]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
/*				XFillRectangle(dpy, gra_win, gc, curr_x_pos, (30+neuron_height), neuron_drawing_width, neuron_drawing_height);*/
				XFillRectangle(dpy, gra_win, gc, curr_x_pos, (30+neuron_height), neuron_width, neuron_height);
				curr_x_pos += neuron_width;
			}

			curr_x_pos += neuron_width;

		}
		}
		else
		{
		for(clusters_drawnB=0, curr_x_pos=(shift+50+(3*neuron_width)); clusters_drawnB<clustersB; clusters_drawnB++)
		{
			cluster_neuronsB = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_val[clusters_drawnB].rpcclu_len;
			for(neurons_drawnB=0; neurons_drawnB<cluster_neuronsB; neurons_drawnB++)
			{
				my_drawing_color.pixel = color2_attribute[neurons_drawnB];
		XSetForeground(dpy, gc, my_drawing_color.pixel);
/*				XFillRectangle(dpy, gra_win, gc, curr_x_pos, (30+neuron_height), neuron_drawing_width, neuron_drawing_height);*/
				XFillRectangle(dpy, gra_win, gc, curr_x_pos, (30+neuron_height), neuron_width, neuron_height);
				curr_x_pos += neuron_width;
			}

			curr_x_pos += neuron_width;

		}
		}
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawRectangle(dpy, gra_win, gc, (shift+50+(3*neuron_width))-2, (28+neuron_height), curr_x_pos-(shift+50+(3*neuron_width))+2, neuron_height+2);




	/* horizontal bar done, now the vertical one
	 */
		XSetForeground(dpy, gc, my_fg.pixel);
		sprintf(textlabel, "Layer %i", connpath2[1]+1);
		XDrawImageString(dpy, gra_win, gc, (neuron_width+shift), (win_height - 20), textlabel, strlen(textlabel));

		for(clusters_drawnA=0, curr_y_pos=(40 +(3*neuron_height)); clusters_drawnA<clustersA; clusters_drawnA++)
		{
			cluster_neuronsA = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_val[clusters_drawnA].rpcclu_len;
			for(neurons_drawnA=0; neurons_drawnA<cluster_neuronsA; neurons_drawnA+=label_increment)
			{
				XDrawLine(dpy, gra_win, gc, (30+shift), curr_y_pos, (50+shift), curr_y_pos);		
				sprintf(textlabel, "%i", neurons_drawnA+1);
				XDrawImageString(dpy, gra_win, gc, 5+shift, curr_y_pos, textlabel, strlen(textlabel));
				curr_y_pos += (label_increment*neuron_height);
			}

			curr_y_pos += neuron_height;
		}

		XSetForeground(dpy, gc, my_drawing_color.pixel);
		if(DisplayCells(dpy, DefaultScreen(dpy)) == 2)
		{
		for(clusters_drawnA=0, curr_y_pos=(3*neuron_height)+40; clusters_drawnA<clustersA; clusters_drawnA++)
		{
			cluster_neuronsA = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_val[clusters_drawnA].rpcclu_len;
			for(neurons_drawnA=0; neurons_drawnA<cluster_neuronsA; neurons_drawnA++)
			{

				set_color(w, connpath1, gc, cmap, net_low_color, net_high_color, ((second_attribute[neurons_drawnA]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
/*				my_drawing_color.pixel = color1_attribute[neurons_drawnA];*/
/*			 	XFillRectangle(dpy, gra_win, gc, (shift+50), curr_y_pos, neuron_drawing_width, neuron_drawing_height);*/
			 	XFillRectangle(dpy, gra_win, gc, (shift+50), curr_y_pos, neuron_width, neuron_height);
				curr_y_pos += neuron_height;
			}

			curr_y_pos += neuron_height;
		}
		}
		else
		{
		for(clusters_drawnA=0, curr_y_pos=(3*neuron_height)+40; clusters_drawnA<clustersA; clusters_drawnA++)
		{
			cluster_neuronsA = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_val[clusters_drawnA].rpcclu_len;
			for(neurons_drawnA=0; neurons_drawnA<cluster_neuronsA; neurons_drawnA++)
			{


				my_drawing_color.pixel = color1_attribute[neurons_drawnA];
		XSetForeground(dpy, gc, my_drawing_color.pixel);
/*			 	XFillRectangle(dpy, gra_win, gc, (shift+50), curr_y_pos, neuron_drawing_width, neuron_drawing_height);*/
			 	XFillRectangle(dpy, gra_win, gc, (shift+50), curr_y_pos, neuron_width, neuron_height);
				curr_y_pos += neuron_height;
			}

			curr_y_pos += neuron_height;
		}
		}
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawRectangle(dpy, gra_win, gc, (shift+48), (3*neuron_height)+38, neuron_width+3, curr_y_pos-((4*neuron_height)+35));

	free(first_attribute);
	free(second_attribute);
	/* now for the matrix bit - a quite disgusting four nested for loops
	 * the first is to draw clusters of layerA
	 * the second is to draw the neurons in that cluster
	 * the third for clusters in layerB
 	 * the last for neurons in these clusters
	 */

if(!sparse)
{
	XSetForeground(dpy, gc, my_drawing_color.pixel);
	if(DisplayCells(dpy, DefaultScreen(dpy)) == 2)
	{
	 	for(clusters_drawnB =0, curr_x_pos=((3*neuron_width)+shift+50), total_neurons_drawnB =0; clusters_drawnB<clustersB; clusters_drawnB++)
		{
			cluster_neuronsB = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_val[clusters_drawnB].rpcclu_len;
			for(neurons_drawnB = 0; neurons_drawnB<cluster_neuronsB; neurons_drawnB++)
			{
				for(clusters_drawnA=0, curr_y_pos=(3*neuron_height)+40, total_neurons_drawnA=0; clusters_drawnA<clustersA; clusters_drawnA++)
				{
					cluster_neuronsA = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_val[clusters_drawnA].rpcclu_len;
					for(neurons_drawnA=0; neurons_drawnA<cluster_neuronsA; neurons_drawnA++, total_neurons_drawnB++)
					{

						/* yuk, but umm...!*/
						if(weight_attribute[total_neurons_drawnB] != 1000000)
						{
							set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, ((weight_attribute[total_neurons_drawnB]-weight_color_scale[0])*weight_color_multiply));
							/*my_drawing_color.pixel = color_attribute[total_neurons_drawnB];*/
						}
						else 
						{
							my_drawing_color.pixel = my_bg.pixel;
						}
		XSetForeground(dpy, gc, my_drawing_color.pixel);
						XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
/*						XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_drawing_width, neuron_drawing_height);*/
						curr_y_pos += neuron_height;
					}
					curr_y_pos += neuron_height;
				}
				curr_x_pos += neuron_width;
			}
			curr_x_pos += neuron_width;
		}
	}
	else
	{
		for(clusters_drawnB =0, curr_x_pos=((3*neuron_width)+shift+50), total_neurons_drawnB =0; clusters_drawnB<clustersB; clusters_drawnB++)
		{
			cluster_neuronsB = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_val[clusters_drawnB].rpcclu_len;
			for(neurons_drawnB = 0; neurons_drawnB<cluster_neuronsB; neurons_drawnB++)
			{
				for(clusters_drawnA=0, curr_y_pos=(3*neuron_height)+40, total_neurons_drawnA=0; clusters_drawnA<clustersA; clusters_drawnA++)
				{
					cluster_neuronsA = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_val[clusters_drawnA].rpcclu_len;
					for(neurons_drawnA=0; neurons_drawnA<cluster_neuronsA; neurons_drawnA++, total_neurons_drawnB++)
					{

						/* yuk, but umm...!*/
						if(weight_attribute[total_neurons_drawnB] != 1000000)
						{
							my_drawing_color.pixel = color_attribute[total_neurons_drawnB];
						}
						else 
						{
							my_drawing_color.pixel = my_bg.pixel;
						}
		XSetForeground(dpy, gc, my_drawing_color.pixel);
						XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
/*						XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_drawing_width, neuron_drawing_height);*/
						curr_y_pos += neuron_height;
					}
					curr_y_pos += neuron_height;
				}
				curr_x_pos += neuron_width;
			}
			curr_x_pos += neuron_width;
		}
	}
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawRectangle(dpy, gra_win, gc,(shift+50+(3*neuron_width))-2 , (3*neuron_height)+38, curr_x_pos-((shift+50+(3*neuron_width))-2), curr_y_pos-((4*neuron_height)+35));

free(color_attribute);
free(weight_attribute);
}
else
{
/*never get here at the mo */
	printf("****SPARSE***\n");
	for(clusters_drawnB =0, curr_x_pos=((2*neuron_width)+shift+50), total_neurons_drawnB =0, conn_weight= 0; clusters_drawnB<clustersB; clusters_drawnB++)
		{
			cluster_neuronsB = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_val[clusters_drawnB].rpcclu_len;
			for(neurons_drawnB = 0; neurons_drawnB<cluster_neuronsB; neurons_drawnB++)
			{
				for(clusters_drawnA=0, curr_y_pos=(2*neuron_height)+40, total_neurons_drawnA=0; clusters_drawnA<clustersA; clusters_drawnA++)
				{
					cluster_neuronsA = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_val[clusters_drawnA].rpcclu_len;
					for(neurons_drawnA=0; neurons_drawnA<cluster_neuronsA; neurons_drawnA++, total_neurons_drawnB++)
					{

						location_of_int = (neurons_drawnA +(neurons_drawnB * layer_neuronsA)) / intbits;
						location_of_bit = (neurons_drawnA +(neurons_drawnB * layer_neuronsA)) % intbits;
						if((weight_bit[location_of_int] >> location_of_bit) & 1)
						{
/*							set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, (weight_value[conn_weight]*weight_color_multiply));*/
				my_drawing_color.pixel = BB_OFFSET +(199*(weight_value[conn_weight]*weight_color_multiply));
							conn_weight++;
							XSetForeground(dpy, gc, my_drawing_color.pixel);
/*							XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_drawing_width, neuron_drawing_height);*/
							XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
						}
						else 
						{
							XClearArea(dpy, gra_win, curr_x_pos, curr_y_pos, neuron_drawing_width, neuron_drawing_height);
						}
						curr_y_pos += neuron_height;
					}
					curr_y_pos += neuron_height;
				}
				curr_x_pos += neuron_width;
			}
			curr_x_pos += neuron_width;
		}
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawRectangle(dpy, gra_win, gc,(shift+50+(2*neuron_width))-2 , (2*neuron_height)+38, curr_x_pos-((shift+50+(3*neuron_width))-2), curr_y_pos-((3*neuron_height)+35));

free(weight_value);
free(weight_bit);
}

	XSetForeground(dpy, gc, my_fg.pixel);
        sprintf(textlabel, "Weight (%f,%f)", weight_color_scale[0], weight_color_scale[1]);
        XDrawImageString(dpy, gra_win, gc, shift +5, win_height -5, textlabel, strlen(textlabel));


free(color1_attribute);
free(color2_attribute);
	return;
}



/* This function is the one that draws the layer in a  matrix rather than
 * a linear form, for character recognition purposes to visually aid the user
 * function that draws an individual layer in the graphic window.  Takes 
 * the full area, unless a connection matrix being shown, in which case 
 * the horizontal shrinks to half the window width. - needs to be passed
 * an area_width which is half that of xwa.width
 */

void draw_matrix_layers(w, gc, cmap, mikepath, matrix1, matrix2, area_width, win_height, net_low_color, net_high_color)
Widget w;
GC gc;
Colormap cmap;
int mikepath[4];
int matrix1[2];
int matrix2[2];
int area_width;
int win_height;
char net_low_color;
char net_high_color;
{

	int number_layers;
	int total_neurons_drawn;
	int neuron_width, neuron_height;
	int neuron_drawing_width, neuron_drawing_height;
	int i,j;
	int curr_x_pos, curr_y_pos;
	rpcsys *rpcconf;
	int first_layer_path[4];
	int last_layer_path[4];
	float *first_attribute;	
	float *second_attribute;
	float neuron_color_scale[2];
	float neuron_color_multiply;
	char textlabel[512];
	int number_of_shades = 20;

	rpcconf = conf->confres_u.sys;
	
	number_layers = rpcconf->rpcsys_val[mikepath[0]].rpcnet_len;

	if(number_layers == 1)
	{
		neuron_height = (win_height-60)/(matrix1[1]+3);
		neuron_width = area_width/(matrix1[0]+2);

		if(neuron_height <= neuron_width)
		{
			neuron_width = neuron_height;
		}
		else
		{		
			neuron_height = neuron_width;
		}
	
		neuron_drawing_width = ((9*neuron_width)/10);
		neuron_drawing_height = ((9*neuron_height)/10);


/* mikepath only provides some of what we need here, so create the path's of the
 * first and last layers */

	 	first_layer_path[0] = mikepath[0];
		first_layer_path[1] = 0;
		for(i=0; i<2; i++)
		{
			first_layer_path[i+2] = -1;
		}
	


		first_attribute = (float *) calloc(sizeof(float), matrix1[0]*matrix1[1]);

/* quick fix to the association probelm */
		SetToMatrix(first_layer_path, first_attribute);
	

		GiveNeuronScaleFamily(mikepath, neuron_color_scale);

/* if the scale is zero, funny colors displayed so */

		if(neuron_color_scale[0] == neuron_color_scale[1])
		{
			neuron_color_scale[1] = neuron_color_scale[0] +1;
		}

		neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
	
/* draw a bounding box for the matrix - much quicker than using gray bitmap background*/

		XSetLineAttributes(dpy, gc, 2, LineSolid, CapRound, JoinMiter);
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawRectangle(dpy, gra_win, gc, neuron_width-3, neuron_height-3, (((matrix1[0]-1)*neuron_width)+neuron_width+6), (((matrix1[1]-1)*neuron_height)+neuron_height+6));


/* one layer */
		XSetForeground(dpy, gc, my_drawing_color.pixel);

		if(DisplayCells(dpy, DefaultScreen(dpy)) == 2)
		{
		
		for(i=0,curr_y_pos = neuron_height, total_neurons_drawn = 0; i < matrix1[1]; i++)
		{
			for(j=0,curr_x_pos = neuron_width; j< matrix1[0]; j++)
			{
				set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, ((first_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
/*				my_drawing_color.pixel = BB_OFFSET +(199*((first_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));*/
/*				XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_drawing_width, neuron_drawing_height);*/
				XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
				curr_x_pos += neuron_width;
				total_neurons_drawn++;
			}
			curr_y_pos +=neuron_height;
		}
		}
		else
		{
		for(i=0,curr_y_pos = neuron_height, total_neurons_drawn = 0; i < matrix1[1]; i++)
		{
			for(j=0,curr_x_pos = neuron_width; j< matrix1[0]; j++)
			{
/*				set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, ((first_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));*/
				my_drawing_color.pixel = BB_OFFSET +(199*((first_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
/*				XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_drawing_width, neuron_drawing_height);*/
				XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
				curr_x_pos += neuron_width;
				total_neurons_drawn++;
			}
			curr_y_pos +=neuron_height;
		}
		}
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawImageString(dpy, gra_win, gc, neuron_width-1, neuron_height-1, "Network Layer", strlen("Network Layer"));

		free(first_attribute);
	}
	else
	{
		neuron_height = (win_height-60)/(matrix1[1]+matrix2[1]+3);
		if(matrix1[0] >= matrix2[0])
	 	{
			neuron_width = area_width/(matrix1[0]+2);
		}
		else
		{
			neuron_width = area_width/(matrix2[0]+2);
		}

		if(neuron_height <= neuron_width)
		{
			neuron_width = neuron_height;
		}
		else
		{	
			neuron_height = neuron_width;
		}
		
		neuron_drawing_width = ((9*neuron_width)/10);
		neuron_drawing_height = ((9*neuron_height)/10);

/*		neuron_drawing_width = neuron_width;
		neuron_drawing_height = neuron_height;
*/

/* mikepath only provides some of what we need here, so create the path's of the
 * first and last layers */

	 	first_layer_path[0] = mikepath[0];
		first_layer_path[1] = 0;
		last_layer_path[0] = mikepath[0];
		last_layer_path[1] = number_layers -1;
		for(i=0; i<2; i++)
		{
			first_layer_path[i+2] = -1;
			last_layer_path[i+2] = -1;
		}
		


		first_attribute = (float *) calloc(sizeof(float), matrix1[0]*matrix1[1]);
		second_attribute = (float *) calloc(sizeof(float), matrix2[0]*matrix2[1]);

/* find the correct assoc */
		SetToMatrix(first_layer_path, first_attribute);
		SetToMatrix(last_layer_path, second_attribute);

/* only asking for the scale for the first layer as the last should be within that range anyway */

		GiveNeuronScaleFamily(mikepath, neuron_color_scale);

/* if the scale is zero, funny colors displayed so */

		if(neuron_color_scale[0] == neuron_color_scale[1])
		{
			neuron_color_scale[1] = neuron_color_scale[0] +1;
		}

		neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
	
/* draw a bounding box for the matirices - much quicker than using gray bitmap background*/

		XSetLineAttributes(dpy, gc, 2, LineSolid, CapRound, JoinMiter);
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawRectangle(dpy, gra_win, gc, neuron_width-3, neuron_height-3, (((matrix1[0]-1)*neuron_width)+neuron_width+6), (((matrix1[1]-1)*neuron_height)+neuron_height+6));
		XDrawRectangle(dpy, gra_win, gc, neuron_width-3, ((neuron_height*(matrix1[1]+3))-3), (((matrix2[0]-1)*neuron_width)+neuron_width+6), (((matrix2[1]-1)*neuron_height)+neuron_height+6));

/* first the input layer */
	XSetForeground(dpy, gc, my_drawing_color.pixel);
	if(DisplayCells(dpy, DefaultScreen(dpy)) == 2)
	{
		for(i=0,curr_y_pos = neuron_height, total_neurons_drawn = 0; i < matrix1[1]; i++)
		{
			for(j=0,curr_x_pos = neuron_width; j< matrix1[0]; j++)
			{
				set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, ((first_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
				XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
				curr_x_pos += neuron_width;
				total_neurons_drawn++;
			}
			curr_y_pos +=neuron_height;
		}

	
/* now the last layer */

		for(i=0,curr_y_pos = neuron_height*(matrix1[1]+3), total_neurons_drawn = 0; i < matrix2[1]; i++)
		{
			for(j=0,curr_x_pos = neuron_width; j< matrix2[0]; j++)
			{	
				set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, ((second_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
				XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
				curr_x_pos += neuron_width;
				total_neurons_drawn++;
			}
			curr_y_pos +=neuron_height;
		}

		free(first_attribute);
		free(second_attribute);
	}
	else
	{
		for(i=0,curr_y_pos = neuron_height, total_neurons_drawn = 0; i < matrix1[1]; i++)
		{
			for(j=0,curr_x_pos = neuron_width; j< matrix1[0]; j++)
			{
/*				set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, ((first_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));*/
				my_drawing_color.pixel = BB_OFFSET +(199*((first_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
				XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
				curr_x_pos += neuron_width;
				total_neurons_drawn++;
			}
			curr_y_pos +=neuron_height;
		}

	
/* now the last layer */

		for(i=0,curr_y_pos = neuron_height*(matrix1[1]+3), total_neurons_drawn = 0; i < matrix2[1]; i++)
		{
			for(j=0,curr_x_pos = neuron_width; j< matrix2[0]; j++)
			{	
/*				set_color(w, mikepath, gc, cmap, net_low_color, net_high_color, ((second_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));*/
				my_drawing_color.pixel = BB_OFFSET +(199*((second_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
				XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_height);
				curr_x_pos += neuron_width;
				total_neurons_drawn++;
			}
			curr_y_pos +=neuron_height;
		}

		free(first_attribute);
		free(second_attribute);
	
	}
		XSetForeground(dpy, gc, my_fg.pixel);
		XDrawImageString(dpy, gra_win, gc, neuron_width-1, neuron_height-1, "Input", strlen("Input"));
		XDrawImageString(dpy, gra_win, gc, neuron_width-1, ((neuron_height*(matrix1[1]+3))-1), "Output", strlen("Output"));
	}
	

	
	shade_scale(w, mikepath, area_width, win_height, net_low_color, net_high_color, number_of_shades);
	XSetForeground(dpy, gc, my_fg.pixel);
	sprintf(textlabel, "%c ->  %c  Colour Scale, State (%f,%f)", net_low_color, net_high_color, neuron_color_scale[0], neuron_color_scale[1]);
	XDrawImageString(dpy, gra_win, gc, 5, win_height -5, textlabel, strlen(textlabel));
 	
}
