/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * mike_colour.c
 ******************************************************************************/

#include "mike_display.h"
#include "everything.h"

extern float FindThreshold() ;

/* this file contains the color functions for the graphical
 * display of the neural network.
 */


char sys_low_color = 'm';
char sys_high_color = 'm';
char net_low_color = 'm';
char net_high_color = 'm';
char layer_low_color = 'm';
char layer_high_color = 'm';
char cluster_low_color = 'm';
char cluster_high_color = 'm';
char neuron_low_color = 'm';
char neuron_high_color = 'm';


/* the function below is in the process of being superceded, that is why it seems trivial, as I've changed it 
 * during implementation of new functions
 */

void level_color(mikepath, low_color, high_color)
int mikepath[4];
int low_color;
int high_color;
{
	int i;
		sys_low_color = low_color;
		sys_high_color = high_color;
		net_low_color = low_color;
		net_high_color = high_color;
		layer_low_color = low_color;
		layer_high_color = high_color;
		cluster_low_color = low_color;
		cluster_high_color = high_color;
		neuron_low_color = low_color;
		neuron_high_color = high_color;

	return;
}


/* this function computes pixel values for area colors.  It needs
 * to know the current colormap, lowest and highest colors in the scale 
 * (ie red, green or blue), and the activation level. It then computes the

 * pixel values, allocates an entry in the cmap if necessary and if possible,
 * then sets the foreground before returning
 */

/* again, this function is being superceeded, and so is trivial and wasteful - will not be here soon */
 
unsigned long set_color(w, path, gc, cmap, low_color, high_color, act_level)
Widget w;
int path[4];
GC gc;
Colormap cmap;
char low_color;
char high_color;
float act_level;
{
int shade_increments = 199; /* this is actual number of shades minus 1 */

	if(DisplayCells(dpy, DefaultScreen(dpy)) == 2)
	{
		if(act_level < FindThreshold(path))
		{
			my_drawing_color.pixel = BlackPixel(dpy, DefaultScreen(dpy));
		}
		else 
		{
			my_drawing_color.pixel = WhitePixel(dpy, DefaultScreen(dpy));
		}
		return (my_drawing_color.pixel);
	}

	my_drawing_color.pixel = BB_OFFSET + (shade_increments*act_level) ;
	return (my_drawing_color.pixel);
	
}

/* the following function computes the colors to fill the colormap with default
 * colors and 200 values for the shading. At the mo, if cells are not available, pgm will exit, 
 * providing a message to the user on the reason why - not friendly, but it needs the
 * cells!
 */

unsigned long init_color_scales(dpy, gra_win, gc, cmap)
Display *dpy;
Window gra_win;
GC gc;
Colormap cmap;
{
	int i, j;
	static int spectrum[20][3] = {
				{ 59904,59904,44288},
				{ 59904,59904,36000},
				{ 61000,61000,25000},
				{ 65535,65535,    0},
				{ 56000,20000,    0},
				{ 61000,25000,    0},
				{ 65535,32512,    0},
				{ 61000,25000,15000},
				{ 61000,20000,25000},
				{ 65535,    0,31512},
				{ 61000,    0,25000},
				{ 65535,    0,    0},
				{ 58000,10000,15000},
				{ 52224,12800,39168},
				{ 37632,28672,56064},
				{ 39168,12800,52224},
				{ 27392, 8960,36352},
				{  8960, 8960,36352},
				{ 16896,16896,28416}, 
				{     0,    0,    0} };
				
	int number_of_colors_in_scale = 200;

/* do black and white first - so as to leave other windows */
	if(DisplayCells(dpy, DefaultScreen(dpy)) == 2) 
	{
			my_bg.pixel = BlackPixel(dpy, DefaultScreen(dpy));
			my_fg.pixel = WhitePixel(dpy, DefaultScreen(dpy));
			my_bg2.pixel = BlackPixel(dpy, DefaultScreen(dpy));
			my_fg2.pixel = WhitePixel(dpy, DefaultScreen(dpy));
			my_fg1.pixel = WhitePixel(dpy, DefaultScreen(dpy));
			my_bg1.pixel = BlackPixel(dpy, DefaultScreen(dpy));
			my_yellow.pixel = WhitePixel(dpy, DefaultScreen(dpy));
			my_red.pixel = WhitePixel(dpy, DefaultScreen(dpy));
			my_green.pixel = WhitePixel(dpy, DefaultScreen(dpy));
			my_blue.pixel = WhitePixel(dpy, DefaultScreen(dpy));
				
	return;
	}

/* here do a quickie check to see if user wants light grey text on dark grey bg, or vice versa
 * fudge to get around the fact that as we switch colormaps, Xtoolkit doesn't behave as it should
 * User must specify they want reverse in .pgmrc file.  It's a sneak really as I just swap over
 * where I load up 
 */


/* this is all rather a mess and must be tidied up, but as all these color functions are in the process of being rewritten
 */

/*	if(strcmp(INVBUF, rc[RC_inverse_display]))
	{

        	my_fg.red = atoi(rc[RC_main_foreground_red]); my_fg.green = atoi(rc[RC_main_foreground_green]); my_fg.blue = atoi(rc[RC_main_foreground_blue]);
  		my_fg.flags = DoRed|DoGreen|DoBlue;
       		my_fg.pixel =  0;
	XStoreColor(dpy, cmap, &my_fg);

        	my_bg.red = atoi( rc[RC_main_background_red]); my_bg.green = atoi(rc[RC_main_background_green]); my_bg.blue = atoi(rc[RC_main_background_blue]);
       		my_bg.flags = DoRed|DoGreen|DoBlue;
        	my_bg.pixel = 1;
	XStoreColor(dpy, cmap, &my_bg);



		my_fg2.red = atoi(rc[RC_button_foreground_red]); my_fg2.green = atoi(rc[RC_button_foreground_green]); my_fg2.blue = atoi(rc[RC_button_foreground_blue]);
		my_fg2.flags = DoRed|DoGreen|DoBlue;
		my_fg2.pixel = PGM_OFFSET +2;
	XStoreColor(dpy, cmap, &my_fg2);

		my_bg2.red = atoi(rc[RC_button_background_red]); my_bg2.green = atoi(rc[RC_button_background_green]); my_bg2.blue = atoi(rc[RC_button_background_blue]);
		my_bg2.flags = DoRed|DoGreen|DoBlue;
		my_bg2.pixel = PGM_OFFSET +3;
	XStoreColor(dpy, cmap, &my_bg2);



        	my_fg1.red = atoi(rc[RC_menu_foreground_red]); my_fg1.green = atoi(rc[RC_menu_foreground_green]); my_fg1.blue = atoi(rc[RC_menu_foreground_blue]);
        	my_fg1.flags = DoRed|DoGreen|DoBlue;
        	my_fg1.pixel = PGM_OFFSET +4;
	XStoreColor(dpy, cmap, &my_fg1);

        	my_bg1.red = atoi(rc[RC_menu_background_red]); my_bg1.green = atoi(rc[RC_menu_background_green]); my_bg1.blue = atoi(rc[RC_menu_background_blue]);
        	my_bg1.flags = DoRed|DoGreen|DoBlue;
        	my_bg1.pixel =  PGM_OFFSET +5;
	XStoreColor(dpy, cmap, &my_bg1);

		my_yellow.red = 65535; my_yellow.green = 65535; my_yellow.blue = 0;
		my_fg1.flags = DoRed|DoGreen|DoBlue;
		my_yellow.pixel = PGM_OFFSET +6;
	XStoreColor(dpy, cmap, &my_yellow);

		my_green.red = 0; my_green.green = 65535; my_green.blue = 0;
		my_green.flags = DoRed|DoGreen|DoBlue;
		my_green.pixel = PGM_OFFSET +7;
	XStoreColor(dpy, cmap, &my_green);

		my_blue.red = 5000; my_blue.green = 20000; my_blue.blue = 55000;
		my_blue.flags = DoRed|DoGreen|DoBlue;
		my_blue.pixel = PGM_OFFSET +8;
	XStoreColor(dpy, cmap, &my_blue);

		my_red.red = 65535; my_red.green = 0; my_red.blue = 0;
		my_red.flags = DoRed|DoGreen|DoBlue;
		my_red.pixel = PGM_OFFSET +9;
	XStoreColor(dpy, cmap, &my_red);
	
	}
	else
	{
*/

/*my_white.pixel = WhitePixel(dpy, DefaultScreen(dpy));
XStoreColor(dpy, cmap, &my_white);

my_black.pixel = BlackPixel(dpy, DefaultScreen(dpy));
XStoreColor(dpy, cmap, &my_black);
*/
       my_bg.red = atoi(rc[RC_main_background_red]); my_bg.green = atoi(rc[RC_main_background_green]); my_bg.blue = atoi(rc[RC_main_background_blue]);
        	my_bg.flags = DoRed|DoGreen|DoBlue;
	        my_bg.pixel = 0;
	XStoreColor(dpy, cmap, &my_bg);

	        my_fg.red = atoi(rc[RC_main_foreground_red]); my_fg.green = atoi(rc[RC_main_foreground_green]); my_fg.blue = atoi(rc[RC_main_foreground_blue]);
        	my_fg.flags = DoRed|DoGreen|DoBlue;
	        my_fg.pixel =  1;
	XStoreColor(dpy, cmap, &my_fg);
		
		my_bg2.red = atoi(rc[RC_button_background_red]); my_bg2.green = atoi(rc[RC_button_background_green]); my_bg2.blue = atoi(rc[RC_button_background_blue]);
		my_bg2.flags = DoRed|DoGreen|DoBlue;
		my_bg2.pixel = PGM_OFFSET +2;
	XStoreColor(dpy, cmap, &my_bg2);


		my_fg2.red = atoi(rc[RC_button_foreground_red]); my_fg2.green = atoi(rc[RC_button_foreground_green]); my_fg2.blue = atoi(rc[RC_button_foreground_blue]);
		my_fg2.flags = DoRed|DoGreen|DoBlue;
		my_fg2.pixel = PGM_OFFSET +3;
	XStoreColor(dpy, cmap, &my_fg2);


	        my_bg1.red = atoi(rc[RC_menu_background_red]); my_bg1.green = atoi(rc[RC_menu_background_green]); my_bg1.blue = atoi(rc[RC_menu_background_blue]);
        	my_bg1.flags = DoRed|DoGreen|DoBlue;
        	my_bg1.pixel =  PGM_OFFSET +4;
	XStoreColor(dpy, cmap, &my_bg1);


        	my_fg1.red = atoi(rc[RC_menu_foreground_red]); my_fg1.green = atoi(rc[RC_menu_foreground_green]); my_fg1.blue = atoi(rc[RC_menu_foreground_blue]);
		my_fg1.flags = DoRed|DoGreen|DoBlue;
        	my_fg1.pixel = PGM_OFFSET +5;
	XStoreColor(dpy, cmap, &my_fg1);

		my_yellow.red = 65535; my_yellow.green = 57000; my_yellow.blue = 15000;
		my_yellow.flags = DoRed|DoGreen|DoBlue;
		my_yellow.pixel = PGM_OFFSET +6;
	XStoreColor(dpy, cmap, &my_yellow);

		my_green.red = 30000; my_green.green = 55535; my_green.blue = 40000;
		my_green.flags = DoRed|DoGreen|DoBlue;
		my_green.pixel = PGM_OFFSET +7;
	XStoreColor(dpy, cmap, &my_green);

		my_blue.red = 0; my_blue.green = 0; my_blue.blue = 65535;
		my_blue.flags = DoRed|DoGreen|DoBlue;
		my_blue.pixel = PGM_OFFSET +8;
	XStoreColor(dpy, cmap, &my_blue);

		my_red.red = 65535; my_red.green = 0; my_red.blue = 0;
		my_red.flags = DoRed|DoGreen|DoBlue;
		my_red.pixel = PGM_OFFSET +9;
	XStoreColor(dpy, cmap, &my_red);
	
/*	}*/



        for(i=0; i<number_of_colors_in_scale; i++)
	{
	        my_drawing_color.red = 16384+(i*164); my_drawing_color.green = 16384+(i*164); my_drawing_color.blue = 16384+(i*164);
                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
                my_drawing_color.pixel = BB_OFFSET+i;
                XStoreColor(dpy, cmap, &my_drawing_color);
	}

/* the spectrum - people tend to like this one and it's really quite nice! */
/*
	for(i=0;i<number_of_colors_in_scale;i++)
	{
		my_drawing_color.red = spectrum[i][0]; my_drawing_color.green = spectrum[i][1]; my_drawing_color.blue = spectrum[i][2];
		my_drawing_color.flags = DoRed|DoGreen|DoBlue;
		my_drawing_color.pixel = SS_OFFSET+i;
		XStoreColor(dpy, cmap, &my_drawing_color);
	}
*/
	return;
}


	
void shade_scale(w, path, area_width, win_height,low_color, high_color, number_of_shades)
Widget w;
int path[4];
int area_width;
int win_height;
char low_color;
char high_color;
int number_of_shades;
{
	int i, curr_x_pos, curr_y_pos;
	int shade_block_x, shade_block_y;
	float shade_multiply;
	dpy = XtDisplay(w);
	gra_win = XtWindow(w);
	XGetWindowAttributes(dpy, gra_win, &xwa);

	cmap = xwa.colormap;
/*TEMP*/
number_of_shades = 200;
	if(area_width< (number_of_shades+2))
	{
		Error(15);
		return;
	}

	if(win_height< 60)
	{
		Error(16);
		return;
	}
	shade_block_y = 20;
	shade_block_x = area_width/(number_of_shades+2);

	XSetForeground(dpy,gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, (4*shade_block_x)-2, win_height-44, (number_of_shades*shade_block_x)+4, shade_block_y+4);

	if(DisplayCells(dpy,  DefaultScreen(dpy)) == 2)
	{
		for(i=0, curr_x_pos = (4*shade_block_x), curr_y_pos = win_height-42; i< number_of_shades; i++, curr_x_pos+=shade_block_x)
		{
			/* yuk coding I know, but no time to make nice ! */
			set_color(w, path, gc, cmap, low_color, high_color, ((float)i+1)/(float)number_of_shades);
			XSetForeground(dpy, gc, my_drawing_color.pixel);
			XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, shade_block_x, shade_block_y);
		}
		return;
	}

	for(i=0, curr_x_pos = (4*shade_block_x), curr_y_pos = win_height-41; i< number_of_shades; i++, curr_x_pos+=shade_block_x)
	{
		/* yuk coding I know, but no time to make nice ! */
		my_drawing_color.pixel = BB_OFFSET +(((float)i+1)*0.995);
		XSetForeground(dpy, gc, my_drawing_color.pixel);
		XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, shade_block_x, shade_block_y);
	}
	return;
}

void SplatColors(dpy, gra_win)
Display *dpy;
Window gra_win;
{
int i;
int number_of_colors_in_scale = 200;
XGetWindowAttributes(dpy, gra_win, &xwa);
cmap = xwa.colormap;

	switch(sys_low_color) {
	case 'm':
		switch(sys_high_color) {
		case 'm':
	        for(i=0; i<number_of_colors_in_scale; i++)
		{
		        my_drawing_color.red = 16384+(i*164); my_drawing_color.green = 16384+(i*164); my_drawing_color.blue = 16384+(i*164);
	                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
	                my_drawing_color.pixel = BB_OFFSET+i;
	                XStoreColor(dpy, cmap, &my_drawing_color);
		}
		return;
		default:
			Error(32);
			return;
		}
		break;
	case 'r':
		switch(sys_high_color) {
		case 'g':
        for(i=0; i<number_of_colors_in_scale; i++)
	{
	        my_drawing_color.red = ((number_of_colors_in_scale-i)*COLOR_STEP)+COLOR_OFFSET; my_drawing_color.green = (i*COLOR_STEP)+COLOR_OFFSET; my_drawing_color.blue = 0;
                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
                my_drawing_color.pixel = BB_OFFSET+i;
                XStoreColor(dpy, cmap, &my_drawing_color);
	}
			return;
			break;
		case 'b':
	for(i=0; i<number_of_colors_in_scale; i++)
	{
	        my_drawing_color.red = ((number_of_colors_in_scale-i)*COLOR_STEP)+COLOR_OFFSET; my_drawing_color.green = 0; my_drawing_color.blue = (i*COLOR_STEP)+COLOR_OFFSET;
                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
                my_drawing_color.pixel = BB_OFFSET+i;
                XStoreColor(dpy, cmap, &my_drawing_color);
	}
			return;
			break;
		default:
        for(i=0; i<number_of_colors_in_scale; i++)
	{
	        my_drawing_color.red = 21845+(i*218); my_drawing_color.green = i*164; my_drawing_color.blue = i*164;
                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
                my_drawing_color.pixel = BB_OFFSET+i;
                XStoreColor(dpy, cmap, &my_drawing_color);
	}
			return;
			break;
		}
		break;
	case 'g':
		switch(sys_high_color) {
		case 'r':
        for(i=0; i<number_of_colors_in_scale; i++)
	{
	        my_drawing_color.red = (i*COLOR_STEP)+COLOR_OFFSET; my_drawing_color.green = ((number_of_colors_in_scale-i)*COLOR_STEP)+COLOR_OFFSET; my_drawing_color.blue = 0;
                my_drawing_color.flags = DoRed|DoGreen|DoBlue;		
                my_drawing_color.pixel = BB_OFFSET+i;
                XStoreColor(dpy, cmap, &my_drawing_color);
	}
			return;
			break;
		case 'b':
        for(i=0; i<number_of_colors_in_scale; i++)
	{
	        my_drawing_color.red = 0; my_drawing_color.green = ((number_of_colors_in_scale-i)*COLOR_STEP)+COLOR_OFFSET; my_drawing_color.blue = (i*COLOR_STEP)+COLOR_OFFSET;
                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
                my_drawing_color.pixel = BB_OFFSET+i;
                XStoreColor(dpy, cmap, &my_drawing_color);
	}
			return;
			break;
		default:
        for(i=0; i<number_of_colors_in_scale; i++)
	{
	        my_drawing_color.red = i*164; my_drawing_color.green = 21845+(i*218); my_drawing_color.blue = i*164;
                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
                my_drawing_color.pixel = BB_OFFSET+i;
                XStoreColor(dpy, cmap, &my_drawing_color);
	}
			return;
		}
		break;
	default:
		switch(sys_high_color) {
		case 'r':
        for(i=0; i<number_of_colors_in_scale; i++)
	{
	        my_drawing_color.red = (i*COLOR_STEP)+COLOR_OFFSET; my_drawing_color.green = 0; my_drawing_color.blue = ((number_of_colors_in_scale-i)*COLOR_STEP)+COLOR_OFFSET;
                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
                my_drawing_color.pixel = BB_OFFSET+i;
                XStoreColor(dpy, cmap, &my_drawing_color);
	}
			return;
			break;
		case 'g':
	        for(i=0; i<number_of_colors_in_scale; i++)
		{
	        	my_drawing_color.red = 0; my_drawing_color.green = (i*COLOR_STEP)+COLOR_OFFSET; my_drawing_color.blue = ((number_of_colors_in_scale-i)*COLOR_STEP)+COLOR_OFFSET;
	                my_drawing_color.flags = DoRed|DoGreen|DoBlue;
        	        my_drawing_color.pixel = BB_OFFSET+i;
                	XStoreColor(dpy, cmap, &my_drawing_color);
		}
			return;
			break;
		default:
	for(i=0; i<number_of_colors_in_scale; i++)
	{
		my_drawing_color.red = i*164; my_drawing_color.green = i*164; my_drawing_color.blue = 21845+(i*218);
		my_drawing_color.flags = DoRed|DoGreen|DoBlue;
		my_drawing_color.pixel = BB_OFFSET+i;
		XStoreColor(dpy, cmap, &my_drawing_color);
	}

	return;
	break;
		}
	}
}
