/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.0 5/2/90 mjh
 *
 * pgm layer level graphic drawing
 *
 * layer_level.c
 ******************************************************************************/

#include "mike_display.h"
#include "everything.h"


extern confres *conf;


/* function that draws an individual layer in the graphic window.  Takes 
 * the full area, unless a connection matrix being shown, in which case 
 * the horizontal shrinks to half the window width. - needs to be passed
 * an area_width which is half that of xwa.width
 */

void draw_layer(w, gc, cmap, mikepath, area_width, win_height, layer_low_color, layer_high_color)
Widget w;
GC gc;
Colormap cmap;
int *mikepath;
int area_width;
int win_height;
char layer_low_color;
char layer_high_color;
{

	int total_layer_neurons, total_neurons_drawn;
	int number_layer_neurons;
	unsigned int number_cluster_neurons;
	unsigned int number_clusters;
	int neuron_width, neuron_height;
	int neuron_drawing_width, neuron_drawing_height;
	int temp1, temp2;
	int i,j, k;
	int curr_x_pos, curr_y_pos;
	rpcsys *rpcconf;
	float *first_attribute;	
	char textlabel[512];
	float neuron_color_scale[2];
	float neuron_color_multiply;
	int number_of_shades = 20;

	rpcconf = conf->confres_u.sys;
	
/* deal with the error case first.  That is, if called with zero clusters.
 * The function is then really a subset of the function draw_net - as it
 * simply draws the specified layer in the available area
 */
	number_clusters = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_len;

	if(number_clusters == 0)
	{	
		/* no clusters! */
		Error(18);
		return;
	}
	else if(number_clusters == 1)
		{
			neuron_width = area_width / (rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_val[0].rpcclu_len +2) ;
			if(neuron_width < 2) 
			{
				/* window too narrow */
				Error(15);
				return;
			}
			total_layer_neurons = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_val[0].rpcclu_len;
		}
		else if(number_clusters > 1)
			{
				/* need to find cluster with the largest number of neurons to get
				 * uniform width for all
				 */

				number_cluster_neurons = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_val[0].rpcclu_len;
				total_layer_neurons = number_cluster_neurons;
				temp1 = number_cluster_neurons;
				for(i=1; i<number_clusters; i++)
				{
					number_cluster_neurons = 0;
				 	number_cluster_neurons = rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_val[i].rpcclu_len;
				 	total_layer_neurons += number_cluster_neurons;
					temp2 = number_cluster_neurons;
					if(temp2 > temp1)
					{
						temp1 = temp2;
					}
				}
				neuron_width = area_width / (temp1+2);
	 			if(neuron_width < 2) 
				{
					/* window too narrow */
					Error(15);
					return;
				}

			}
			
	neuron_height = (win_height-60) / (number_clusters+1) ;

	neuron_drawing_width = ((9*neuron_width)/10);
	neuron_drawing_height = ((9*neuron_height)/10);

	if(neuron_height < 2) 
	{
		/* window too short */
		Error(16);
		return;
	}

	first_attribute = (float *) calloc(sizeof(float), total_layer_neurons);
	SetToState(mikepath, first_attribute);
	GiveNeuronScaleFamily(mikepath, neuron_color_scale);
	
	neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
	
/* now we know the size of a building block, so we can now draw the layer - neurons horizontally, clusters vertically 
 * - have to go this way to have any hope of fitting everything on the screen 
 */
 	
	XSetForeground(dpy,gc, my_fg2.pixel);
	XClearArea(dpy, gra_win, 0, win_height-17, area_width, 16, False);
	XDrawImageString(dpy, gra_win, gc, 5, win_height -4, "wait...", strlen("wait..."));

/* loop that draws a box round the layer */

	for(k=0, number_layer_neurons = 0; k < number_clusters; k++)
	{
		number_layer_neurons += rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_val[k].rpcclu_len;
	}
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, neuron_width-2, (neuron_height/2)-2, ((number_layer_neurons*neuron_width)+3), (neuron_drawing_height+3));
	


	for(i=0,  curr_y_pos = (neuron_height/2), total_neurons_drawn=0; i<number_clusters; i++)
	{
		for(j=0, curr_x_pos = neuron_width; j<rpcconf->rpcsys_val[mikepath[0]].rpcnet_val[mikepath[1]].rpclay_val[i].rpcclu_len; j++, total_neurons_drawn++)
		{
			set_color(w, mikepath, gc, cmap, layer_low_color, layer_high_color, ((first_attribute[total_neurons_drawn]-neuron_color_scale[0])*neuron_color_multiply));
			XSetForeground(dpy, gc, my_drawing_color.pixel);
			XFillRectangle(dpy, gra_win, gc, curr_x_pos, curr_y_pos, neuron_width, neuron_drawing_height);
		 	curr_x_pos += neuron_width;
		}

		curr_y_pos += neuron_height;

	}
	shade_scale(w, mikepath, area_width, win_height, layer_low_color, layer_high_color, number_of_shades);
	XSetForeground(dpy, gc, my_fg.pixel);
	XClearArea(dpy, gra_win, 0, win_height-19, area_width, 18, False);
	sprintf(textlabel, "%c => %c Shading, State (%f,%f)", layer_low_color, layer_high_color, neuron_color_scale[0], neuron_color_scale[1]);
	XDrawImageString(dpy, gra_win, gc, 5, win_height-5, textlabel, strlen(textlabel));

	free(first_attribute);;

	return;
}




/* function that draws a matrix of the connection and weights of aforementioned 
 * between the neurons of one cluster and the neurons of another.  The 
 * two clusters are selected by widget stuff.  If this function is called then
 * the above function, draw_layer must be called also, with a win_width half that
 * of the actual window.  Then the system will be drawn, scaled horizontally to fit
 * in the left half of the window
 */


void draw_layer_connection(w, gc, cmap, mikepath, connpath1, connpath2, area_width, win_height, layer_low_color, layer_high_color)
Widget w;
GC gc;
Colormap cmap;
int mikepath[4];
int connpath1[4];
int connpath2[4];
int area_width;
int win_height;
char layer_low_color;
char layer_high_color;
{
	int curr_x_pos, curr_y_pos;
	int neuron_width, neuron_height;
	int neuron_drawing_width, neuron_drawing_height;
	int shift;		/* right shift for the coords, as this function only uses */
	int i,j;
	int neurons_clusterA;
	int neurons_clusterB;
	int total_weights_drawn;
	int neurons_drawnB;
	rpcsys *rpcconf;
	char textlabel[512];
	float *first_attribute;
	float *second_attribute;
	float *weight_attribute;
	int label_increment;
	float neuron_color_scale[2];
	float weight_color_scale[2];
	float neuron_color_multiply;
	float weight_color_multiply;
	int normalize[2];
	
	int shade_scale = 20;
	rpcconf = conf->confres_u.sys;

/* deal with the error cases first - ie clusterA and or clusterB have no connection */



	shift = area_width/2;
	neurons_clusterA = rpcconf->rpcsys_val[connpath1[0]].rpcnet_val[connpath1[1]].rpclay_val[connpath1[2]].rpcclu_len;

		
	neurons_clusterB = rpcconf->rpcsys_val[connpath2[0]].rpcnet_val[connpath2[1]].rpclay_val[connpath2[2]].rpcclu_len;
	neuron_width = ((shift-50)) / (neurons_clusterA+3);
	if(neuron_width < 2) 
	{
		/* window too narrow */
		Error(15);
		return;
	}		
	neuron_height = (win_height-80) / (neurons_clusterB +3);
	if(neuron_width < 2) 
	{
		/* window too short */
		Error(16);
		return;
	}

	neuron_drawing_width = ((9*neuron_width)/10);
	neuron_drawing_height = ((9*neuron_height)/10);

/* label spacing will be dynamic someday,  taking into account width etc... */

	label_increment = 10;
		
/* need to separate left and right sections, so drawa line between the two. */

	XSetForeground(dpy, gc, my_fg.pixel);
	XSetLineAttributes(dpy, gc, 0, LineSolid, CapRound, JoinMiter);
	XDrawLine(dpy, gra_win, gc, shift, 0, shift, win_height);


	first_attribute = (float *) calloc(sizeof(float), neurons_clusterA);
	second_attribute = (float *) calloc(sizeof(float), neurons_clusterB);
	weight_attribute = (float *) calloc(sizeof(float), neurons_clusterA*neurons_clusterB);		
	
	SetToState(connpath1, first_attribute);
	SetToState(connpath2, second_attribute);
	SetToWeight(connpath1, connpath2, weight_attribute);

	GiveNeuronScaleFamily(mikepath, neuron_color_scale);
	GiveWeightScaleFamily(mikepath, weight_color_scale);

	
	neuron_color_multiply = 1/(neuron_color_scale[1]-neuron_color_scale[0]);
	weight_color_multiply = 1/(weight_color_scale[1]-weight_color_scale[0]);

/* first draw the horizontal scale and label it */

	XSetForeground(dpy, gc, my_fg.pixel);
	sprintf(textlabel, "Cluster %i", connpath1[2]+1);
	XDrawImageString(dpy, gra_win, gc, area_width-60, 12, textlabel, strlen(textlabel));

	for(i=0; i<neurons_clusterA; i+=label_increment)
	{
		XDrawLine(dpy, gra_win, gc, (((2+i)*neuron_width)+shift+50), 14, (((2+i)*neuron_width)+shift+50), 30);
		sprintf(textlabel, "%i", i+1);
		XDrawImageString(dpy, gra_win, gc, (((2+i)*neuron_width)+shift+50), 12, textlabel, strlen(textlabel));
	}

	
	for(i=0; i<neurons_clusterA; i++)
	{
		set_color(w, mikepath, gc, cmap, layer_low_color, layer_high_color, ((first_attribute[i]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
		XFillRectangle(dpy, gra_win, gc, (shift +50+ ((2+i)*neuron_width)), (30+neuron_height), neuron_width, neuron_drawing_height);
	}
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, (shift+50+(2*neuron_width))-2, (28+neuron_height), (i*neuron_width)+3, (neuron_height+2));

/* then draw the vertical scale */

	XSetForeground(dpy, gc, my_fg.pixel);
	sprintf(textlabel, "Cluster %i", connpath2[2]+1);
	XDrawImageString(dpy, gra_win, gc, shift+5, win_height-30, textlabel, strlen(textlabel));

	for(j=0; j<neurons_clusterB; j+=label_increment)
	{
		XDrawLine(dpy, gra_win, gc, shift+30, ((2+j)*neuron_height)+50, shift+45, ((2+j)*neuron_height)+50);
		sprintf(textlabel, "%i", j+1);
		XDrawImageString(dpy, gra_win, gc, shift+5, ((2+j)*neuron_height)+50, textlabel, strlen(textlabel));				
	}

	for(j=0; j<neurons_clusterB; j++)
	{
		set_color(w, mikepath, gc, cmap, layer_low_color, layer_high_color, ((second_attribute[j]-neuron_color_scale[0])*neuron_color_multiply));
		XSetForeground(dpy, gc, my_drawing_color.pixel);
		XFillRectangle(dpy, gra_win, gc, (shift + 47), ((2+j)*neuron_height)+50, neuron_drawing_width, neuron_height);
	}
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, (shift+45), (48+(2*neuron_height)), neuron_drawing_width+4, ((j*neuron_height)+2));
	

	
/* now draw the connection matrix.  It will not be as simple as this as the next loop assumes full 
 * connectivity, which will be rare.  Therefore need to be able to miss out values of i and j
 * basically.  can do this by associating background colour with
 * zero connection, so just paint with bg.  Not as efficient, but  
 * will do for now.
 */
	XSetForeground(dpy,gc, my_fg2.pixel);
        XDrawImageString(dpy, gra_win, gc, shift +5, win_height -5, "drawing ", strlen("drawing "));

	for(i=0, total_weights_drawn = 0, curr_x_pos = shift+50+(2*neuron_width); i<neurons_clusterA; curr_x_pos+=neuron_width,i++)
	{
		for(j=0, curr_y_pos = (2*neuron_height)+50; j<neurons_clusterB; curr_y_pos+=neuron_height,j++, total_weights_drawn++)
		{
			if((weight_attribute[total_weights_drawn] != 1000000.000000))
			{
				set_color(w, mikepath, gc, cmap, layer_low_color, layer_high_color, ((weight_attribute[total_weights_drawn]-weight_color_scale[0])*weight_color_multiply));
			}
			else
			{
				my_drawing_color.pixel = my_bg.pixel;
/*				printf("weight is 1M\n");*/
			}
			XSetForeground(dpy, gc, my_drawing_color.pixel);
			XFillRectangle(dpy, gra_win, gc, curr_x_pos,curr_y_pos, neuron_width, neuron_height);
		}
	}
	XSetForeground(dpy, gc, my_fg.pixel);
	XDrawRectangle(dpy, gra_win, gc, (shift+50+(2*neuron_width)), (2*neuron_height)+48, curr_x_pos-(shift+50+(2*neuron_width)), curr_y_pos-((2*neuron_height)+48));
	
	free(first_attribute);
	free(second_attribute);
	free(weight_attribute);
	XSetForeground(dpy, gc, my_fg.pixel);
        sprintf(textlabel, "Weight (%f, %f)", weight_color_scale[0], weight_color_scale[1]);
        XDrawImageString(dpy, gra_win, gc, shift +5, win_height -5, textlabel, strlen(textlabel));
			
	return;
}


