/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * 
 ******************************************************************************/

#include "everything.h"

/*---------------------------------------------------------*/
/* PROCEDURES HELPING FOR RPC STUFF */
/* AND FOR TEST ON THE NAMES OF THE FILES */
/*---------------------------------------------------------*/


/* EXTERN 1- conf given by RPC call */
extern confres *conf ;


/*----------------------------------------*/
/* THIS PROC  ACCORDING TO A PATH */
/*             GIVES THE LEVEL and only the level */

int GiveLevel(longway)
int longway[] ;
  {

 if (longway[0] == -1 )
		{
		return(0) ;
		} ;
if (longway[0] != -1  && longway[1] == -1)
		{
		return(1) ;
		} ;
if (longway[1] != -1  && longway[2] == -1)
		{
		return(2) ;
		} ;
if (longway[2] != -1  && longway[3] == -1)
		{
		return(3) ;
		} ;
if (longway[3] != -1  )
		{
		return(4) ;
		} ;

 } 

/*----------------------------------------*/
/* THIS PROC CHECKS IF THE PATH GIVEN BY THE USER */
/* IS CORRECT ACCORDING TO THE CONF INFORMATION*/
/* CONF SHOULD BE TAKEN FROM RPC */
int CheckPath(longway, levelchoice)
int longway[] ;
int levelchoice ;
  {
int i ;
int nogood ;  /* test if the user has input enough number */
u_int test[4] ; /* coz the RPC gives back the number as u_int */
rpcsys *rpc_strange_conf ;

 rpc_strange_conf = conf->confres_u.sys ;

for (i = 0 ; i < 4 ; i++)
  test[i] = longway[i] ;

/* At the moment just check that all commponent of path */
/* from 0 to nbe (defining the level) have been assigned */
/* SHOULD CHECK THAT THE NUMBER IS OK */
  nogood = 0 ;

  switch (levelchoice)
	{
/* net */
	case 1 : if (longway[0] == -1) {Error(7) ; return(0);}
		 else {
		if (test[0] >= 
			rpc_strange_conf->rpcsys_len )
		   {
			Error(7) ; return(0) ;
		   } 
                else return(1) ;
		      } ;
 	         break ;
/* layer */
  case 2 : for ( i = 0 ; i<=1 ; i++) 
		{
		if (longway[i] == -1) nogood = 1 ;
		} ;
	 if (nogood) { Error(7) ; return(0) ; } 
if ( (test[0] >= rpc_strange_conf->rpcsys_len ) ||
 (test[1] >= rpc_strange_conf->rpcsys_val[test[0]].rpcnet_len))
	   {
		Error(7) ; return(0) ;
	   } 
	 else return(1) ;
          break ;
/* cluster */
  case 3 : for ( i = 0 ; i<=2 ; i++) 
		{
		if (longway[i] == -1) nogood = 1 ;
		} ;
	 if (nogood) { Error(7) ; return(0) ; } 
if ( (test[0] >= rpc_strange_conf->rpcsys_len ) || (test[1] >= rpc_strange_conf->rpcsys_val[test[0]].rpcnet_len) || (test[2] >= rpc_strange_conf->rpcsys_val[test[0]].rpcnet_val[test[1]].rpclay_len))
	   {
		Error(7) ; return(0) ;
	   } 
	 else return(1) ;
          break ;
/* neuron */
  case 4 : for ( i = 0 ; i<=3 ; i++) 
		{
		if (longway[i] == -1) nogood = 1 ;
		} ;
	 if (nogood) { Error(7) ; return(0) ; } 
if ( (test[0] >= rpc_strange_conf->rpcsys_len ) ||
(test[1] >= rpc_strange_conf->rpcsys_val[test[0]].rpcnet_len) ||
 (test[2] >= rpc_strange_conf->rpcsys_val[test[0]].rpcnet_val[test[1]].rpclay_len) ||
 (test[3] >= rpc_strange_conf->rpcsys_val[test[0]].rpcnet_val[test[1]].rpclay_val[test[2]].rpcclu_len))
	   {
		Error(7) ; return(0) ;
	   } 
	 else return(1) ;
          break ;
  } ;	
 }


/* THIS PROC, GIVEN A PATH  GIVES */
/*	1- the number of nets (if it is system level ) */
/* 	2- the number of layers (if net path ) */
/*      3- the number of clusters (if layer path) */
/*      4- the number of neurons  (if cluster path ) */
u_int GiveNumber(currentpath )
int currentpath[] ;
{
u_int trick[4] ; /* same story about type of what RPC gives me */
int i ;
rpcsys *rpc_strange_conf ;  /* to get the conf information from RPC */

 rpc_strange_conf = conf->confres_u.sys ;

for ( i = 0 ; i < 4 ; i++)
	trick[i] = currentpath[i] ;

switch (GiveLevel(currentpath))
    {
/* system level give number of net */
    case 0 : return(rpc_strange_conf->rpcsys_len) ;
	     break ;
/* net level give number of layers */
    case 1 : return(rpc_strange_conf->rpcsys_val[trick[0]].rpcnet_len) ;
	     break ;
/* layer level give number of cluster */
    case 2 : return(rpc_strange_conf->rpcsys_val[trick[0]].rpcnet_val[trick[1]].rpclay_len) ;
	     break ;
/* cluster level give number of neurons */
    case 3 : return(rpc_strange_conf->rpcsys_val[trick[0]].rpcnet_val[trick[1]].rpclay_val[trick[2]].rpcclu_len) ;
	     break ;
   } ;
}

/* THIS PROC GIVEN THE CURRENT CONFIG GIVES */
/* THE TOTAL NUMBER OF NEURONS AT THE LEVEL GIVEN */
/* AND THE PATH */
  int GiveTotal(scale , path)
  int scale  ;
  int path[4] ;
  {
  int net , layer , cluster , total ;

  total = 0 ;

  switch (scale)
   {
/* system level => gives back the overall number of neurons */
   case 0 :
   for ( net = 0 ; net < conf->confres_u.sys->rpcsys_len ; net++)
   for ( layer = 0 ;
        layer < conf->confres_u.sys->rpcsys_val[net].rpcnet_len ;
        layer++)
   for ( cluster = 0 ;
    cluster < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_len;
       cluster++)

total = conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_val[cluster].rpcclu_len + total ;

        return(total) ;
        break ; 
/* net level => gives back the number of neurons within that net */
   case 1 :
   net = path[0] ;
   for ( layer = 0 ;
        layer < conf->confres_u.sys->rpcsys_val[net].rpcnet_len ;
        layer++)
   for ( cluster = 0 ;
    cluster < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_len;
       cluster++)
          
total = conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_val[cluster].rpcclu_len + total ;

        return(total) ;
          break ; 
/* layer level => gives back the number of neurons within that layer */
   case 2 :
   net = path[0] ; layer = path[1] ;
   for ( cluster = 0 ;
    cluster < conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_len;
       cluster++)
          
total = conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_val[cluster].rpcclu_len + total ;

        return(total) ;
          break ; 
/* cluster  level => gives back the number of neurons  within that cluster */
   case 3 :
   net = path[0] ; layer = path[1] ; cluster = path[2] ;
total = conf->confres_u.sys->rpcsys_val[net].rpcnet_val[layer].rpclay_val[cluster].rpcclu_len ;
        
        return(total) ;
          break ; 
   
/* neuron level => gives back the number of neurons  within that neuron !!*/
   case 4 : return(1) ;
            break ;

  } /* end of switch */

}

/* This proc given a path gives the maximum number of substructure */
/* system => number of nets */
/* net		=> max number of layer */
/* layer		=> max number of cluster */
/* cluster      => max number of neurons >10 in any case    */
u_int GiveMaxNumber(path)
int path[4] ;
   {
   int max ;
   int again , another , count ;
   int meaculpa[4] ;
   int meatest , titest , ontest ;

   max = 0 ;

   for (another = 0 ; another < 4 ; another++)
      meaculpa[another] = -1  ;

   switch (GiveLevel(path) )
	{
/* system level => max number of nets */
     case 0 : return(GiveNumber(path)) ;

/* net level => max number of layers */
     case 1 :
/* for every net get the number of layers */
      meatest = GiveNumber(meaculpa) ;
      for (another = 0 ; another < meatest ; another++)
      {
      meaculpa[0] = another  ; 
      if (max < GiveNumber(meaculpa)) ;
          max = GiveNumber(meaculpa) ;
      } ;
      return(max) ; 
      break ;

/* layer level => max number of clusters */
    case 2 :
/* for every net for every layers get the max nbe of clusters */
      meatest = GiveNumber(meaculpa) ;
      for (another = 0 ; another < meatest ; another++)
      {
        meaculpa[0] = another ;
        titest = GiveNumber(meaculpa) ;
        for (again = 0 ; again < titest ; again++)
      	 {
     	  meaculpa[1] = again ;
          if (max < GiveNumber(meaculpa) ) ;
             max = GiveNumber(meaculpa) ;
          } ;
      }
      return(max) ; 
      break ;

    case 3 :
          max = 10  ;
      return(max) ; 
      break ;
   default :
          max = 10  ;
         return(max) ; 
      break ;

   } ;

  }

int Mybitcount(anint)
unsigned anint ;
 {
 int count ;
 unsigned theone ;

 theone = anint ;

 for (count = 0 ; theone!=0 ; theone>>=1)
    if (theone & 01) count++ ;

  return(count) ;

  }

/*-------------------------------------------------------*/
/* ABOUT TEST ON FILENAMES 				 */
/*-------------------------------------------------------*/
/* Procedure that takes 			*/
/* 	which file  0=> application , 			*/
/*		    1 => data (load and save)    	*/
/*		    2=> configuration */
/* 		    3 => input				*/
/*  return 1 If correct ending of the file */
/*         0 otherwise			  */
/*-------------------------------------------------------*/

  int CorrectName(which , name)
  int which ;
  char *name ;
  {
  int ending ;

  ending = strlen(name) ;

/* if filename empty => error */
  if (!ending )
	{
	Error(70) ;
	return(0) ;
	} ;


  switch (which)
	{

/* application filename => should end with .appli */
	case 0 :
  		if (name[ending-1] != 'i' ||
			name[ending-2] != 'l' ||
			name[ending-3] != 'p' ||
			name[ending-4] != 'p' ||
			name[ending-5] != 'a' 
 		   )
			{
        		Error(71) ;
			return(0) ;
			} 
		else return(1) ;
	 	break ;

/* data filename => should end with .data */
	case 1 :
  		if (name[ending-1] != 'a' ||
			name[ending-2] != 't' ||
			name[ending-3] != 'a' ||
			name[ending-4] != 'd'
 		   )
			{
        		Error(72) ;
			return(0) ;
			} 
		else return(1) ;
	 	break ;

/* configuration filename => should end with .config */
	case 2 :
  		if (name[ending-1] != 'g' ||
			name[ending-2] != 'i' ||
			name[ending-3] != 'f' ||
			name[ending-4] != 'n' ||
			name[ending-5] != 'o' ||
			name[ending-6] != 'c' 
 		   )
			{
        		Error(73) ;
			return(0) ;
			} 
		else return(1) ;
	 	break ;

/* input filename => should end with .input */
	case 3 :
  		if (name[ending-1] != 't' ||
			name[ending-2] != 'u' ||
			name[ending-3] != 'p' ||
			name[ending-4] != 'n' ||
			name[ending-5] != 'i' 
 		   )
			{
        		Error(74) ;
			return(0) ;
			} 
		else return(1) ;
	 	break ;

/* target machine name => just testthat name is not empty*/
	case 4 :
		return(1) ;
	 	break ;

    	default : return(1) ;
	 	break ;


	} ;

}

 	
/*-------------------------------------------------------*/
/* Procedure that takes 			*/
/* 	a filename					*/
/* and returns     0=> application filename ,		*/
/*		    1 => data (load and save) filename 	*/
/*		    2=> configuration filename */
/* 		    3 => input filename			*/
/*-------------------------------------------------------*/

  int WhatName(name)
  char *name ;
  {
  int ending ;

  ending = strlen(name) ;

/* if filename empty => error */
  if (!ending )
	{
	Error(70) ;
	return(0) ;
	} ;


/* application filename => should end with .appli */
	if (name[ending-1] == 'i' && 
		name[ending-2] == 'l' && 
		name[ending-3] == 'p' && 
		name[ending-4] == 'p' && 
		name[ending-5] == 'a' 
 	   )
		{
		return(0) ;
		} ;

/* data filename => should end with .data */
	if (name[ending-1] == 'a' && 
		name[ending-2] == 't' && 
		name[ending-3] == 'a' && 
		name[ending-4] == 'd'
 	   )
		{
		return(1) ;
		} ;

/* configuration filename => should end with .config */
  	if (name[ending-1] == 'g' && 
		name[ending-2] == 'i' && 
		name[ending-3] == 'f' && 
		name[ending-4] == 'n' && 
		name[ending-5] == 'o' &&
		name[ending-6] == 'c' 
 	   )
		{
		return(2) ;
		} ;

/* input filename => should end with .input */
  	if (name[ending-1] == 't' &&
		name[ending-2] == 'u' && 
		name[ending-3] == 'p' && 
		name[ending-4] == 'n' && 
		name[ending-5] == 'i' 
 	   )
		{
		return(3) ;
		} ; 


}

