/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * TresholdOption.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"

/*----------------------------------------------------*/
/* THIS PROCEDURE TAKES A TRESHOLD VALUE IN CAASE OF MONOCHROM */
/*----------------------------------------------------*/

/* Structure to be known by the callbacks */

  typedef struct
             {
                int mews[4] ;
                Widget death;
                Widget tres_dialog;
              } ExtraStruct ;

  static ExtraStruct *Necessity ;
/* Args for Threstoptop_totake, shell widget */
Arg Threstoptoptotake_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
                {XtNlabel, (XtArgVal)"IO menu"},
		{XtNmappedWhenManaged, (XtArgVal)False},
		{XtNborderWidth, (XtArgVal) 4},
        };
Arg Threstotake_arg[] = {
                {XtNvertDistance, (XtArgVal)1},
                {XtNfromVert, (XtArgVal)NULL},
                {XtNlabel, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)10},
	        {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvalue, (XtArgVal)""},
                {XtNheight, (XtArgVal)IO_TAKE_HEIGHT},
                {XtNwidth, (XtArgVal)IO_TAKE_WIDTH},
	        {XtNdestroyCallback, (XtArgVal)NULL},
};
	

/*----------------------------------------------------*/
/* CONFIRM CALLBACK TO KILL THE DIALOG WIDGET AND MORE*/
  void Confirmation_tres(initiateur, client_data, call_data)
  Widget initiateur;
  caddr_t client_data;  /* all arg needed */
  caddr_t call_data;     /* not used  */
  {
  char *treshold ;
  float tres_value ;
  double atof() ;

 treshold= XtDialogGetValueString(Necessity->tres_dialog) ;


/* the treshold value is taken as a char => translate into float */
 tres_value = atof(treshold) ;

/* Fill the theshold famil;y */
  FillThreshold(Necessity->mews, tres_value) ;
/* call Update */
 UpdateLevelWindow(Necessity->mews, 1) ;

/* Pop down everything */
/*      XtPopdown(client_data) ; */
/*  XtPopdown(Necessity->death) ; */
/*XUngrabKeyboard(XtDisplay(client_data), CurrentTime);*/

 XtUnmapWidget(client_data);
 XtUnmapWidget(Necessity->death) ;
    free(Necessity) ;
   }


/*----------------------------------------------------*/
/* CANCEL CALLBACK TO KILL THE DIALOG WIDGET */
  void Cancelation_tres(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used to pass the top widget */
  caddr_t call_data;     /* not used  */
  {

/*XUngrabKeyboard(XtDisplay(client_data), CurrentTime);*/
/* Pop down everything */
  XtUnmapWidget(client_data);
  XtUnmapWidget(Necessity->death) ;
/*      XtPopdown(client_data) ;
      XtPopdown(Necessity->death) ;
*/
    free(Necessity) ;
  }

/*----------------------------------------------*/
/* TAKE A NEW TRESHOLD VALUE			*/
/*----------------------------------------------*/
/* wid1  = the widget which initiates this proc 
 * avenue = the route of the Window 
 */
void TakeTreshold(wid1 ,avenue)
Widget wid1 ;
int avenue[4] ;
{
Widget  Threstoptop_totake ,
	  top_totake ,
		cancelation, 
		confirmation,
		take_caution ;

 char texte[200]  ;
 int counter ;
extern Arg Threstoptoptotake_arg[5];
extern Arg Threstotake_arg[9];

Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;

/* Change the cursor */
 Cursor thecursor ; Display *thedisplay ; Window thewindow ;

/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/
/*----------------------------------------------*/
/* ARGUMENTS 					*/ 
/*----------------------------------------------*/

/* Args for top_totake, form widget */
static Arg toptotake_arg[] = {
                {XtNlabel, (XtArgVal)"bof"},
                {XtNdestroyCallback, (XtArgVal)NULL},
	} ;

static Arg canceltotake_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
        };


static Arg confirmtotake_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)10},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
        };



   strcpy(texte , " Enter Treshold Value" ) ;

/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(wid1, relativeX , relativeY , &theX , &theY) ;
 
 XtSetArg(Threstoptoptotake_arg[0],XtNx, theX) ;
 XtSetArg(Threstoptoptotake_arg[1],XtNy, theY + 5) ;
*/
/*----------------------------------------------*/
/* CREATE 					*/ 
/*----------------------------------------------*/
    Threstoptop_totake = XtCreatePopupShell("toptoptakeinput",
                                overrideShellWidgetClass,
                                wid1,
                                Threstoptoptotake_arg,
                                XtNumber(Threstoptoptotake_arg));

       top_totake = XtCreateManagedWidget("toptakeinput",
                                formWidgetClass,
                                Threstoptop_totake,
                                toptotake_arg,
                                XtNumber(toptotake_arg));

  XtSetArg(Threstotake_arg[2],XtNlabel, texte ) ;

          take_caution = XtCreateManagedWidget("takecaut1",
                                dialogWidgetClass,
                                top_totake,
                                Threstotake_arg,
                                XtNumber(Threstotake_arg));

 XtSetKeyboardFocus(Threstoptop_totake , take_caution ) ;

 XtSetArg(canceltotake_arg[0],XtNfromVert, take_caution ) ;

	  cancelation= XtCreateManagedWidget(" CANCEL ",
                                commandWidgetClass,
                                top_totake,
                                canceltotake_arg,
                                XtNumber(canceltotake_arg));

 XtSetArg(confirmtotake_arg[0],XtNfromVert, take_caution ) ;
 XtSetArg(confirmtotake_arg[1],XtNfromHoriz, cancelation) ;

	   confirmation= XtCreateManagedWidget("  OK  ",
                                commandWidgetClass,
                                top_totake,
                                confirmtotake_arg,
                                XtNumber(confirmtotake_arg));

/* Assign the callback argument */

  Necessity=(ExtraStruct *) calloc(sizeof(ExtraStruct), 1 ) ;
/* initialise path for the call back */
 for ( counter = 0 ; counter < 4 ; counter++ )
  {
  Necessity->mews[counter] = avenue[counter] ;
  } ;
 Necessity->death = wid1 ;
 Necessity->tres_dialog = take_caution;


/* Add the callback in order to have the widget Threstoptop_totake */
/* known by the callback in order to Pop it down */
  XtAddCallback(confirmation, XtNcallback,
                Confirmation_tres, (caddr_t)Threstoptop_totake) ;

/* Add the callback in order to have the widget Threstoptop_totake */
/* known by the callback in order to Pop it down */
  XtAddCallback(cancelation, XtNcallback,
                Cancelation_tres, (caddr_t)Threstoptop_totake) ;


/* REALIZE */
/* XtPopup(Threstoptop_totake, XtGrabNone) ;*/
XtRealizeWidget(Threstoptop_totake);
XQueryPointer(XtDisplay(Threstoptop_totake), XtWindow(Threstoptop_totake), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(Threstoptoptotake_arg[0],XtNx, x_root-20) ;
XtSetArg(Threstoptoptotake_arg[1],XtNy, y_root-20) ;
XtSetValues(Threstoptop_totake, Threstoptoptotake_arg, XtNumber(Threstoptoptotake_arg));
XtMapWidget(Threstoptop_totake);
XGrabKeyboard(XtDisplay(Threstoptop_totake), XtWindow(take_caution), True, GrabModeAsync, GrabModeAsync, CurrentTime);

/* Change the cursor ; beomes an arrow */
  thedisplay = XtDisplay(confirmation) ;
  thewindow = XtWindow(confirmation) ;
  thecursor = XCreateFontCursor(thedisplay , XC_hand2 ) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

  thedisplay = XtDisplay(cancelation) ;
  thewindow = XtWindow(cancelation) ;
  thecursor = XCreateFontCursor(thedisplay , XC_pirate ) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

}

