/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 2/90
 *
 * pgm 
 *
 * StepCont_control.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"
#include "mike_display.h"

/*----------------------------------------------*/
/* THIS PROC DEALS WITH 			*/
/*	1- The creation of the STEP & CONTINUOUS button     */
/*	2- The callbacks = ()   */
/*      3- The effect = */
/*----------------------------------------------*/

/* SHOULD BE IN AN MY HEADER.H */
extern Bool end_application ; 
extern char application_filename[200] ; 

/* Extern for Parser Application program */
  extern FILE *yyin ;

/* Needs that declaration coze at soon as config and/or system is loaded */
/* conf is used by many procedures for checking different thing */
  extern CLIENT *myclient;
  extern char server[];
  extern confres *conf;      /* conf is the information from the RPC */



/* Args for top_confirm , shell widget */
 Arg topconfirm_arg[] = {
                {XtNx, (XtArgVal)NULL},
                {XtNy, (XtArgVal)NULL},
                {XtNlabel, (XtArgVal)"IO menu"},
        };

/*----------------------------------------------*/
/* EXTERN for the 1- father widget		*/
/* 	          2- form neighbour		*/
/* 		  3- the created widget itself 	*/
/*				STEP, CONTINUOUS */
extern Widget simulation ;
extern Widget title_simulation ;
extern Widget patset;
extern Widget step;
extern Widget continuous;


extern Bool just_pause ;

/* global coze fed up of declaration */
 char glob[200] ;

/*--------------------------------------------------------------*/
/* FAKE PROCEDURE FOR BATCH EXECUTION */
/*--------------------------------------------------------------*/
yywrap()
{
        printf("%s\n" , yylex() );
        return(1);
}

/*--------------------------------------------------------------*/
  void AppliInitPat(theparam)
  char *theparam;
  {
  char another[200] ;

printf("Should init pat descriptors %s\n" ,theparam) ;
 /*  Load Input Specification file */
/* SetInput takes the filename (ie thefile) and then retrieve from */
/* it the number of patterns in that file and read the first pat */

/* try with just_pause */ 
    just_pause = False ;
 
/* test if you can load a set of patterns */
  if (!my_algorithm || !my_configuration)
        {
        Error(14) ;
        return ;
        } ;

/* test on the filename */
   if ( !CorrectName(3, theparam) )
        {
        return;
        } ;

/* Display the current instruction */
    sprintf(glob , "%s/%s" , "init_pattern" , theparam) ;
  Add_information(9, glob) ;

  loadinput = 1 ;
/* Refer the filename as to be from pgm pattern directory */
        sprintf(another , "%s/%s" , rc[RC_pattern_directory], theparam) ;
        SetInput(another) ;
        Add_information(1,theparam) ;

 }


/*--------------------------------------------------------------*/
  void AppliPause()
  {

   just_pause = True ;
   end_application = False ;

/* HERE I should pop up that message */
printf("In pause\n") ;

/* Display the current instruction */
  Add_information(9, "pause") ;



  } 

/*--------------------------------------------------------------*/
  void AppliRepeat()
  {
  char another[200] ;

printf("In repeat\n") ;

/* try with just_pause */ 
    just_pause = False ;

/* Refer the filename as to be from the correct directory */
    sprintf(another , "%s/%s" , rc[RC_application_directory], 
			application_filename) ;

/* start the lex stuff with the filename "another" */
   if (!(yyin = fopen(another, "r")))
        {
               Error(81) ;
               return;
        }

  } 
/*--------------------------------------------------------------*/
  void AppliReadInput(theparam)
  char *theparam;
  {
  int index ;
 
/* try with just_pause */ 
    just_pause = False ;

/* test if you have initialise patterns */
  if ( !loadinput )
        {
        Error(28) ;
        return ;
        } ;

printf("Should read input %s\n" ,theparam) ;
  index = atoi(theparam) ;

/* Display the current instruction */
    sprintf(glob , "%s/%s" , "read_input " , theparam) ;
  Add_information(9, glob) ;

printf("the index is %i\n" ,index) ;
  LoadAppliInput(index) ;
 }

/*--------------------------------------------------------------*/
  void AppliReadTarget(theparam)
  char *theparam;
  {
  int index ;

/* try with just_pause */ 
    just_pause = False ;

/* test if you have initialise patterns */
  if ( !loadinput )
        {
        Error(28) ;
        return ;
        } ;

printf("Should read target %s\n" ,theparam) ;
  index = atoi(theparam) ;

/* Display the current instruction */
    sprintf(glob , "%s/%s" , "read_target " , theparam) ;
  Add_information(9, glob) ;

printf("the index is %i\n" ,index) ;
  LoadAppliTarget(index) ;

   }

/*--------------------------------------------------------------*/
  void AppliExec(theparam)
  char *theparam;
  {
  int i , mews[4] ;
  char another[200] ;

/* try with just_pause */ 
    just_pause = False ;

/* test if algorithm and config(or system) have been loaded */
  if (!my_algorithm || !my_configuration)
     {
	Error(85) ;
	return ;
     } ;

printf("Should exec rule name %s\n" ,theparam) ;

/* Display the current instruction */
    sprintf(glob , "%s/%s" , "exec rule  " , theparam) ;
  Add_information(9, glob) ;

/* At the moment ONLY SYSTEM OR  NET RULE ARE EXECUTED */
  for (i = 0 ; i < 4 ; i++) mews[i] = -1 ;

/* if only one net => net level */
 if (GiveNumber(mews) == 1) mews[0] = 0 ;

printf("Should exec rule at net if 0 shown%i\n" ,mews[0]) ;

/* exec the rule that matches the rule name of the net level */
/* See AppliExecRule.c */
    AppliRuleExec(theparam , mews) ;

   }

/*--------------------------------------------------------------*/
  void AppliSave(theparam)
  char *theparam;
  {
  char another[200] ;

/* try with just_pause */ 
    just_pause = False ;

printf("Should save in file %s\n" ,theparam) ;
/* test on the filename */
   if ( !CorrectName(1, theparam) )
        {
        return;
        } ;

/* Display the current instruction */
    sprintf(glob , "%s/%s" , "save_system " , theparam) ;
  Add_information(9, glob) ;


/* Save the result */
    sprintf(another , "%s/%s" , 
		rc[RC_nn_save_directory], theparam) ;
    ChangSave(another) ;

  }

/*--------------------------------------------------------------*/
  void AppliLoad(theparam)
  char *theparam;
  {
  char another[200] ;

  fname str ;
/* try with just_pause */ 
    just_pause = False ;

printf("Should load in file %s\n" ,theparam) ;
/* test on the filename */
   if ( !CorrectName(1, theparam) )
        {
        return;
        } ;

/* test if you have the right to load a system ie algo loaded ?? */
        if (!my_algorithm)
        {
                Error(4) ;
                return ;
        }
        my_configuration = True ;

/* Display the current instruction */
    sprintf(glob , "%s/%s" , "load_system " , theparam) ;
  Add_information(9, glob) ;
 
/* Load the system */
    sprintf(another , "%s/%s" , 
		rc[RC_nn_save_directory], theparam) ;
        switch ( ChangInit(another) )

        {
        case -1 : Error(299) ; return ;
        case 0  : return ;
        } ;


/* RPC Call to get the configuration of the NN system */
            conf = rsysconf_1(str, myclient);
            if (!conf)
                {
               clnt_perror(myclient, server);
                return;
                }
            if (conf->errorn != 0)
                {
                Error(203) ;
                return;
                } ;
/* State that weights and states are from loaded file */
    Add_information(2, theparam) ;
 }

/*--------------------------------------------------------------*/
  void AppliConfig(theparam)
  char *theparam;
  {
  char another[200] ;
  fname str ;

/* try with just_pause */ 
    just_pause = False ;

printf("Should load config%s\n" ,theparam) ;
/* test on the filename */
   if ( !CorrectName(2, theparam) )
        {
        return;
        } ;

/* test if you have the right to load a system ie algo loaded ?? */
        if (!my_algorithm)
        {
                Error(4) ;
                return ;
        }
        my_configuration = True ;

/* Display the current instruction */
    sprintf(glob , "%s/%s" , "load_config " , theparam) ;
  Add_information(9, glob) ;


/* Load the system */
    sprintf(another , "%s/%s" , 
		rc[RC_configuration_directory], theparam) ;
        switch ( ChangInit(another) )

        {
        case -1 : Error(299) ; return ;
        case 0  : return ;
        } ;

/* RPC Call to get the configuration of the NN system */
            conf = rsysconf_1(str, myclient);
            if (!conf)
                {
               clnt_perror(myclient, server);
                return;
                }
            if (conf->errorn != 0)
                {
                Error(203) ;
                return;
                } ;

  }
/*--------------------------------------------------------------*/
  void AppliRandom()
  {

/* try with just_pause */ 
    just_pause = False ;

printf("Should randomize the weights \n") ;

/* Display the current instruction */
  Add_information(9, "Randomise weights") ;

/* Randomise the weights */
    MagaliRandWeight() ;
   

  }
/*--------------------------------------------------------------*/
/* CONFIRM and CANCEL CALLBACK */
/*--------------------------------------------------------------*/
  void Confirm_callback( thecaller, client_data, call_data)
  Widget thecaller ;
  Widget client_data ; /* the menu to pop up ; ie top_control */
  caddr_t call_data ;
  {
  int ret ;

/* CHANGE 1 => was at the end of that procedure */
XtUnmapWidget(client_data);
/* if all the instructions in application have been executed */
  if (end_application && !just_pause)
     { 
     Error(83) ;
     return ;
     } ;

  Add_information(4," Continuous") ;

/* test to fake execution of application program */
  while ((ret=yylex()) != 1 )
     {
     } ;


  if (!just_pause) end_application = True ;
  if (end_application) Add_information(4," Ended") ;
  else  Add_information(4," Pause") ;

/*  XtPopdown(client_data) ;*/
   } 

  void Cancel_callback( thecaller, client_data, call_data)
  Widget thecaller ;
  Widget client_data ; /* the menu to pop up ; ie top_control */
  caddr_t call_data ;
  {
/*  XtPopdown(client_data) ;*/
XtUnmapWidget(client_data);
  }
 
/*--------------------------------------------------------------*/
/* CONFIRM CONTINUOUS MENU				*/
/*----------------------------------------------*/
  void ContinuousConfirm(mother)
  Widget mother ; 
  {
/*  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/
  char buffy[200] ;
  char another[200] ;

  Widget topconfirm ,
	  fakeconfirm , 
	   confirm_text ,
	   cancel , confirm ;

extern Arg topconfirm_arg[3];
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;

/* Args for fake_confirm, form widget */
  static Arg fakeconfirm_arg[] = {
                {XtNlabel, (XtArgVal)"bof"},
          };

/* Args for confirm_text, text widget */
  static Arg confirmtext_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNfile, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)1},
                {XtNheight, (XtArgVal)ERROR_HEIGHT},
                {XtNwidth, (XtArgVal)ERROR_WIDTH},

        };

  static Arg confirm_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)10},
        };

  static Arg cancel_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)1},
        };

/* if all the instructions in application have been executed */
/* do not pop up Confirm and all that stuff */
  if (end_application && !just_pause)
     { 
     Error(83) ;
     return ;
     } ;

/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(mother, relativeX , relativeY , &theX , &theY) ;

 XtSetArg(topconfirm_arg[0],XtNx, theX) ;
 XtSetArg(topconfirm_arg[1],XtNy, theY + 5) ;
*/
/*----------------------------------------------*/
/* CREATE                                       */
/*----------------------------------------------*/
    topconfirm = XtCreatePopupShell("topt",
                                overrideShellWidgetClass,
                                mother,
                                topconfirm_arg,
                                XtNumber(topconfirm_arg));

       fakeconfirm = XtCreateManagedWidget("",
                                formWidgetClass,
                                topconfirm,
                                fakeconfirm_arg,
                                XtNumber(fakeconfirm_arg));

 XtSetArg(confirmtext_arg[0],XtNfromVert, NULL ) ;
 XtSetArg(confirmtext_arg[1],XtNfromHoriz, NULL ) ;
 sprintf(buffy , "%s/%s" ,rc[RC_error_message_directory] , "MSG.continuous") ;
 XtSetArg(confirmtext_arg[2],XtNfile, buffy ) ;
       confirm_text = XtCreateManagedWidget("",
                                asciiDiskWidgetClass,
                                fakeconfirm,
                                confirmtext_arg,
                                XtNumber(confirmtext_arg));

 XtSetArg(cancel_arg[0],XtNfromVert,confirm_text ) ;
 XtSetArg(cancel_arg[1],XtNfromHoriz,NULL ) ;
       cancel = XtCreateManagedWidget(" Cancel ",
                                commandWidgetClass,
                                fakeconfirm,
                                cancel_arg,
                                XtNumber(cancel_arg));
  XtAddCallback(cancel, XtNcallback,
                Cancel_callback, (caddr_t)topconfirm) ;


 XtSetArg(confirm_arg[0],XtNfromVert, confirm_text ) ;
 XtSetArg(confirm_arg[1],XtNfromHoriz, cancel ) ;
       confirm= XtCreateManagedWidget(" Confirm ",
                                commandWidgetClass,
                                fakeconfirm,
                                confirm_arg,
                                XtNumber(confirm_arg));
  XtAddCallback(confirm, XtNcallback,
                Confirm_callback, (caddr_t)topconfirm) ;

/* map */
/*  XtPopup(topconfirm, XtGrabExclusive) ;*/
XtRealizeWidget(topconfirm);
XQueryPointer(XtDisplay(topconfirm), XtWindow(topconfirm), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(topconfirm_arg[0],XtNx, x_root-20) ;
XtSetArg(topconfirm_arg[1],XtNy, y_root-20) ;
XtSetValues(topconfirm, topconfirm_arg, XtNumber(topconfirm_arg));
XtMapWidget(topconfirm);

  }


/*----------------------------------------------*/
/*--------------------------------------------------------------*/
/* STEP and CONTINUOUS  CALL BACK                         	*/
/*----------------------------------------------*/
  void Step_callback( thecaller, client_data, call_data)
  Widget thecaller ;
  caddr_t client_data ; /* the menu to pop up ; ie top_control */
  caddr_t call_data ;
  {
  int ret ;

/* if all the instructions in application have been executed */
  if (end_application && !just_pause)
     { 
     Error(83) ;
     Add_information(4," Ended") ;
     return ;
     } ;

     end_application = False ; /* because of pause can have wrongly */
				/* became True */
     Add_information(4," Stepwise") ;

/* should now execute the appli program step by step */
/* Fake execution of one instruction */
/* for step ie one click => one exec */
  if ( (ret = yylex() ) == 1 )
     {
     end_application = True ;
     if (!just_pause) Error(80) ;
     } ;

   } 

  void Continuous_callback( thecaller, client_data, call_data)
  Widget thecaller ;
  caddr_t client_data ; /* the menu to pop up ; ie top_control */
  caddr_t call_data ;
  {
/* should pop up a confirm continuous */
/* and if the answer is yes should start the execution */
     ContinuousConfirm(thecaller) ;
   } 

/*-----------------------------------------------------*/
/* ARGUMENTS FOR STEP and CONTINUOUS widget				*/
/*-----------------------------------------------------*/

/* Args for step and continuous widget */
    Arg step_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNmappedWhenManaged, (XtArgVal)False},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNvertDistance, (XtArgVal)2},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH+3},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
        };

    Arg continuous_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNmappedWhenManaged, (XtArgVal)False},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNvertDistance, (XtArgVal)2},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH+3},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
        };

/*-----------------------------------------------------*/
/* CREATION OF THE START 				*/
/*-----------------------------------------------------*/
  void StepCont()
  {
/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String button_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations button_compiled ;


   XtSetArg(step_arg[0],XtNfromVert, title_simulation) ;
   XtSetArg(step_arg[1],XtNfromHoriz, patset) ;

        step = XtCreateManagedWidget(" Step ",
                                commandWidgetClass,
                                simulation,
                                step_arg,
                                XtNumber(step_arg));

/* "Compile" the call back */
XtAddCallback(step, XtNcallback, 
	Step_callback,(caddr_t)NULL) ;


   XtSetArg(continuous_arg[0],XtNfromVert, step) ;
   XtSetArg(continuous_arg[1],XtNfromHoriz, patset) ;

        continuous = XtCreateManagedWidget("Continuous",
                                commandWidgetClass,
                                simulation,
                                continuous_arg,
                                XtNumber(continuous_arg));


/* "Compile" the call back */
XtAddCallback(continuous, XtNcallback, 
	Continuous_callback,(caddr_t)NULL) ;

/* Compilation of the translation table for init */
  button_compiled = XtParseTranslationTable(button_trans) ;
  XtOverrideTranslations(step, button_compiled) ;
  XtOverrideTranslations(continuous, button_compiled) ;

} 
