/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.01 30/1/90
 *
 * pgm 
 *
 * Run_control.c
 ******************************************************************************/

#include "everything.h"
#include "myheader.h"
#include "mike_display.h"

/*----------------------------------------------*/
/* THIS PROC DEALS WITH 			*/
/*	1- The creation of the RUN button     */
/*	2- The callback = (open Level Window)   */
/*      3- The effect = call Monitor at system or net (if only one) level */
/*----------------------------------------------*/


/*----------------------------------------------*/
/* EXTERN for the 1- father widget		*/
/* 	          2- form neighbour		*/
/* 		  3- the created widget itself 	*/
/*				START           */
extern Widget simulation ;
extern Widget title_simulation ;
extern Widget patset;
extern Widget pgmrun ;
extern Widget pause;
extern Widget pause;
extern Widget ssave;
extern Arg ssave_arg[];

/*-----------------------------------------------------------*/
/* ACTION MYPOPDOWN() = Popdown the (step , continuous) menu */
/* 				alias top_control	     */
/*-----------------------------------------------------------*/
void MypopdownPgmrun(thewidget, event, params ,num_params)
Widget thewidget;
XEvent *event ;
String *params ;
Cardinal *num_params ;
{
 XtPopdown(thewidget) ;
}

/*--------------------------------------------------------------*/
/* PAUSE CALL BACK 		                        	*/
/*----------------------------------------------*/
  void Execution_pause(w, client_data, call_data)
  Widget w;
  caddr_t client_data;  /* not used */
  caddr_t call_data;    /* not used */
  {
      Error(0) ;
/* if ( overallstatus == 'R')
 *              { overallstatus = 'S' ; Add_information(4,"Pause") ; }
 *      else Error(1) ;
 */
  }

/*-----------------------------------------------------*/
/* ARGUMENTS FOR PAUSE widget			*/
/*-----------------------------------------------------*/

/* callback for pause  widget */
        static XtCallbackRec pausecallback[] = {
                {Execution_pause, NULL},
                {NULL, NULL},
        };

/* Args for pause widget */
        Arg pause_arg[] = {
                {XtNcallback, (XtArgVal)pausecallback},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNfromVert, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH+3},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
                {XtNsensitive, (XtArgVal)False},
                {XtNmappedWhenManaged, (XtArgVal)False},
        };


/*  Comment= On top of this callback Monitor_create(0 or 1) is called */
/*----------------------------------------------*/
/*--------------------------------------------------------------*/
/* PGMRUN CALL BACK 		                        	*/
/*  where widget "pgmrun" has been created in proc name= Pgmrun() */
/*----------------------------------------------*/
  void Pgmrun_callback( thecaller, client_data, call_data)
  Widget thecaller ;
  caddr_t client_data ; /* the menu to pop up ; ie top_control */
  caddr_t call_data ;
  {
  int trypath[4] ;

/* create a system path in order to pop a system or net level window */
  trypath[0] = -1  ; trypath[1] = -1  ;
  trypath[2] = -1  ; trypath[3] = -1  ;

/* if no algorithm or configuration loaded then can not run */
  if ( (!my_configuration) || (!my_algorithm) )
   Error(10) ;
  else
   {
/* execute if simulation is either suspended (change mode) */
/*                         or empty (run from scratch  ) */


    switch (overallstatus)
	{
	case 'R': Error(1) ;
		break ;
	case 'E': mode = 'S' ; 
		  overallstatus = 'S' ;
			/* GIVE SIMUL ORDER step */
		  Add_information(4," STARTED ") ;
/* if there is only one net then first window to open = net window */
                 if (GiveNumber(trypath) == 1 ) trypath[0] = 0 ;
		 Monitor_create(trypath) ;
		break ;
/* the simul is suspended */
	case 'S': mode = 'S' ;  /* GIVE SIMUL ORDER step */
		  overallstatus = 'S' ;
		 Add_information(4," STARTED ") ; 
		break ;
	} ;
	XtSetArg(pause_arg[9], XtNsensitive, (XtArgVal) True);
	XtSetValues(pause, pause_arg, 10);
	XtSetArg(ssave_arg[9], XtNsensitive, (XtArgVal) True);
	XtSetValues(ssave, ssave_arg, 10);

   } ;

/* Core dumped in the callback when  XtPopdown(thekilled) ;*/
} 


/*-----------------------------------------------------*/
/* ARGUMENTS FOR RUN widget			*/
/*-----------------------------------------------------*/

	static XtCallbackRec pgmruncallback[] = {
		{Pgmrun_callback, (XtArgVal) NULL},
		{NULL, NULL},
	};

/* Args for pgmrun widget */
    Arg pgmrun_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNhighlightThickness, (XtArgVal)3},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)pgmruncallback},
                {XtNvertDistance, (XtArgVal)2},
                {XtNhorizDistance, (XtArgVal)4},
                {XtNwidth, (XtArgVal)BUTTON_WIDTH+3},
                {XtNheight, (XtArgVal)BUTTON_HEIGHT},
		{XtNsensitive, (XtArgVal)False},
                {XtNmappedWhenManaged, (XtArgVal)False},
        };


/*-----------------------------------------------------*/
/* CREATION OF THE START 				*/
/*-----------------------------------------------------*/
  void Pgmrun()
  {
/* BTN1UP = DEFAULT + RESET otherwise does not unhighlight */
/* Declaration of the translation table for init */
  static String button_trans = "<Btn1Up>: notify() unset() reset()" ;
  XtTranslations button_compiled ;


   XtSetArg(pgmrun_arg[0],XtNfromVert, title_simulation) ;
   XtSetArg(pgmrun_arg[1],XtNfromHoriz, patset) ;

        pgmrun = XtCreateManagedWidget(" Run  ",
                                commandWidgetClass,
                                simulation,
                                pgmrun_arg,
                                XtNumber(pgmrun_arg));

/* Compilation of the translation table for init */
  button_compiled = XtParseTranslationTable(button_trans) ;
  XtOverrideTranslations(pgmrun, button_compiled) ;


/* "Compile" the call back */
XtAddCallback(pgmrun, XtNcallback, 
	Pgmrun_callback,(caddr_t)NULL) ;


 XtSetArg(pause_arg[3],XtNfromHoriz, patset) ;
 XtSetArg(pause_arg[5],XtNfromVert, pgmrun) ;

        pause = XtCreateManagedWidget("Pause",
                                commandWidgetClass,
                                simulation,
                                pause_arg,
                                XtNumber(pause_arg));


} 
