/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * FamilyFilled.c
 ******************************************************************************/

#include "myheader.h"
#include "mymonitor.h"

/* CAUTION => Restrictions on the number of level window which can be open */
#define MAX_WIDGET 26 /* maximum number of level window which can be open */

/*----------------------------------------------------*/
/* THESES PROC TAKE CARE ABOUT THE FAMILY OF WIDGET TO */
/* UPDATE DURING THE EXECUTION                        */
/* 1- Filled_family => updates the family of opened Level Windows	*/
/* 2- Find_deepest => returns the level of the deepest opened Level Window */ 
/* 3- CloseFamily => deletes from thefamily the LWindow which has been closed */
/* 4- UpdateLevelWindow => finds the LWindow to update and sends orders */ 
/*----------------------------------------------------*/

 FamilyUpdate thefamily ;

/*----------------------------------------*/
/* Set the family at the beginning of the session */
  void SetUpdate() 
  {
  int i , j ;

  for ( i = 0 ; i < MAX_WIDGET ; i++ )
    for ( j = 0 ; j < 4 ; j++ )
     thefamily.associated_path[i][j] = -2 ;

  }


/*----------------------------------------*/
/* THIS PROC filled the array of existing level windows */

  void Filled_family(a_path , a_widget) 
  int a_path[4] ;
  Widget a_widget ;
  {
  int wid , compo ;
 
/* If beginning of a session then init the family before filling it */  
  if (!connect_session) { connect_session = 1 ; SetUpdate() ; } ;

/* Assign to a path and a widget the first non-assignided element of */
/* thefamily array */
  for ( wid = 0 ; wid < MAX_WIDGET ; wid++) 
     if (thefamily.associated_path[wid][0] == -2  )
	{
        thefamily.widgetid[wid] = a_widget ;
        thefamily.connect_flag[wid] = 0 ;   /* False */
        thefamily.mattrix_flag[wid] = 0 ;   /* False */
        for (compo = 0 ; compo < 4 ; compo++) 
          {
	  thefamily.associated_path[wid][compo] = a_path[compo] ;
          thefamily.first_path[wid][compo] = -1 ;
          thefamily.second_path[wid][compo] = -1 ;
          } ;
        return ; /* get out of the for loop */
 	} ;	
   }


/*----------------------------------------*/
/* THIS PROC according to thefamily of existing level windows */
/* finds the level of the deepest level window */
/* 0= system , 1= net , 2= layer , 3=cluster , 4=neuron */
  int FindDeepest() 
  {
  int wid_nbe , compo ;
  int depth ;

  /* system is the default depth */ 
  depth = 0 ;

  for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
    {
     if ( thefamily.associated_path[wid_nbe][0] != -2 ) 
         {
         depth = GiveLevel(thefamily.associated_path[wid_nbe]) ;
         }  
     else 
         {
        return(depth) ;
         } ;  
    }
  }  


/*----------------------------------------*/
/* THIS PROC deletes from thefamily  the one which has just been closed */
/* PRBE => ADD THEE WIDGET ID COZ TWO WINDOW CAN HAVE THE SAME PATH */
  void CloseFamily(a_path) 
  int a_path[4] ;
  {
  int wid_nbe , compo ;
  int i , end ;

/* find the entry to be deleted */
for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
 if ( CompareRoute(thefamily.associated_path[wid_nbe] , a_path) 
   )
    end = wid_nbe ;
 }
/* Delete one entry => shift the array */
for (wid_nbe = end +1 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
/* shift widget id */
 thefamily.widgetid[wid_nbe -1] = 
		thefamily.widgetid[wid_nbe] ;

/* shift connect flag*/
 thefamily.connect_flag[wid_nbe -1] = 
		thefamily.connect_flag[wid_nbe] ;
for (i = 0 ; i < 4 ; i++ )
/* shift the three paths */
 thefamily.associated_path[wid_nbe - 1][i] =  
      thefamily.associated_path[wid_nbe][i]  ;
 thefamily.first_path[wid_nbe - 1][i] =  
      thefamily.first_path[wid_nbe][i]  ;
 thefamily.second_path[wid_nbe - 1][i] =  
      thefamily.second_path[wid_nbe][i]  ;
  }

 }


/*----------------------------------------*/
/* THIS PROC filled the first and second path when a */
/* connectivity mattrix has been asked */

  void Fill_connect_family(a_path , a_widget , first_path , second_path) 
  int a_path[4] ;
  Widget a_widget ;
  int first_path[4] ;
  int second_path[4] ;
  {
  int wid_nbe , i ,  theone ;
 
/* Find the widget where the connection mattrix has been asked */
for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
 if (
thefamily.associated_path[wid_nbe][0] == a_path[0]  
 &&
thefamily.associated_path[wid_nbe][1]  == a_path[1] 
 && 
thefamily.associated_path[wid_nbe][2] == a_path[2]  
 && 
thefamily.associated_path[wid_nbe][3] == a_path[3]
 && 
thefamily.widgetid[wid_nbe] == a_widget  
   )
    theone = wid_nbe ;
 } ;

/* Assign flag , first_path and second_path */
	  thefamily.connect_flag[theone] = 1 ;
  for( i = 0 ; i < 4 ; i++)
         {
          thefamily.first_path[theone][i] = first_path[i] ;
          thefamily.second_path[theone][i] = second_path[i] ;
         } ;
}

/*----------------------------------------*/
/* THIS PROC unfilled the connect flag (set back to 0 ) */

  void Unfill_connect_family(a_path , a_widget ) 
  int a_path[4] ;
  Widget a_widget ;
  {
  int wid_nbe , i ,  theone ;
 
/* Find the widget where the connection mattrix has to be deleted */
for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
 if (
thefamily.associated_path[wid_nbe][0] == a_path[0]  
 &&
thefamily.associated_path[wid_nbe][1]  == a_path[1] 
 && 
thefamily.associated_path[wid_nbe][2] == a_path[2]  
 && 
thefamily.associated_path[wid_nbe][3] == a_path[3]
 && 
thefamily.widgetid[wid_nbe] == a_widget  
   )
    theone = wid_nbe ;
 } ;

/* Unassign flag  */
	  thefamily.connect_flag[theone] = 0 ;
}

/*----------------------------------------*/
/* THIS PROC unfilled the matrix  flag (set back to 0 ) */

  void Unfill_dim_flag(a_path , a_widget ) 
  int a_path[4] ;
  Widget a_widget ;
  {
  int wid_nbe , i ,  theone ;
 
/* Find the widget where the mattrix display has to be deleted */
for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
 if (
thefamily.associated_path[wid_nbe][0] == a_path[0]  
 &&
thefamily.associated_path[wid_nbe][1]  == a_path[1] 
 && 
thefamily.associated_path[wid_nbe][2] == a_path[2]  
 && 
thefamily.associated_path[wid_nbe][3] == a_path[3]
 && 
thefamily.widgetid[wid_nbe] == a_widget  
   )
    theone = wid_nbe ;
 } ;

/* Unassign flag  */
	  thefamily.mattrix_flag[theone] = 0 ;
}

/* Procedure wich */
/*     According to a path */
/*             returns 0 if no connection */
/*             returns 1 if connection */

/* Procedure wich */
/*     According to a path and a widget id */
/*     Gives Mike a flag (True = connection mattrix exists) */ 
/*                two path representing component 1 and 2 */
  void FindForMike( receive_path , receive_wid , give_flag ,
                    give_path1 , give_path2 )
  int receive_path[4] ;
  Widget receive_wid ;
  int *give_flag ;
  int give_path1[4] ;
  int give_path2[4] ;

  {

  int i , theone , wid_nbe ;

/* Find the widget concerned */
for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
 if ( CompareRoute(thefamily.associated_path[wid_nbe] , receive_path) 
     && 
       thefamily.widgetid[wid_nbe] == receive_wid
    )
    theone = wid_nbe ;
   } ;

/* fill give flag and path to give back to Mike */
  *give_flag = thefamily.connect_flag[theone] ;
  for (i = 0 ; i < 4 ; i++)
   {
   give_path1[i] = thefamily.first_path[theone][i] ;
   give_path2[i] = thefamily.second_path[theone][i] ;
   } ;
}


/*----------------------------------------*/
/* This proc according to 2 paths tells you if */
/*   the second path is infant of the first */
/* e.g path(0,-1,-1,-1) , path(0,1,-1,-1) => infant = true */
/*     path(0,1,-1,,-1) , path(0,2,-1,-1) => infant = false */
/*     path(0,1,-1,,-1) , path(0,-1,-1,-1) => infant = true */

 int Infant(path1 , path2)
 int path1[4] ; 
 int path2[4] ;
 {
 int i ;

 i = 0 ;
 if (path1[i] == -1 ) return(1) ; /* If system all is infant */
 while( path1[i] != -1 )
      {
      if (path2[i] != path1[i]) return(0) ;
      i = i + 1 ;
      } ;
 return(1) ;
 }

/*----------------------------------------*/
/* This proc according to two  path tells you if */
/*   the second  path is father of the first  */
/*     path(0,1,-1,,-1) , path(0,-1,-1,-1) => aparente = true */
 int Aparente(path1 , path2)
 int path1[4] ; 
 int path2[4] ;
 {
 int level ;

 level = GiveLevel(path1) ;

 switch (level)
 {
/* system => no parent */
 case 0 : return(0) ;

/* net => system is the only parent */
 case 1 : if (path2[0] == -1 ) return(1)  ;
          else return(0) ;

/* layer => system, net where the layer is are parent*/
 case 2 : switch(GiveLevel(path2) )
   		{
		case 0 : return(1) ;
		case 1 : if (path1[0] == path2[0]) return(1) ;
			 else return(0) ;
                 } ;

/* cluster => system, net and layer where the cluster is are parent*/
 case 3 : switch(GiveLevel(path2) )
   		{
		case 0 : return(1) ;
		case 1 : if (path1[0] == path2[0]) return(1) ;
			 else return(0) ;
		case 2 : if ( (path1[1] == path2[1]) && (path1[0] == path2[0]) )
				return(1) ;
			 else return(0) ;
                 } ;

/* neuron => system, net and layer and cluster where the neuron is are parent*/
 case 4 : switch(GiveLevel(path2) )
   		{
		case 0 : return(1) ;
		case 1 : if (path1[0] == path2[0]) return(1) ;
			 else return(0) ;
		case 2 : if ( (path1[1] == path2[1]) && (path1[0] == path2[0]) )
				return(1) ;
			 else return(0) ;
		case 3 : if ( (path1[1] == path2[1]) && (path1[0] == path2[0]) 
			    && (path1[2] == path2[2] ) )
				return(1) ;
			 else return(0) ;
                 } ;

 } ; 


}


/*----------------------------------------*/
/* THIS PROC according to a level of execution */
/*                     and a path              */
/*      1- finds the set of Level Windows (level_display) to update */
/*      2- Sends the orders to Mike work 			   */

  void UpdateLevelWindow(a_path , a_level) 
  int a_path[4] ; /* this is the path where the rule has been called from */
  int a_level ; /* 0=> system; 1=>net; 2=> layer; 3=> cluster; >=4=>neuron */
  {
  int wid_nbe , compo ;

/* Execute rule at a level => Update all displays which are infant of that */
/*  level  */
  for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
      {
      if (thefamily.associated_path[wid_nbe][0] == -2 )
         return ;
      else
       {
      if (Infant(a_path , thefamily.associated_path[wid_nbe]) ||
   	  Aparente(a_path , thefamily.associated_path[wid_nbe])
         ) 
        {
        refresh_window(thefamily.widgetid[wid_nbe] ,
                     thefamily.associated_path[wid_nbe] ,
		     thefamily.connect_flag[wid_nbe] ,
		     thefamily.first_path[wid_nbe] ,
		     thefamily.second_path[wid_nbe] ) ;
        } ;
       } ;
      } ;


  } 

/*----------------------------------------*/
/* THIS PROC filled the dmension of mattrix */
/* It is called from load pattern (MagaliPattern.c) */
/* BUT will be used */
/* ONLY when the flag will be set (ie menu in leveldisplay) */

  void Fill_dim_family(width_dim, height_dim) 
  int width_dim[2] ;
  int height_dim[2] ;
  {
 
   thefamily.input_dim[0] = width_dim[0] ;
   thefamily.output_dim[0] = width_dim[1] ;
   thefamily.input_dim[1] = height_dim[0] ;
   thefamily.output_dim[1] = height_dim[1] ;


  }

/*----------------------------------------*/
/* THIS PROC filled the flag when a */
/* mattrix display  has been asked */

  void Fill_dim_flag(a_path , a_widget ) 
  int a_path[4] ;
  Widget a_widget ;
  {
  int wid_nbe , i ,  theone ;
 
/* Find the widget where the mattrix display  has been asked */
for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
 if (
thefamily.associated_path[wid_nbe][0] == a_path[0]  
 &&
thefamily.associated_path[wid_nbe][1]  == a_path[1] 
 && 
thefamily.associated_path[wid_nbe][2] == a_path[2]  
 && 
thefamily.associated_path[wid_nbe][3] == a_path[3]
 && 
thefamily.widgetid[wid_nbe] == a_widget  
   )
    theone = wid_nbe ;
 } ;

/* Assign flag */
	  thefamily.mattrix_flag[theone] = 1 ;

  }

/*----------------------------------------*/
/* Procedure wich */
/*     According to a path and a widget id */
/*     Gives Mike a flag (True = mattrix display asked ) */ 
/*                two int[2] representing the input/output */
/*				mattrix dimension */
  void MattrixMike( receive_path , receive_wid , give_flag ,
                    give_dim1 , give_dim2 )
  int receive_path[4] ;
  Widget receive_wid ;
  int *give_flag ;
  int give_dim1[2] ;
  int give_dim2[2] ;

  {

  int i , theone , wid_nbe ;

/* Find the widget concerned */
for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
 if ( CompareRoute(thefamily.associated_path[wid_nbe] , receive_path) 
     && 
       thefamily.widgetid[wid_nbe] == receive_wid
    )
    theone = wid_nbe ;
   } ;

/* fill give flag and dim to give back to Mike */
  *give_flag = thefamily.mattrix_flag[theone] ;
  for (i = 0 ; i < 2 ; i++)
   {
   give_dim1[i] = thefamily.input_dim[i] ;
   give_dim2[i] = thefamily.output_dim[i] ;
   } ;

 }

/*----------------------------------------*/
/* Procedure wich */
/*     According to a path and a widget id */
/*     Gives back 0 if matrix display off   */
/*		  1  otherwise             */
  int ToKnowMatrix( receive_path , receive_wid )
  int receive_path[4] ;
  Widget receive_wid ;
  {

  int i , theone , wid_nbe ;

/* Find the widget concerned */
for (wid_nbe = 0 ; wid_nbe < MAX_WIDGET ; wid_nbe++)
 {
 if ( CompareRoute(thefamily.associated_path[wid_nbe] , receive_path) 
     && 
       thefamily.widgetid[wid_nbe] == receive_wid
    )
    theone = wid_nbe ;
   } ;

   return(thefamily.mattrix_flag[theone]) ;

}
