/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * ExecPattern.c
 ******************************************************************************/

#include "myheader.h"

/*----------------------------------------------*/
/* THIS PROC DISPLAYS AS COMMAND WIDGET ALL THE PATTERN FILENAME */
/* AND ALLOWS THE USER TO SELECT WHICH ONE HE WANTS TO EXECUTE THE RULE WITH */
/*-----------------------------------------------------------*/

/* Declaration of the structure for callback argument */
  typedef struct {
  		  Widget dead ;
                  int  toexecute ;
                  int update_path[4] ;
                  int patcounter ;
		 } AgainNice ;         	

/* Args for exectop_control menu widget */
Arg exectop_control_arg[] = {
                {XtNx, (XtArgVal)0},
                {XtNy, (XtArgVal)0},
        };
  

/*----------------------------------------------*/
/* CALL BACK OF ANY COMMAND  PATTERN               */
/*---------------------------------------------*/
/* ANYPAT_CALLBACK() = */

  void Anypat_all_callback(initiateur, client_data, call_data)
  Widget initiateur;
  AgainNice *client_data;  /* cf allneeds*/
  caddr_t call_data;     /* not used  */
  {

/* if readpat is needed then call it */
/* and in any case execute the rule */
 
  if ( NeedRead(client_data->patcounter) ) 
     LoadPatViaAll() ;

     UpdateLevelWindow(client_data->update_path , 1) ;
     UpdateParamWindow(client_data->update_path) ;
     MagaliExecute(client_data->toexecute) ;
     UpdateLevelWindow(client_data->update_path , 1) ;
     UpdateParamWindow(client_data->update_path) ;
  } 

  void Anypat_input_callback(initiateur, client_data, call_data)
  Widget initiateur;
  AgainNice *client_data;  /* cf allneeds*/
  caddr_t call_data;     /* not used  */
  {

/* if readpat is needed then call it */
/* and in any case execute the rule */
 
  if ( NeedRead(client_data->patcounter) ) 
     LoadPatViaInput() ;

     UpdateLevelWindow(client_data->update_path , 1) ;
     UpdateParamWindow(client_data->update_path) ;
     MagaliExecute(client_data->toexecute) ;
     UpdateLevelWindow(client_data->update_path , 1) ;
     UpdateParamWindow(client_data->update_path) ;
  } 

/*---------------------------------------------*/
/* STOP EXECUTION CALLBACK               */

  void Stop_callback(initiateur, client_data, call_data)
  Widget initiateur;
  Widget client_data;  /* used as thepopup */
  caddr_t call_data;     /* not used  */
  {
          overallstatus = 'S' ;
/*     XtPopdown(client_data) ;
*/
XtUnmapWidget(client_data);
  } 
/*---------------------------------------------------*/
/*---------------------------------------------------*/

  void ExecWithPattern(thecaller, apointer , apath , which) 
  Widget thecaller ;
  int apointer ;
  int apath[4] ;
  int which ;   /* 0 => recall rule read input only */
  		/* 1 => learn rule read input AND target */
  {
  Widget  exectop_control ,
	    control , 
            *everypat , stop_exec ;

  AgainNice **PatArgument ; /* has to be a pointer because callback*/
	                /* argument are cast and a struct can not be cast */
  int i , counter ;
  char bypass[150] ;
  char *beforebypass ;
extern Arg exectopcontrol_arg[2];
Window junk_win;
int x_root, y_root,garbage;
unsigned int garbage_mask;


 /* ENTER ANY COMMAND WINDOW = HIGHLIGHT */
  static String command_trans = "<EnterWindow>: set()" ;
  XtTranslations command_compiled ;

/* Change the cursor */
  Cursor thecursor ; Display *thedisplay ; Window thewindow ;
/*
  Position *relativeX , *relativeY ;
  Position theX ,theY ;
*/

/* obligation for the control widget not to have a NULL size */
        static Arg control_arg[] = {
/* MIKE CHANGE */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;

/* Arguments for the children of the Form*/
/* Args for any command widget */
        static Arg anycommand_arg[] = {
                {XtNfromVert, (XtArgVal)NULL},
                {XtNfromHoriz, (XtArgVal)NULL},
                {XtNvertDistance, (XtArgVal)1},
                {XtNhorizDistance, (XtArgVal)2},
/* MIKE CHANGE for foreground */
                {XtNdestroyCallback, (XtArgVal)NULL},
                } ;

/*  relativeX = 0 ;
  relativeY = 0 ;
 XtTranslateCoords(thecaller , relativeX , relativeY , &theX , &theY ) ;

theX = theX + (BUTTON_WIDTH - 8) ;
theY = theY + (BUTTON_HEIGHT - 6) ;

 XtSetArg(exectop_control_arg[0],XtNx, theX) ;
 XtSetArg(exectop_control_arg[1],XtNy, theY) ;
*/
        exectop_control = XtCreatePopupShell("Pattern Menu",
                                overrideShellWidgetClass,
                                thecaller,
                                exectop_control_arg,
                                XtNumber(exectop_control_arg));


       control = XtCreateManagedWidget("PATTERN MENU",
				formWidgetClass,
				exectop_control,
				control_arg,
				XtNumber(control_arg));

/* Create as many pattern command widget as needed */
 if (TotalPattern() == 0)
    {
    Error(51) ;
    overallstatus = 'S' ;
    return ;
    } ;
    
/* Allocation fo the memory space 1- for the widgets */
/*              2- for the pointer to SCalback */

  everypat = (Widget *) calloc( sizeof(Widget) , TotalPattern()) ;
  PatArgument = (AgainNice **) calloc(sizeof(AgainNice *), TotalPattern());
  for ( counter = 0 ; counter < TotalPattern() ; counter++ )
   PatArgument[counter] = ( AgainNice *) calloc(sizeof(AgainNice) , 1) ;

/* Assign  the fields of the callback argument */
 for (counter = 0 ; counter < TotalPattern() ; counter++)
   {
   PatArgument[counter]->dead = exectop_control ;
   PatArgument[counter]->toexecute = apointer ;
   for (i = 0 ; i < 4 ; i++) 
        PatArgument[counter]->update_path[i] = apath[i];
   } ;

/* Creation loop */ 
  for (counter = 0 ; counter < TotalPattern() ; counter++) 
   {
    if (counter >= 1 )
    XtSetArg(anycommand_arg[0],XtNfromVert, everypat[counter-1]) ;
    else
     XtSetArg(anycommand_arg[0],XtNfromVert, NULL) ;

/* assign the name of that pattern */
/* if which is 0 => recall => input only */
  if (!which)
    GiveInpName(counter , &beforebypass) ;
  else
    GivePatName(counter , &beforebypass) ;

    everypat[counter] = XtCreateManagedWidget(
                             beforebypass, 
                             commandWidgetClass,
                             control,
                             anycommand_arg,
                             XtNumber(anycommand_arg));

        PatArgument[counter]->patcounter = counter  ;

/* according if read input only or not */
  if (which)
        XtAddCallback(everypat[counter], XtNcallback,
          Anypat_all_callback, (caddr_t)PatArgument[counter]) ;
  else
        XtAddCallback(everypat[counter], XtNcallback,
          Anypat_input_callback, (caddr_t)PatArgument[counter]) ;

    }  ;


 XtSetArg(anycommand_arg[0],XtNfromVert, everypat[TotalPattern() -1]) ;
 XtSetArg(anycommand_arg[1],XtNfromHoriz, NULL) ;
           stop_exec = XtCreateManagedWidget("    Exit ?   ", 
                                commandWidgetClass,
                                control,
                                anycommand_arg,
                                XtNumber(anycommand_arg) );
XtAddCallback(stop_exec, XtNcallback,
                Stop_callback, (caddr_t)exectop_control) ;


/* compiled the new translation */
  command_compiled = XtParseTranslationTable(command_trans) ;
  for (counter = 0 ; counter < TotalPattern() ; counter++) 
    XtOverrideTranslations(everypat[counter], command_compiled) ;
  XtOverrideTranslations(stop_exec, command_compiled) ;


/* REALIZE  */
/*  XtPopup(exectop_control, XtGrabNone) ;*/
XtRealizeWidget(exectop_control);
XQueryPointer(XtDisplay(exectop_control), XtWindow(exectop_control), &junk_win, &junk_win, &x_root, &y_root, &garbage, &garbage, &garbage_mask);
XtSetArg(exectop_control_arg[0],XtNx, x_root-20) ;
XtSetArg(exectop_control_arg[1],XtNy, y_root-20) ;
XtSetValues(exectop_control, exectop_control_arg, XtNumber(exectop_control_arg));
XtMapWidget(exectop_control);

/* Change the cursor ; becomes an arrow */
  thedisplay = XtDisplay(control) ;
  thewindow = XtWindow(control) ;
  thecursor = XCreateFontCursor(thedisplay , XC_sb_right_arrow) ;
  XDefineCursor(thedisplay, thewindow , thecursor) ;

}

