/******************************************************************************/
/**									     **/
/**		      Copyright 1989 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**				                			     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission     **/
/** Thomson-CSF								     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.0 24/11/89
 *
 * pgm calling and initialisation of graphic area, and event interaction
 *     with widget stuff, translation tables and the like
 *
 * Display.c
 ******************************************************************************/


#include "mike_display.h"
#include "everything.h"



/* the function refresh_window below is called to do the right stuff when the window is resized, redrawn etc.,
 * but NOT initialally redrawn when opened.  It is also called during execution of the network, when the 
 * states/weights of the open windows changes .  The function is very similar to redraw_graphic_window function, 
 * it just gets it's args differently - redraw_graphic_window forgets about the connection side of the window
 * when recalled - this function gets this stuff from a structure, by providing a widget id and a path.  It 
 * was necesaary to add this function to be able to keep connctions in the window during execution 
 */

void refresh_window(w, mikepath, connection, connpath1, connpath2)
Widget w;
int mikepath[4];
int connection;
int connpath1[4];
int connpath2[4];
{
	int i;
	int x,y;
	int level;
	int matrix;
	int matrix1[2];
	int matrix2[2];
	

	dpy = XtDisplay(w);
	gra_win = XtWindow(w);
	XGetWindowAttributes(dpy, gra_win, &xwa);
        x = xwa.width;
        y = xwa.height;
	cmap = xwa.colormap;

	if(DisplayCells(topdpy,  DefaultScreen(topdpy)) > 2)
	{
		SplatColors(dpy, gra_win);
	}
	MattrixMike(mikepath, w, &matrix, matrix1, matrix2);
	
	level = GiveLevel(mikepath);
	XDefineCursor(dpy, gra_win, level_window_wait_cursor);

	switch(level) {
	case 0:
		if(connection == False)
		{
			if(prev_sys_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_system(w, gc, cmap, mikepath, x, y, sys_low_color, sys_high_color);
			prev_sys_conn = False;
		}
		else
		{
			if(!prev_sys_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_system(w, gc, cmap, mikepath, x/2, y, sys_low_color, sys_high_color);
        		draw_system_connection(w, gc, cmap, mikepath, connpath1, connpath2, x, y, sys_low_color, sys_high_color);
			prev_sys_conn = True;
		}
		break;
		
	case 1:
		if(connection == False)
		{
			if(prev_net_conn)
			{
				XClearWindow(dpy, gra_win);
			}

			if(matrix == False)
			{
				if(prev_matrix_layer)
				{
					XClearArea(dpy, gra_win, 0, 0, x, y-60, False);
					draw_net(w, gc, cmap, mikepath, x, y, net_low_color, net_high_color);
					prev_matrix_layer = False;
				}
				else
				{
					draw_net(w, gc, cmap, mikepath, x, y, net_low_color, net_high_color);
				}
			}
			else
			{
				if(prev_matrix_layer)
				{
					draw_matrix_layers(w, gc, cmap, mikepath, matrix1, matrix2, x, y, net_low_color, net_high_color);
				}
				else
				{
					XClearArea(dpy, gra_win, 0, 0, x, y-60, False);
					draw_matrix_layers(w, gc, cmap, mikepath, matrix1, matrix2, x, y, net_low_color, net_high_color);
					prev_matrix_layer = True;
				}
			}

			prev_net_conn = False;
		}
		else
		{	
			if(!prev_net_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			if(matrix == False)
			{

				if(prev_matrix_layer)
				{
					XClearArea(dpy, gra_win, 0, 0, x/2, y-60, False);
				}
				draw_net(w, gc, cmap, mikepath, x/2, y, net_low_color, net_high_color);
				draw_net_connection(w, gc, cmap, mikepath, connpath1, connpath2, x, y, net_low_color, net_high_color);
				prev_matrix_layer = False;
			}
			else
			{
				if(prev_matrix_layer)
				{
					draw_matrix_layers(w, gc, cmap, mikepath, matrix1, matrix2, x/2, y, net_low_color, net_high_color);
					draw_net_connection(w, gc, cmap, mikepath, connpath1, connpath2, x, y, net_low_color, net_high_color);
				}
				else
				{
					XClearArea(dpy, gra_win, 0,0, x/2, y-60, False);
					draw_matrix_layers(w, gc, cmap, mikepath, matrix1, matrix2, x/2, y, net_low_color, net_high_color);
					prev_matrix_layer = True;
				}
			}

			prev_net_conn = True;
		}
		break;
		
	case 2:
		if(connection == False)
		{
			if(prev_layer_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_layer(w, gc, cmap, mikepath, x, y, layer_low_color, layer_high_color);
			prev_layer_conn = False;
		}
		else
		{	
			if (!prev_layer_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_layer(w, gc, cmap, mikepath, x/2, y, layer_low_color, layer_high_color);
			draw_layer_connection(w, gc, cmap, mikepath, connpath1, connpath2, x, y, layer_low_color, layer_high_color);
			prev_layer_conn = True;
		}
		break;

	case 3:
		if(connection == False)
		{
			if(prev_cluster_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_cluster(w, gc, cmap, mikepath, x, y, cluster_low_color, cluster_high_color);
			prev_cluster_conn = False;
		}
		else
		{
			if(!prev_cluster_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_cluster(w, gc, cmap, mikepath, x/2, y, cluster_low_color, cluster_high_color );
			draw_cluster_connection(w, gc, cmap, mikepath, connpath1, connpath2,  x, y, cluster_low_color, cluster_high_color );
			prev_cluster_conn = True;
		}
		break;

	case 4:
		draw_neuron(w, gc, cmap, mikepath, x, y, neuron_low_color, neuron_high_color);
		break;

	default:
		Error(30);
		break;
	}	

	XDefineCursor(dpy, gra_win, level_window_cursor);
	return;
}

/* the following redraw function is the one called when the window is first opened.
 * the refresh of the screen due to window resizing, expose etc, and for updating the
 * net display is done by the function refresh_window above 
 */


void redraw_graphic_window(w, mikepath)
Widget w;
int mikepath[4];
{
	int connection;
	int connpath1[4];
	int connpath2[4];

	int matrix;
	int matrix1[2];
	int matrix2[2];
	
	int i;
	int x,y;
	int level;
	dpy = XtDisplay(w);
	gra_win = XtWindow(w);
	XGetWindowAttributes(dpy, gra_win, &xwa);
        x = xwa.width;
        y = xwa.height;
	cmap = xwa.colormap;

	if(DisplayCells(topdpy,  DefaultScreen(topdpy)) > 2)
	{
		SplatColors(dpy, gra_win);
	}

	FindForMike(mikepath, w, &connection , connpath1, connpath2);
/* magali's spelling of matrix, not mine */
	MattrixMike(mikepath, w, &matrix, matrix1, matrix2); 
	
	level = GiveLevel(mikepath);
	XDefineCursor(dpy, gra_win, level_window_wait_cursor);
	
	switch(level) {
	case 0:
		if(connection == False)
		{
			if(prev_sys_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_system(w, gc, cmap, mikepath, x, y, sys_low_color, sys_high_color);
			prev_sys_conn = False;
		}
		else
		{
			if(!prev_sys_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_system(w, gc, cmap, mikepath, x/2, y, sys_low_color, sys_high_color);
        		draw_system_connection(w, gc, cmap, mikepath, connpath1, connpath2, x, y, sys_low_color, sys_high_color);
			prev_sys_conn = True;
		}
		break;
		
	case 1:
		if(connection == False)
		{
			if(prev_net_conn)
			{
				XClearWindow(dpy, gra_win);
			}

			if(matrix == False)
			{				
				if(prev_matrix_layer)
				{
					XClearArea(dpy, gra_win, 0, 0, x, y-60, False);
					draw_net(w, gc, cmap, mikepath, x, y, net_low_color, net_high_color);
					prev_matrix_layer = False;
				}
				else
				{
					draw_net(w, gc, cmap, mikepath, x, y, net_low_color, net_high_color);
				}
			}
			else
			{
				if(prev_matrix_layer)
				{
					draw_matrix_layers(w, gc, cmap,mikepath, matrix1, matrix2, x, y, net_low_color, net_high_color);
				}
				else
				{
					XClearArea(dpy, gra_win, 0, 0, x, y-60, False);
					draw_matrix_layers(w, gc, cmap,mikepath, matrix1, matrix2, x, y, net_low_color, net_high_color);
					prev_matrix_layer = True;
				}
			}

			prev_net_conn = False;
				
		}
		else
		{	
			if(!prev_net_conn)
			{
				XClearWindow(dpy, gra_win);
			}
			if(matrix == False)
			{
		
				if(prev_matrix_layer)
				{
					XClearArea(dpy, gra_win, 0, 0, x/2, y-60);
				}
				draw_net(w, gc, cmap, mikepath, x/2, y, net_low_color, net_high_color);
				draw_net_connection(w, gc, cmap, mikepath, connpath1, connpath2, x, y, net_low_color, net_high_color);
				prev_matrix_layer = False;
			}
			else
			{
				if(prev_matrix_layer)
				{
					draw_matrix_layers(w, gc, cmap, mikepath, matrix1, matrix2, x/2, y, net_low_color, net_high_color);
					draw_net_connection(w, gc, cmap, mikepath, connpath1, connpath2, x, y, net_low_color, net_high_color);
				}
				else
				{
					XClearArea(dpy, gra_win, 0,0, x/2, y-60, False);
					draw_matrix_layers(w, gc, cmap, mikepath, matrix1, matrix2, x/2, y, net_low_color, net_high_color);
					prev_matrix_layer = True;
				}
			}

			prev_net_conn = True;
		}
		break;
		
	case 2:
		if(connection == False)
		{
			if(prev_layer_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_layer(w, gc, cmap, mikepath, x, y, layer_low_color, layer_high_color);
			prev_layer_conn = False;
		}
		else
		{	
			if (!prev_layer_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_layer(w, gc, cmap, mikepath, x/2, y, layer_low_color, layer_high_color);
			draw_layer_connection(w, gc, cmap, mikepath,connpath1, connpath2, x, y, layer_low_color, layer_high_color);
			prev_layer_conn = True;
		}
		break;

	case 3:
		if(connection == False)
		{
			if(prev_cluster_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_cluster(w, gc, cmap, mikepath, x, y, cluster_low_color, cluster_high_color);
			prev_cluster_conn = False;
		}
		else
		{
			if(!prev_cluster_conn)
			{
				XClearWindow(dpy, gra_win); 
			}
			draw_cluster(w, gc, cmap, mikepath, x/2, y, cluster_low_color, cluster_high_color );
			draw_cluster_connection(w, gc, cmap, mikepath, connpath1, connpath2,  x, y, cluster_low_color, cluster_high_color );
			prev_cluster_conn = True;
		}
		break;

	case 4:
		draw_neuron(w, gc, cmap, mikepath, x, y, neuron_low_color, neuron_high_color);
		break;

	default:
		Error(30);
		break;
	}	
	XDefineCursor(dpy, gra_win, level_window_cursor);
	return;
	}





/* the following function is called to initialise a graphic display window - 
 * called when the parent, level window is created
 */
 
void init_graphic_window(w)
Widget w;
{
	int x,y, i;
	unsigned long plane_masks[];
	unsigned long pixels[];
	char inverse_buf[3];
	valuemask = NULL;

	strcpy(inverse_buf, "on");

	XtCreateWindow(w, InputOutput, CopyFromParent, valuemask, &xswa);



/* linking Xlib and the XToolkit here */

	dpy = XtDisplay(w);


/* find window identity from widget */

	gra_win = XtWindow(w);


/* set up default values */

	default_cmap = DefaultColormap(dpy, DefaultScreen(dpy));
/*gc = XCreateGC(dpy, gra_win, 0, 0);*/

/*	pgm_cmap = XCreateColormap(dpy, gra_win, XDefaultVisual(dpy, DefaultScreen(dpy)), AllocAll);*/
/*	result = XAllocColorCells(dpy, default_cmap, True, plane_masks[0], 0, pixels[128], 128);*/
/*	printf("init_graphic_window:\n\tresult is %i\n", result);*/

 	XSetWindowColormap(dpy, gra_win, pgm_cmap);
	XGetWindowAttributes(dpy, gra_win, &xwa);	
 
/*	init_color_scales(topdpy, topwin, gc, xwa.colormap);*/



	/* specify window attributes */
		xswa.background_pixel = my_bg.pixel;
		xswa.save_under = True;
		xswa.backing_store = WhenMapped;
		xswa.colormap = pgm_cmap;
		valuemask = CWBackPixel|CWBackingStore|CWColormap;
		XChangeWindowAttributes(dpy, gra_win, valuemask, &xswa);
	
	/* create something now */
		

		XSetBackground(dpy, gc, my_bg.pixel);
		XSetForeground(dpy, gc, my_fg.pixel);
		XSetWindowBackground(dpy, gra_win, my_bg.pixel);

/*	my_font = XLoadFont(dpy, "-adobe-new century schoolbook-medium-r-normal--12-120-75-75-p-70-iso8859-1");
	XSetFont(dpy, gc, my_font);
*/
	level_window_cursor = XCreateFontCursor(dpy, XC_crosshair);
	level_window_wait_cursor = XCreateFontCursor(dpy, XC_watch);
	XDefineCursor(dpy, gra_win, level_window_cursor);
	XSelectInput(dpy, gra_win, FocusChangeMask|KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask|StructureNotifyMask|ColormapChangeMask);
	

	return;
}



static void Mikes_expose(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	int i ;
	int mikepath[4] ;
	int conn_flag;
	int connpath1[4];
	int connpath2[4];
	
	XEvent current;
	XEvent ahead;
	dpy = XtDisplay(w);
	gra_win = XtWindow(w);

	for(i=0; i<4; i++)
        {
		mikepath[i] = atoi(params[i]);
        }

	if(XEventsQueued(dpy, QueuedAlready) > 0)
	{
		XPeekEvent(dpy, &ahead);
		if(ahead.type != Expose) return;
	}
	current = ahead;

	while(XEventsQueued(current.xexpose.display, QueuedAfterReading) > 0)
	{	
		XPeekEvent(current.xexpose.display, &ahead);
		if(ahead.type != Expose) break;
		if(ahead.xexpose.window != current.xexpose.window) break;
		XNextEvent(current.xexpose.display, &current);
	}
	
	FindForMike(mikepath, w, &conn_flag, connpath1, connpath2);
	
	XClearWindow(dpy, gra_win);
        refresh_window(w, mikepath, conn_flag, connpath1, connpath2);
	
	return;
}


static void Mikes_map(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	int i ; 
  	int mikepath[4] ; 
	XEvent current;
	XEvent ahead;

	for (i=0; i<4; i++)
     	{
		mikepath[i] = atoi(params[i]);
	}

	init_graphic_window(w);	
	return;
}


static void Mikes_configure(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	int i ; 
  	int mikepath[4] ; 
	Bool conn_flag;
	int connpath1[4];
	int connpath2[4];
	XEvent current;
	XEvent ahead;
	dpy = XtDisplay(w);
	gra_win = XtWindow(w);
	for(i=0; i<4; i++)
        {
		mikepath[i] = atoi(params[i]);
        }
	XNextEvent(dpy, &current);
	while(XEventsQueued(current.xconfigure.display, QueuedAlready) > 0)
	{	
		XPeekEvent(current.xconfigure.display, &ahead);
		if(ahead.type != ConfigureNotify) 
		{
			if(ahead.type == Expose)
			{
				XPutBackEvent(dpy, &ahead);
				return;
			}
			else
			{
				break;
			}
		}
		else
		{
			/* I can't cope with all those configures, it's a month with r in it */
			Error(31);
			
			return;
		}
	}

	XClearWindow(dpy, gra_win);
	FindForMike(mikepath, w, &conn_flag, connpath1, connpath2);
	refresh_window(w, mikepath, conn_flag, connpath1, connpath2);

	return;
	
}

static void Mikes_colormap(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{

	int i ; 
  	int mikepath[4] ; 

	if(DisplayCells(topdpy,  DefaultScreen(topdpy)) == 2)
	{
		return;
	}

	for(i=0; i<4; i++)
        {
		mikepath[i] = atoi(params[i]);
        }

/*disputable line*/
/*	XInstallColormap(topdpy, pgm_cmap);*/
	XSetWindowColormap(XtDisplay(w), XtWindow(w), pgm_cmap);
	return;
}

static void Mikes_uncolormap(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{

/*disputable line*/
/*	XUninstallColormap(topdpy, pgm_cmap);*/
	return;
}

static void Mikes_null(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	/* don't do anything */
	return;
}

static void Mikes_russky(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	int i ;
	int mikepath[4] ;
	int conn_flag;
	int connpath1[4];
	int connpath2[4];
	
	XEvent current;
	XEvent ahead;
	dpy = XtDisplay(w);
	gra_win = XtWindow(w);

	for(i=0; i<4; i++)
        {
		mikepath[i] = atoi(params[i]);
        }

	if(XEventsQueued(dpy, QueuedAlready) > 0)
	{
		XPeekEvent(dpy, &ahead);
		if(ahead.type != Expose) return;
	}
	current = ahead;

	while(XEventsQueued(current.xexpose.display, QueuedAfterReading) > 0)
	{	
		XPeekEvent(current.xexpose.display, &ahead);
		if(ahead.type != Expose) break;
		if(ahead.xexpose.window != current.xexpose.window) break;
		XNextEvent(current.xexpose.display, &current);
	}
	
	FindForMike(mikepath, w, &conn_flag, connpath1, connpath2);
	
        refresh_window(w, mikepath, conn_flag, connpath1, connpath2);
	return;
}


       static String *jon_trans ;
       static String *guy_trans ;
       static String *fred_trans;
       static String *geeves_trans;
       static String *bilg_trans;
       static String *penelope_trans;
	static String *russian_trans;

	XtTranslations jon_compiled;
	XtTranslations guy_compiled;
	XtTranslations fred_compiled;
	XtTranslations geeves_compiled;
	XtTranslations bilg_compiled;
	XtTranslations penelope_compiled;
	XtTranslations russky_compiled;

	static XtActionList my_configure_action[] = {{"mikes_configure", Mikes_configure}};
	static XtActionList my_expose_action[] = {{"mikes_expose", Mikes_expose}};
	static XtActionList my_map_action[] = {{"mikes_map", Mikes_map}};
	static XtActionList my_color_action[] = {{"mikes_colormap", Mikes_colormap}};
	static XtActionList my_uncolor_action[] = {{"mikes_uncolormap", Mikes_uncolormap}};
	static XtActionList my_null_action[] = {{"mikes_null", Mikes_null}};
	static XtActionList my_russky_action[] = {{"mikes_russky", Mikes_russky}};



void Display_create(path, w)
int path[] ;
Widget w;
{
int i ;
String *string_path ;

string_path = (String *) calloc(sizeof(String) , 200) ;
jon_trans = (String *) calloc(sizeof(String) , 200) ;
guy_trans = (String *) calloc(sizeof(String) , 200) ;
fred_trans = (String *) calloc(sizeof(String), 200);
geeves_trans = (String *) calloc(sizeof(String), 200);
bilg_trans = (String *) calloc(sizeof(String), 200);
penelope_trans = (String *) calloc(sizeof(String), 200);
russian_trans = (String *) calloc(sizeof(String), 200);

sprintf(string_path , "%d %d %d %d" , path[0] , path[1] , path[2] , path[3] ) ;

sprintf(jon_trans , "<MapNotify>:mikes_map(%s) mikes_expose(%s)" , string_path , string_path ) ;
sprintf(guy_trans , "<Expose>:mikes_expose(%s)" , string_path ) ;
sprintf(fred_trans , "<ConfigureNotify>:mikes_configure(%s)", string_path);
/*
sprintf(geeves_trans, "<LeaveWindow>:mikes_uncolormap(%s)", string_path);

sprintf(bilg_trans, "<EnterWindow>:mikes_colormap(%s)", string_path);


*/
sprintf(penelope_trans, "<Btn1Down>:mikes_null(%s)", string_path);
sprintf(russian_trans, "<Btn3Down>:mikes_russky(%s)", string_path);


	XtAddActions(my_configure_action, 1);
	XtAddActions(my_expose_action, 1);
	XtAddActions(my_map_action, 1);
/*	XtAddActions(my_color_action, 1);
	XtAddActions(my_uncolor_action, 1);
*/
	XtAddActions(my_null_action, 1);
	XtAddActions(my_russky_action, 1);

	jon_compiled = XtParseTranslationTable(jon_trans);
	guy_compiled = XtParseTranslationTable(guy_trans);
	fred_compiled = XtParseTranslationTable(fred_trans);
/*	geeves_compiled = XtParseTranslationTable(geeves_trans);
bilg_compiled = XtParseTranslationTable(bilg_trans);
*/
	penelope_compiled = XtParseTranslationTable(penelope_trans);
	russky_compiled = XtParseTranslationTable(russian_trans);

	XtOverrideTranslations(w, jon_compiled);
	XtOverrideTranslations(w, guy_compiled);
	XtOverrideTranslations(w, fred_compiled);
/*	XtOverrideTranslations(w, geeves_compiled);

	XtOverrideTranslations(w, bilg_compiled);
*/
	XtOverrideTranslations(w, penelope_compiled);
	XtOverrideTranslations(w, russky_compiled);	

}
