/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * shownet.c
 ******************************************************************************/

/* ------------------------------------------------------------------------ *\
   Shownet() displays the status of the neurons in the network, and the user
   can then request to display the weights in matrix form for the weights
   between the layers or in vector forms for each individual neuron.  The
   status of the neurons in one layer are displayed linearly with the line
   width set in the network.

	jtaylor
	21/02/90
	09:00

\* ------------------------------------------------------------------------ */

#include "pygmalion.h"
#include "sysdef.h"
#include "built_in_fn.h"

/* #define GREYSCALE " .,:;-\"_=o*\\&IO#"		Original */
#define	GREYSCALE " .,:;-\"_=o\\IO*&#"

extern  int		input_pattern_control;
extern  int		target_pattern_control;
extern	pat_elem	*current_pattern;
extern	system_type	*sys;

char			mapping[16];
int			pattern_control;

/* ---------------------------------------------------------------- */
void shownet()
{
	int dot, grey;

	extern void net_state();
	extern void net_weight();

	printf("Display the network status as real values ? [y/n]: ");
	if (YES()) {
		dot = FALSE;
		grey = FALSE;
	}
	else {
		dot = TRUE;
		printf("Use `grey scale' ( n == X's ) ?	[y/n]: ");
		if (YES()) {
	 		grey = TRUE;
			(void) strcpy (mapping, GREYSCALE);
			printf("Greyscale %s\n", mapping );
		}
		else {
			grey = FALSE;
		}
	}

	net_state(sys->net[0], dot, grey);
/*
	printf("Show the weights as well? [y/n]: ");
	if (YES())
		net_weight(sys->net[0], dot, grey);
*/

}

/* ---------------------------------------------------------------- */
void net_state(net, dot, grey)
net_type *net;
int dot, grey;
{
	int i, w;

	extern void lay_state();

	for (i=0; i<net->layers; i++) {

		if ( i == 0 ) {
			w = current_pattern->input_width;
			pattern_control = input_pattern_control;
		}
		else {
			w = current_pattern->target_width;
			pattern_control = target_pattern_control;
		}
		if ( w == 0 ) {	/* just in case we need to shownet() without reading pattern */
			w = 8;	/* fairly arbitrary value */
		}

		printf("States in layer[%d]:\n", i);
		lay_state(net->layer[i], dot, grey, w);
		printf("\n");
	}
}

/* ---------------------------------------------------------------- */
void net_weight(net)
net_type *net;
{
	int i;

	extern void lay_weight();

	for (i=0; i<net->layers; i++) {
		printf("Weight to layer[%d]:\n", i);
		lay_weight(net->layer[i]);
		printf("\n");
	}
}

/* ---------------------------------------------------------------- */
void lay_state(layer, dot, grey, w)
layer_type	*layer;
int		dot, grey;
int		w;
{
	int i;

	extern void clu_state();

	for (i=0; i<layer->clusters; i++) {
		printf("States in cluster[%d]:\n", i);
		clu_state(layer->cluster[i], dot, grey, w);
		printf("\n");
	}
}

/* ---------------------------------------------------------------- */
void lay_weight(layer)
layer_type *layer;
{
	int i;

	extern void clu_weight();

	for (i=0; i<layer->clusters; i++) {
		printf("Weights to cluster[%d]:\n", i);
		clu_weight(layer->cluster[i]);
		printf("\n");
	}
}

/* ---------------------------------------------------------------- */
void clu_state(cluster, dot, grey, w)
cluster_type	*cluster;
int		dot, grey;
int		w;
{
	int		i, j;
	char		disp = 'X';
	float		v, minv, maxv, range, a;

	if ( pattern_control == NORMALISE ) {
		maxv = cluster->neuron[0]->state[ N_STATE ].value.f;
		minv = maxv;
		for (i=1 ; i<cluster->neurons; i++) {
			v = cluster->neuron[i]->state[ N_STATE ].value.f;
			if ( v > maxv ) {
				maxv = v;
			}
			if ( v < minv ) {
				minv = v;
			}
		}
		range = maxv - minv;
	}

	for (i=0; i<cluster->neurons; i++) {

		v = cluster->neuron[i]->state[ N_STATE ].value.f;
	        switch ( pattern_control ) {

        	case NORMALISE:
			a = ( v - minv ) / range;
			break;

        	case BINARY:
	        case REAL:
			a = v;
			break;

	        case PLUSMINUS: /* range 1.0 to -1.0 */
			/* shift and rescale */
			a = (v + 1.0)/2.0;
			break;
	        }

		if (dot) {
			if (grey) {
				j = ( 16 * a ) - 0.001;
				printf("%c", mapping[j] );
			}
		 	else {
				printf("%c", (a > .5) ? disp : ' ');
			}
		}
		else {
			printf("%f ", v);
		}

		if ((i % w) == (w - 1)) {
			printf("\n");
		}
	}
}

/* ---------------------------------------------------------------- */
void clu_weight(cluster)
cluster_type *cluster;
{
	int i;

	extern void neu_weight();

	for (i=0; i<cluster->neurons; i++) {
		if (cluster->neuron[i]->fanin) {
			printf("Weights to neuron[%d]:\n", i);
			neu_weight(cluster->neuron[i]);
			printf("\n");
		}
	}
}

/* ---------------------------------------------------------------- */
void neu_state(neuron)
neuron_type *neuron;
{
	 printf("%f	", neuron->state[ N_STATE ].value.f);
}

/* ---------------------------------------------------------------- */
void neu_weight(neuron)
neuron_type *neuron;
{
	int i;

	for (i=0; i<neuron->fanin; i++) {
		printf("%f	", neuron->synapse[i]->weight.value.f);
		if ( (i%8) == 7)
			printf("\n");
	}
}
/* ---------------------------------------------------------------- */
