/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * readfont.c
 ******************************************************************************/

/* --------------------------------------------------------------- *\
	The readfont/writefont part of xfed
\* --------------------------------------------------------------- */
/*
 * Copyright 1988 Network Computing Devices, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of N.C.D. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  N.C.D. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Olaf Brandt, NCD X Consortium
 *
 *
 * Copyright 1988 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens
 */

#include <stdio.h>
#include <errno.h>
#include "pygmalion.h"
#include "fontdefs.h"

char fontfilename[200]="";

int ex1, ey1, ex2, ey2, einc;
struct character *charp;
int firstSave = 1;
int changed = 0;
int variable_width = 0;
int readOnly = 0;
char info_buffer[200];
char name_buffer[200];
char char_buffer[200];
FILE *fp;

void writefont(), writechar(), quit(), show();

/* ------------------------------------------------------- */
int	readchar(reqfont, reqchar, array, p)
char	*reqfont, reqchar;
float	*array;
struct	character **p;
{
	short unsigned int	i,j,k;
	int			found;
	struct character	*charp;

	if ( strcmp (reqfont, fontfilename) != 0 ) {	/* New font */
		if (fontfilename[0] != '\0')
			free (font.characters);
/*		printf ("new font %s\n", reqfont); */

		if ( readfont (reqfont) != OK )
			return ( NOTOK );
		else
			strcpy( fontfilename, reqfont );
	}

	for(i=0, found=FALSE; i<font.nchars; i++) {
		charp = &font.characters[i];
		if ( charp->encoding == (int) reqchar ) {
			found = TRUE;
			break;
		}
	}
	if ( ! found )
		return( NOTOK );

	for ( j=0; j<charp->nrows; j++ ) {
		for (k=0; k<charp->dwidth[0]; k++){
			*array++ = (float) bitOp(charp, ReadBit, j, k) ? 1 :  0 ;
		}
	}
	*p = charp;
	return (OK);
}
/* ------------------------------------------------------- */
void	show()
{
	short unsigned int	i,j,k;
	struct character *charp;

	for(i=0; i<font.nchars; i++) {
		charp = &font.characters[i];
		printf ( "%s\n", charp->charId);
		for (j=0; j<charp->nrows; j++ ) {
			for (k=0; k<charp->dwidth[0]; k++ ){
				printf ( "%c",bitOp(charp, ReadBit, j, k) ? 'X' :' ');
				/* printf ( "%s\n", font.characters[i].rows[j]); */
			}
			printf("\n");
		}
	}
}
/* ------------------------------------------------------- */
readfont(fontfilename)
char	*fontfilename;
{
	if (!fontfilename) {
		fprintf (stderr, "no file name specified\n");
		return( NOTOK );
	}
	if (!(fp = freopen(fontfilename, "r", stdin))) {
		fprintf(stderr, "cannot open file: %s\n",fontfilename);
		return( NOTOK );
	}
	if (!(fp = freopen(fontfilename, "r+", stdin))) {
		fprintf(stderr, "warning file '%s' is read only\n", fontfilename);
		readOnly = 1;
	}
	fp = freopen(fontfilename, "r", stdin);

	if ( yyparse() != OK ) {
		printf ("Bad PARSE\n");
		return( NOTOK );
	}
	fp = freopen("/dev/tty", "r+", stdin);

	return( OK );
}
/* ------------------------------------------------------- */

char *makelower(word)
register char *word;
{
    register char *alphabits;
    for (alphabits=word; *alphabits; alphabits++)
	if (*alphabits >= 'A' && *alphabits <= 'Z') *alphabits += 'a' - 'A';
    return(word);
}
/* ------------------------------------------------------- */
memberp(word, list)
register char *word;
register char **list;
{
    makelower(word);
    for (; *list; list++)
	if (!strcmp(word, *list)) return(1);
    return(0);
}

/* ------------------------------------------------------- */
/*
 * read/set/clear/complement a pixel in current character - row/col must be checked
 * elsewhere
 */
bitOp(charp, what, row, col)
struct character	*charp;
int			what;
short unsigned int	row, col;
{
        char *rowbits;
        short unsigned int bits, colq, mask, bits_unchanged;

        changed = 1;
        colq = col >> 2;
        mask = 1 << (3 - (col & 3));
        bits_unchanged = bits = dec(charp->rows[row][colq]);

        switch (what) {
            case ReadBit:
		return( bits & mask );
		break;
            case SetBit:
                bits |= mask;
                break;
            case ComBit:
                bits ^= mask;
                break;
            case ClearBit:
                bits &= ~mask;
                break;
        }
        if (bits == bits_unchanged) return;
        charp->rows[row][colq] = hex(bits);
}

/* ------------------------------------------------------- */

void writefont(fontfilename)
char	*fontfilename;
{
    char cmdbuff[132];
    if (readOnly) {
       fprintf(stderr, "file '%s' is read only\n", fontfilename);
       return;
    }
    if (firstSave) {
        firstSave = 0;
        sprintf(cmdbuff, "mv -f %s %s~", fontfilename, fontfilename);
        system(cmdbuff);
    }
    output(&font, fontfilename);
    changed = 0;
}
/* ------------------------------------------------------- */

void quit()
{
	writefont(fontfilename);
	exit(0);
}
/* ------------------------------------------------------- */
