/******************************************************************************/
/**									     **/
/**		      Copyright 1990 by Computer Science Dept.  	     **/
/**			University College London, England		     **/
/**									     **/
/**									     **/
/**									     **/
/** Permission to use, copy and modify (but NOT distribute) this software    **/
/** and its documentation for any purpose and without fee is hereby granted, **/
/** provided the above copyright notice appears in all copies, and that both **/
/** that copyright notice and this permission notice appear in supporting    **/
/** documentation, and that the name Pygmalion not be used in advertising or **/
/** publicity of the software without specific, written prior permission of  **/
/** Thomson-CSF.							     **/
/**									     **/
/** THE DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON DISCLAIMS  **/
/** ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED       **/
/** WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE 	     **/
/** DEPARTMENT OF COMPUTER SCIENCE, UNIVERSITY COLLEGE LONDON BE LIABLE FOR  **/
/** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER **/
/** RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF     **/
/** CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN      **/
/** CONJUNCTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.		     **/
/**									     **/
/******************************************************************************/

/******************************************************************************
 * Pygmalion Programming Environment v 1.02 3/3/90
 *
 * pgm 
 *
 * alloc.c
 ******************************************************************************/


#include	"pygmalion.h"
#include	"sysdef.h"
extern		char	*jalloc();

/* ----------------------------------------------------------------- */

net_type	**net_alloc();
layer_type	**layer_alloc();
cluster_type	**cluster_alloc();
neuron_type	**neuron_alloc();

/* ----------------------------------------------------------------- */

system_type	*sys_alloc(config)
int		*config[];
{
	system_type	*sys;	/* This is where it all starts ! */

	/* Only one system allowed */
	sys		= (system_type *) jalloc( sizeof (system_type), 1);
	sys->nets	= **config;
	sys->net	= net_alloc(config);
	return (sys);
}

/* ----------------------------------------------------------------- */

net_type	**net_alloc(config)
int		*config[];
{
	net_type	**net, *neta;
	int 		i, nets;

	nets = **config;
	(*config)++;
	net	= (net_type **)	jalloc( sizeof (net_type *), nets);
	neta	= (net_type *)	jalloc( sizeof (net_type), nets);
	for (i=0; i<nets; i++) {
		net[i]		= neta++;
		net[i]->layers	= **config;
		net[i]->layer	= layer_alloc(config);
	}
	return (net);
}

/* ----------------------------------------------------------------- */

layer_type	**layer_alloc(config)
int		*config[];
{
	layer_type	**layer, *layera;
	int		i, layers;

	layers = **config;
	(*config)++;
	layer	= (layer_type **)	jalloc( sizeof (layer_type *), layers);
	layera	= (layer_type *)	jalloc( sizeof (layer_type), layers);
	for (i=0; i<layers; i++) {
		layer[i]		= layera++;
		layer[i]->clusters	= **config;
		layer[i]->cluster	= cluster_alloc(config);
	}
	return (layer);
}

/* ----------------------------------------------------------------- */

cluster_type	**cluster_alloc(config)
int		*config[];
{
	cluster_type	**cluster, *clustera;
	int		i, clusters;

	clusters = **config;
	(*config)++;
	cluster		= (cluster_type **)	jalloc( sizeof (cluster_type *), clusters);
	clustera	= (cluster_type *)	jalloc( sizeof (cluster_type), clusters);
	for (i=0; i<clusters; i++) {
		cluster[i]		= clustera++;
		cluster[i]->neurons	= **config;
		cluster[i]->neuron	= neuron_alloc(config);
	}
	return (cluster);
}

/* ----------------------------------------------------------------- */

neuron_type	**neuron_alloc(config)
int		*config[];
{
	neuron_type	**neuron, *neurona;
	int		i, neurons;

	neurons = **config;
	(*config)++;
	neuron	= (neuron_type **)	jalloc( sizeof (neuron_type *), neurons);
	neurona	= (neuron_type *)	jalloc( sizeof (neuron_type), neurons);
	for (i=0; i<neurons; i++) {
		neuron[i] = neurona++;
	}
	return (neuron);
}
/* ----------------------------------------------------------------- */
