/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/********************************************************************
 * Graphics Interface
 * ------------------ 
 * This file contains the declarations for global variables
 * used in the Graphics Interface package of the Rochester
 * Connectionist Simulator.
 *
 * Note: to make it easy for the simulator or user code to avoid
 *       name clashes, ALL external variables (and procedure names)
 *       should begin with the prefix "gi_".
 *
 * Kenton Lynne
 ********************************************************************/

#include "macros.h"
#include "externs.h"

/********************************************************/
/* definitions for the various display cursor */
/********************************************************/
Cursor gi_main_cursor; /* default cursor */
Cursor gi_last_cursor; /* last "permanent" cursor used */
Cursor gi_graball_cursor;  /* cursor for moving the display */
Cursor gi_grab_cursor;  /* cursor for moving graphic objects */
Cursor gi_draw_cursor; /* for draw mode */
Cursor gi_text_cursor; /* for text mode */
Cursor gi_delete_cursor; /* for deleting objects */
Cursor gi_custom_cursor; /* for custom mode */
Cursor gi_left_cursor; /* custom-left button */
Cursor gi_middle_cursor; /* custom-middle button */
Cursor gi_right_cursor; /* custom-right button */

/*************************************************************************/
/* X-11 & Xtk handles for various window and panel structures            */
/*************************************************************************/
Widget gi_tool;				/* global tool handle            */
Window gi_gfx;				/* display window		 */
GC gi_gc;				/* global graphics context       */
unsigned long gi_event_mask;            /* default event mask            */
XFontStruct gi_default_font;	        /* default font used everwhere   */
float gi_font_width;		        /* width of default font         */
/***********************************************/
/* holds the current display window dimensions */
/***********************************************/
int gi_origin_x = 0; /* left_most coordinate   */
int gi_origin_y = 0; /* top_most coordinate    */
int gi_extent_x;     /* right_most coordinate  */
int gi_extent_y;     /* bottom_most coordinate */

/*************************************************************/
/* header and pointers for maintaining the gricon structures */
/*************************************************************/
struct gricons *gi_icon_head = NULL;
XImage **gi_pixptr_start = NULL;
XImage **gi_last_pixptr = NULL;

/*************************************************************/
/* header structures for anchoring the drawn, text and grobj */
/* doubly linked chain structures                            */
/*************************************************************/
struct grobj gi_marker,      /* the on display grobj header  */
             gi_off_display; /* the "off display" header     */
struct txobj gi_text_head;
struct drobj  gi_draw_head;

/*************************************************************************/
/* the header and default pointers for maintaining text fonts in storage */
/*************************************************************************/
struct saved_fonts *gi_font_head = NULL;  
XFontStruct *gi_dft_font, *gi_cur_font;
/****************************************************************/
/* pointers for maintaining the vertex and string storage areas */
/****************************************************************/
int *gi_vertex_start = NULL;
int *gi_last_vertex = NULL;
char *gi_string_start = NULL;
char *gi_last_char = NULL;

/*******************************************************/
/* array for maintaining the columns of the info panel */
/*******************************************************/
int gi_info_next = 0;  /* indicates next column to use */
struct info_unit gi_info_item[MAX_INFO_COLS];             

/****************************************************************/
/* variables that maintain the log file and its parameters      */
/****************************************************************/
char gi_log_on=TRUE;        /* indicates whether loggin enabled */
FILE *gi_log_fp=NULL;       /* log file pointer                 */
int gi_log_start_x=0;       /* position of prompt on mode panel */

/****************************************************************/
/* variables for maintaining size of display panel              */
/****************************************************************/
int gi_old_width;           /* width of display panel           */
int gi_old_height;          /* height of display panel          */

/****************************************************************/
/* variables for maintaining text information from control panel*/
/****************************************************************/
char	gi_who_buf[MAX_CMD_LENGTH],
	gi_howmany_buf[MAX_CMD_LENGTH],
	gi_lrange_buf[MAX_CMD_LENGTH],
	gi_hrange_buf[MAX_CMD_LENGTH],
	gi_target_buf[MAX_CMD_LENGTH],
	gi_subimage_buf[MAX_CMD_LENGTH],
	gi_wherex_buf[MAX_CMD_LENGTH],
	gi_wherey_buf[MAX_CMD_LENGTH],
	gi_spacex_buf[MAX_CMD_LENGTH],
	gi_spacey_buf[MAX_CMD_LENGTH],
	gi_numcols_buf[MAX_CMD_LENGTH],
	gi_clock_buf[MAX_CMD_LENGTH],
	gi_origin_buf[MAX_CMD_LENGTH],
	gi_go_steps_buf[MAX_CMD_LENGTH],
	gi_go_update_buf[MAX_CMD_LENGTH],
	gi_dump_buf[MAX_CMD_LENGTH],
	gi_reshow_buf[MAX_CMD_LENGTH],
	gi_ltarget_buf[MAX_CMD_LENGTH],
	gi_llrange_buf[MAX_CMD_LENGTH],
	gi_lhrange_buf[MAX_CMD_LENGTH],
        gi_button_buf[6][MAX_CMD_LENGTH];

/****************************************************************/
/* consists of bit flags for controlling gi_reshow behavior     */
/****************************************************************/
int gi_reshow_flag=0;

/****************************************************************/
/* variables that are maintained for LINK mode processing       */
/****************************************************************/
char gi_new_link_parms=FALSE;       /* link parms have changed  */
int gi_link_direction = TO_TARGET;  /* current link direction   */
int gi_cur_link_target = -1;        /* current target unit index*/
char *gi_cur_link_site = NULL;      /* current target site      */
XImage **gi_cur_link_image = NULL;   /* points to link icon array */
struct grobj *gi_cur_target_ptr=NULL; /* points to target grobj */
int gi_cur_lhow_value = 0;

/**********************************/
/* miscellaneous global variables */
/**********************************/
int gi_mode = MODE_MAIN;        /* current mode                  */
char gi_off_display_ok=0;       /* off display values are ok     */
int gi_draw_type = LINES;       /* current draw parameter        */   
struct grobj *gi_last_tagged=NULL; /* points to last tagged unit */
int gi_cur_image_value = 1;     /* holds currently selected icon */
int gi_cur_unit_what = POT;     /* contains current aspect       */
