/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/*********************************************************************
 * Graphics Interface
 * ------------------
 * This file contains the routines that access and maintain the message panel.
 *
 * Kenton Lynne
 ********************************************************************/

#include "macros.h"
#include "externs.h"
#include "panel.h"

static Panel msg_panel;

static Panel_item msg_item;

/*******************************************************************/
gi_make_msg_panel()
{
/* creates the message panel 
*/

  struct toolsw *msg_panel_sw;

  /* define the message panel */
  if ((msg_panel_sw 
           = panel_create(gi_tool,
                          PANEL_HEIGHT, MSG_HEIGHT,
                          PANEL_WIDTH, TOOL_SWEXTENDTOEDGE,
                          PANEL_LABEL_BOLD, TRUE,
                          PANEL_NAME,"Main",
                          0)) == NULL)
  {
    fputs("Can't create message panel\n", stderr);
    exit(1);
  }
  msg_panel = msg_panel_sw->ts_data;

  /* add the message item to the panel */
  msg_item = panel_create_item
                (msg_panel, PANEL_MESSAGE,
                 PANEL_LABEL_STRING,
                 "Remember to first build your network!",
                 PANEL_LABEL_X, 5,
                 PANEL_LABEL_Y, 10,
                 0);
}

/*******************************************************************/
gi_put_error(string)
  char *string;
{
/* displays a message
 * in the message panel prefaced by "ERR:"
 */
  char buf[80];
  strcpy(buf,"ERR: ");
  strcat(buf,string);
  panel_set(msg_item, PANEL_LABEL_STRING, buf, 0);
}

/*******************************************************************/
gi_put_message(string)
  char *string;
{
/* displays a message
 * in the message panel
 */
  panel_set(msg_item, PANEL_LABEL_STRING, string, 0);
}
