/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/* definitions unique to uniprocessor code */

/* used to store unit and unit structure (vector) names, set and state
   names and other strings; not all fields used for each type */
typedef struct n_i_desc
      {
	char	*name;	/* Pointer to name */
	short	type;	/* Type of unit {0=SCALAR,1=VECTOR,2=ARRAY} */
	short	size;	/* Size of array if Type 1, width of row if 2 */
	short   length; /* number of rows if type 2 */
	int	index;	/* Index number */
	struct n_i_desc *next;
      } NameDesc;

typedef char Index;		/* for name table */

#define	HASH_SIZE	1009	/* Name table hask size */

extern FILE *fopen(), *popen();

#define STRCMP(s1,s2)  s1 == s2	/* string comparison macro */

#define BFLYCATCH
#define BFLYTHROW(x,y)

/* end of uni definitions */
