/******************************************************************************
**  The Rochester Connectionist Simulator - a neural network simulator.      **
**  COPYRIGHT (C) 1989  UNIVERSITY OF ROCHESTER.                             **
**                                                                           **
**  This program is free software; you can redistribute it and/or modify it  **
**  under the terms of the GNU General Public License as published by the    **
**  Free Software Foundation; either version 1, or (at your option) any      **
**  later version.                                                           ** 
**                                                                           **
**  This program is distributed in the hope that it will be useful, but      **
**  WITHOUT ANY WARRANTY; without even the implied warranty of               **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     **
**  See the GNU General Public License for more details.                     **
*******************************************************************************/

/* definition common to butterfly sim-node and uniprocessor code */

#define MAKE_UNIT            1
#define ADD_SITE             2
#define MAKE_LINK            3

#define NO_MORE_UNITS        1
#define NO_TYPE_NAME         2
#define NO_FUNC_NAME         4
#define IPOT_VAL_ERROR       8
#define POT_VAL_ERROR        16
#define OUT_VAL_ERROR        32
#define ISTATE_VAL_ERROR     64
#define STATE_VAL_ERROR      128

#define SITE_UNIT_ERROR      256
#define NO_SITE_NAME         512

#define FROM_UNIT_ERROR      1024
#define TO_UNIT_ERROR        2048
#define WEIGHT_VAL_ERROR     4096
#define TOO_MANY_LINKS       8192
#define BAD_SITE_NAME        16384

/* macro to get unit index from unit pointer */
#define UnitIndex(up) ((up)-UnitList)

/* set macros using unit index */
#define AddSetI(si,ui) (UnitList[ui].sets |= 1<<(si))
#define RemSetI(si,ui) (UnitList[ui].sets &= ~(1<<(si)))
#define MemberSetI(si,ui) ((UnitList[ui].sets>>(si)) & 1)

/* set macros using unit pointer */
#define AddSetP(si,up) (up->sets |= 1<<(si))
#define RemSetP(si,up) (up->sets &= ~(1<<(si)))
#define MemberSetP(si,up) (up->sets & (1 << (si)))

/* set macros using unit sets */
#define MemberSetS(si,ss) (ss & (1 << (si)))

/* flag macros using unit index*/
#define SetFlag(ui,flag) (UnitList[ui].flags |= 1<<(flag))
#define UnsetFlag(ui,flag) (UnitList[ui].flags &= ~(1<<(flag)))
#define TestFlag(ui,flag) (UnitList[ui].flags & (1 << (flag)))

/* flag macros using unit pointer*/
#define SetFlagP(up,flag) (up->flags |= (1 << (flag)))
#define UnsetFlagP(up,flag) (up->flags &= ~(1 << (flag)))
#define TestFlagP(up,flag) (up->flags & (1 << (flag)))

/* flag macros using unit flags*/
#define TestFlagF(uf,flag) (uf & (1 << (flag)))

extern Unit *UnitList;		/* unit array pointer */
extern Outvec *Outputs;		/* output list pointer */

/* end of simuni definitions */
