static char rcsid[] = "$Header: sets.c,v 1.2 87/10/21 17:37:32 goddard Exp $";
/*----------------------------------------------------------------------------

  The Rochester Connectionist Simulator.  Copyright Univesity of Rochester.
  Author: Nigel Goddard
  Date: May 1 1987

----------------------------------------------------------------------------*/

#ifdef BFLY
# ifdef BSIM
#  include "bflysim.h"
# else
#  include "bflycontrol.h"
# endif
#else
#  include "Stupido:rochester:include:uniproc.h"
#endif

/***** DeclareSet *****/
/*---------------------------------------------------------------------------
    Creates a set with the given name.  Returns -1 and prints an error 
    message if there are no more set bits; otherwise returns that set's 
    bit.
----------------------------------------------------------------------------*/

DeclareSet(name)
    char *name;
{
    int i;
    char * nptr;                /* Index is char for uniprocessor version */
    Index * nmptr;
    NameDesc nte;

BFLYCATCH
    for(i = 0;i < LastSet;i++)
      if(SetNames[i] == NULL)
        break;
    if(i >= LastSet)
      {
        fprintf(stderr,"DeclareSet: out of set room for %s\n",name);
        return -1;
      }
  if ((nmptr = EnterName(name,SET_SYM,i,0,0,&nte)) == NULL)
    {
      fprintf(stderr,
              "DeclareSet: %s already in symbol table\n",
              name);
      return -1;
    }
#ifdef BFLY                     /* bflycontrol and sim enter locally */
  if ((nptr = StoreString(name)) == NULL)
    {
      fprintf(stderr,
              "DeclareSet: failed to store in string space: %s\n",
              name);
      return -1;
    }
#ifdef BCNTL
  Send_Sim_Cmd(DECSET_C,i,name);                  /* send to sims */
#endif
#else                           /* uniprocessor EnterName returns char ptr */
      nptr = nmptr;
#endif
                                /* everybody store in table and inc count */
    SetNames[i] = nptr;
    NoSets++;                                     /* maintain set count*/
    return i;
BFLYTHROW("DeclareSet",0)
}

/***** DeleteSet *****/
/*---------------------------------------------------------------------------
  Creates a set with the given  name .  Returns the index assigned
  to the set, or -1 if the set could not be created.
----------------------------------------------------------------------------*/

DeleteSet(name)
    char *name;
{
    NameDesc look, nte;
    int i, j;
    Unit * up;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      {
        fprintf(stderr,"DeleteSet:  %s not a set\n",name);
        return FALSE;
      }
# ifdef BCNTL                   /* ie this is butterfly control node */
    Send_Sim_Cmd(DELSET_C,look.index,name);       /* send to sims */
# else
#ifndef BSIM
    AlterName(name,STRING_SYM,0,0,0,&nte); /* not for sims */
#endif
    for (i = 0,j = look.index,up = UnitList; /* sims and uni */
         i < NoUnits; i++,up++) /* remove from units */
      RemSetP(j,up);
# endif
    SetNames[look.index] = NULL; /* everybody remove from table */
    NoSets--;                                     /* maintain set count */
    return TRUE;
BFLYTHROW("DeleteSet",0)
}


/***** IsSet *****/
/*---------------------------------------------------------------------------
    Returns TRUE if there is a set with the given name; FALSE else. 
----------------------------------------------------------------------------*/

IsSet(name)
    char *name;
{
    NameDesc look;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      return FALSE;
    else
      return TRUE;
BFLYTHROW("IsSet",0)
}


/***** AddSet *****/
/*---------------------------------------------------------------------------
  Adds units with index  ulow  to index  uhigh  to the set
   name .  Returns TRUE if successful, FALSE otherwise.  
  AddSet  simply calls  AddToSet  with  ulow = uhigh =
  uindex .  Does a name lookup to find the set index.
----------------------------------------------------------------------------*/

AddToSet(name,ulow,uhigh)
    char *name;
    int ulow,uhigh;
{
    NameDesc look;
    register int i;
    register int j;
    register Unit * up;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      {
        fprintf(stderr,"AddSet:  %s not a set\n",name);
        return FALSE;
    }
    if (!LegalUnit(ulow) || !LegalUnit(uhigh))
      {
        fprintf(stderr,"AddSet:  %d - %d not a unit range\n",ulow,uhigh);
        return FALSE;
      }
#ifdef BCNTL
    Set_Cmd_Names(1,name);
    Send_Range_Cmd(ADDSET_C,ulow,uhigh);
#else
    for (i = ulow,j = look.index,up = UnitList+ulow;
         i <= uhigh; i++,up++)
      AddSetP(j,up);
#endif
    return TRUE;
BFLYTHROW("AddSet",0)
}

AddSet(name,uind)
     char * name;
     int uind;

{
  return(AddToSet(name,uind,uind));
}

/***** RemSet *****/
/*---------------------------------------------------------------------------
  Removes units with index  ulow  to index  uhigh  from the set
   name .  Returns TRUE if successful, FALSE otherwise.  
  RemSet  simply calls  RemFromSet  with  ulow = uhigh =
  uindex .
----------------------------------------------------------------------------*/

RemFromSet(name,ulow,uhigh)
    char *name;
    int ulow,uhigh;
{
    NameDesc look;
    register int i;
    register int j;
    register Unit * up;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      {
        fprintf(stderr,"RemSet:  %s not a set\n",name);
        return FALSE;
      }
    if (!LegalUnit(ulow) || !LegalUnit(uhigh))
      {
        fprintf(stderr,"RemSet:  %d - %d not a unit range\n",ulow,uhigh);
        return FALSE;
      }
#ifdef BCNTL
    Set_Cmd_Names(1,name);
    Send_Range_Cmd(REMSET_C,ulow,uhigh);
#else
    for (i = ulow,j = look.index,up = UnitList+ulow;
         i <= uhigh; i++,up++)
      RemSetP(j,up); 
#endif
    return TRUE;
BFLYTHROW("RemSet",0)
}

RemSet(name,uind)
     char * name;
     int uind;

{
  return(RemFromSet(name,uind,uind));
}
    
/***** UnionSet *****/
/*---------------------------------------------------------------------------
    The set name is assigned to be the union of sets name1 and name2. 
    1 is returned if successful (no error); 0 else. 
----------------------------------------------------------------------------*/

UnionSet(name,name1,name2)
    char *name,*name1,*name2;
{
    NameDesc look,look1,look2;
    register int i;
    register int si;
    register int si1;
    register int si2;
    register Unit * up;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      {
        fprintf(stderr,"UnionSet:  %s not a set\n",name);
        return FALSE;
      }
    if(FindName(name1,&look1) == NULL || look1.type != SET_SYM)
      {
        fprintf(stderr,"UnionSet:  %s not a set\n",name1);
        return FALSE;
      }
    if(FindName(name2,&look2) == NULL || look2.type != SET_SYM)
      {
        fprintf(stderr,"UnionSet:  %s not a set\n",name2);
        return FALSE;
      }

#ifdef BCNTL
    Set_Cmd_Names(3,name,name1,name2);
    Send_Range_Cmd(UNIONSET_C,0,NoUnits-1);
#else
    for (i=0, si=look.index, si1=look1.index, si2=look2.index, up=UnitList;
         i < NoUnits; i++,up++)
      if(MemberSetP(si1,up) || MemberSetP(si2,up)) 
        AddSetP(si,up);
      else
        RemSetP(si,up);
#endif
    return TRUE;
BFLYTHROW("UnionSet",0)
}

/***** IntersectSet *****/
/*---------------------------------------------------------------------------
    The set name is assigned to be the intersection of sets name1 and name2. 
    1 is returned if successful (no error); 0 else. 
----------------------------------------------------------------------------*/

IntersectSet(name,name1,name2)
    char *name,*name1,*name2;
{
    NameDesc look,look1,look2;
    register int i;
    register int si;
    register int si1;
    register int si2;
    register Unit * up;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      {
        fprintf(stderr,"IntersectSet:  %s not a set\n",name);
        return FALSE;
      }
    if(FindName(name1,&look1) == NULL || look1.type != SET_SYM)
      {
        fprintf(stderr,"IntersectSet:  %s not a set\n",name1);
        return FALSE;
      }
    if(FindName(name2,&look2) == NULL || look2.type != SET_SYM)
      {
        fprintf(stderr,"IntersectSet:  %s not a set\n",name2);
        return FALSE;
      }

#ifdef BCNTL
    Set_Cmd_Names(3,name,name1,name2);
    Send_Range_Cmd(INTERSET_C,0,NoUnits-1);
#else
    for (i=0, si=look.index, si1=look1.index, si2=look2.index, up=UnitList;
         i < NoUnits; i++,up++)
      if(MemberSetP(si1,up) && MemberSetP(si2,up)) 
        AddSetP(si,up);
      else
        RemSetP(si,up);
#endif
    return TRUE;
BFLYTHROW("IntersectSet",0)
}

/***** DifferenceSet *****/
/*---------------------------------------------------------------------------
    The set name is assigned to be the difference of sets name1 and name2. 
    1 is returned if successful (no error); 0 else. 
----------------------------------------------------------------------------*/

DifferenceSet(name,name1,name2)
    char *name,*name1,*name2;
{
    NameDesc look,look1,look2;
    register int i;
    register int si;
    register int si1;
    register int si2;
    register Unit * up;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      {
        fprintf(stderr,"DifferenceSet:  %s not a set\n",name);
        return FALSE;
      }
    if(FindName(name1,&look1) == NULL || look1.type != SET_SYM)
      {
        fprintf(stderr,"DifferenceSet:  %s not a set\n",name1);
        return FALSE;
      }
    if(FindName(name2,&look2) == NULL || look2.type != SET_SYM)
      {
        fprintf(stderr,"DifferenceSet:  %s not a set\n",name2);
        return FALSE;
      }

#ifdef BCNTL
    Set_Cmd_Names(3,name,name1,name2);
    Send_Range_Cmd(DIFFSET_C,0,NoUnits-1);
#else
    for (i=0, si=look.index, si1=look1.index, si2=look2.index, up=UnitList;
         i < NoUnits; i++,up++)
      if(MemberSetP(si1,up) && !MemberSetP(si2,up))
        AddSetP(si,up);
      else
        RemSetP(si,up);
#endif
    return TRUE;
BFLYTHROW("DifferenceSet",0)
}

/***** InverseSet *****/
/*---------------------------------------------------------------------------
    The set name is assigned to be the inverse of name1. 
    1 is returned if successful (no error); 0 else. 
----------------------------------------------------------------------------*/

InverseSet(name,name1)
    char *name,*name1;
{
    NameDesc look,look1;
    register int i;
    register int si;
    register int si1;
    register Unit * up;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      {
        fprintf(stderr,"InverseSet:  %s not a set\n",name);
        return FALSE;
      }
    if(FindName(name1,&look1) == NULL || look1.type != SET_SYM)
      {
        fprintf(stderr,"InverseSet:  %s not a set\n",name1);
        return FALSE;
      }

#ifdef BCNTL
    Set_Cmd_Names(2,name,name1);
    Send_Range_Cmd(INVERSET_C,0,NoUnits-1);
#else
    for (i=0, si=look.index, si1=look1.index, up=UnitList;
         i < NoUnits; i++,up++)
      if(!MemberSetP(si1,up))
        AddSetP(si,up);
      else
        RemSetP(si,up);
#endif
    return TRUE;
BFLYTHROW("Inverset",0)
}

/***** MemberSet *****/
/*---------------------------------------------------------------------------
  Returns TRUE if unit with index  uindex  is in the set  name
  .  Otherwise returns FALSE, indicating the index was not legal, the
  name was not that of a set, or the unit wasn't in the set.
----------------------------------------------------------------------------*/

MemberSet(name,uind)
    char *name;
    int uind;
{
    NameDesc look;

BFLYCATCH
    if(FindName(name,&look) == NULL || look.type != SET_SYM)
      {
        fprintf(stderr,"MemberSet:  %s not a set\n",name);
        return FALSE;
      }
    if(!LegalUnit(uind))
      {
        fprintf(stderr,"MemberSet:  %d not a unit index\n",uind);
        return FALSE;
      }
#ifdef BCNTL
    return Send_Unit_Cmd(MEMSET_C,uind,look.index,name);
#else
    return MemberSetI(look.index,uind);
#endif
BFLYTHROW("MemberSet",0)
}

