#include "xo_head.h"
#include "XoClickBuffer.h"
#include "XoWhen.h"

char	*fillstr();
Widget	XoGetWidgetFromString();

/*
** WhenClick : a generic when function for widgets like dbut where 
** dragging does not make sense.
*/
void WhenClick(w,event,params,num_params)
	Widget	w;
	XButtonEvent	*event;
	String			*params;
	Cardinal		*num_params;
{
	last_click = current_click;
}

/*
** this only checks if the position is far enough from the orig to
** start using the drag icon call. It does no actual assignments.
*/
void WhenMotion(w,event,params,num_params)
	Widget	w;
	XMotionEvent	*event;
	String	*params;
	Cardinal	*num_params;
{
	if (current_click.motion) {
		UpdateCursorIcon(event);
		return;
	}

	if ((abs(event->x - current_click.screenx) + 
		abs(event->y - current_click.screeny)) > 40) {
		current_click.motion = 1;
	}
}


UpdateCursorIcon(event)
	XMotionEvent	*event;
{
}

do_add_XoWhen(argc,argv)
	int	argc;
	char	**argv;
{
	Widget	w;
	char	*class;
	Arg		args[3];
	XoWhen	*when = NULL;
	int		n;

	if (argc < 5) {
		printf("usage: %s <widget> <action> do <script>\n",argv[0]);
		printf("Allowed actions : click1 click2 click3  drag1 drag2 drag3  \n");
		return;
	}
	if(!(w = XoGetWidgetFromString(argv[1]))) {
		fprintf(stderr,"Cannot find widget '%s'\n",argv[1]);
		return;
	}
	if (!(class = (XtClass(w))->core_class.class_name)) {
		fprintf(stderr,"Cannot find widget '%s'\n",argv[1]);
		return;
	}
	
		n = 0; 
		XtSetArg(args[n],XtNwhen,&when); n++;
		XtGetValues(w,args,n);
		/*
		fprintf(stderr,"Widget '%s' is of class '%s' which does not knowabout WHEN\n",argv[1],class);
		return;
		*/
	if (when) {
		/* finding the last when */
		for ( ; when->next ; when = when->next) ;
		when->next = (XoWhen *) calloc(1,sizeof(XoWhen));
		when = when->next;
	} else {
		when = (XoWhen *) calloc(1,sizeof(XoWhen));
		n = 0; 
		XtSetArg(args[n],XtNwhen,when); n++;
		XtSetValues(w,args,n);
	}
	when->next = NULL;
	when->script = fillstr(argv[4]);
	if (strcmp(argv[2],"click1") == 0) {
		when->action = "click";
		when->button = Button1;
	} else if (strcmp(argv[2],"click2") == 0) {
		when->action = "click";
		when->button = Button2;
	} else if (strcmp(argv[2],"click3") == 0) {
		when->action = "click";
		when->button = Button3;
	} else if (strcmp(argv[2],"drag1") == 0) {
		when->action = "drag";
		when->button = Button1;
	} else if (strcmp(argv[2],"drag2") == 0) {
		when->action = "drag";
		when->button = Button2;
	} else if (strcmp(argv[2],"drag3") == 0) {
		when->action = "drag";
		when->button = Button3;
	} else {
		fprintf(stderr,"action '%s' not known. Using default (click1)\n",argv[2]);
		when->action = "click";
		when->button = Button1;
	}
}

/*
** Assumes that both w and script are checked for 
** Adds a when for click1
*/
do_add_script(w,script)
	Widget	w;
	char	*script;
{
	char	*class;
	Arg		args[3];
	XoWhen	*when = NULL;
	int		n;

	class = (XtClass(w))->core_class.class_name;
		n = 0; 
		XtSetArg(args[n],XtNwhen,&when); n++;
		XtGetValues(w,args,n);
	if (when) {
		/* finding the last when */
		for ( ; when->next ; when = when->next) ;
		when->next = (XoWhen *) calloc(1,sizeof(XoWhen));
		when = when->next;
	} else {
		when = (XoWhen *) calloc(1,sizeof(XoWhen));
		n = 0; 
		XtSetArg(args[n],XtNwhen,when); n++;
		XtSetValues(w,args,n);
	}
	when->script = fillstr(script);
	when->action = "click";
	when->button = Button1;
}

do_list_XoWhen(argc,argv)
	int	argc;
	char	**argv;
{
	Widget	w;
	Arg		args[3];
	XoWhen	*when;
	int		n;
	int		i;

	if (argc < 2) {
		printf("usage: %s widget\n",argv[0]);
		return;
	}
	if(!(w = XoGetWidgetFromString(argv[1]))) {
		fprintf(stderr,"Cannot find widget '%s'\n",argv[1]);
		return;
	}
	when = NULL;
	n = 0; 
	XtSetArg(args[n],XtNwhen,&when); n++;
	XtGetValues(w,args,n);
	if (!when) {
		fprintf(stderr,"Widget '%s' has no scripts attached to it\n",argv[1]);
		return;
	}
	printf("Scripts for widget '%s' : \n",argv[1]);
	for( i = 0; when ; i++ , when = when->next) {
		printf("#%d : script = '%s' , action = '%s %d'\n",i,when->script,
			when->action, when->button);
	}
}

do_drop_XoWhen(argc,argv)
	int	argc;
	char	**argv;
{
	Widget	w;
	Arg		args[3];
	XoWhen	*when,*temp,*last;
	int		n;
	int		i;

	if (argc < 3) {
		printf("usage: %s widget script [all]\n",argv[0]);
		return;
	}
	if(!(w = XoGetWidgetFromString(argv[1]))) {
		fprintf(stderr,"Cannot find widget '%s'\n",argv[1]);
		return;
	}
	when = NULL;
	n = 0; 
	XtSetArg(args[n],XtNwhen,&when); n++;
	XtGetValues(w,args,n);
	if (!when) {
		fprintf(stderr,"Widget '%s' has no scripts attached to it\n",argv[1]);
		return;
	}

	if (strcmp(argv[2],"all") == 0) {
		for (temp = when->next; temp ;temp = when->next) {
			when->next = temp->next;
			free(temp);
			temp = NULL;
		}
		free(when);
		n = 0; 
		XtSetArg(args[n],XtNwhen,NULL); n++;
		XtSetValues(w,args,n);
		when = NULL;
		return;
	}

	if (strcmp(when->script,argv[2]) == 0 && when->next == NULL) {
		/* have to get rid of only 'when' on widget */
		free(when);
		n = 0; 
		XtSetArg(args[n],XtNwhen,NULL); n++;
		XtSetValues(w,args,n);
		when = NULL;
	}

	for (last = NULL ; when ;last = when, when = when->next) {
		if (strcmp(when->script,argv[2]) == 0) {
			temp = when->next;
			if (temp) {
				*when = *temp;
				free(temp);
			} else {
				/* last one, and there was at least one before */
				free(when);
				if (last)
					last->next = NULL;
			}
		}
	}
}

char *
show_current_click(argc,argv)
	int	argc;
	char	**argv;
{
	static char	ret[200];
	if (argc < 2) {
		fprintf(stderr,"usage: %s [value] [index] [button] [sx] [sy] [x] [y] [z]\n",argv[0]);
		printf("value		=	%s\n",current_click.value);
		printf("index		=	%d\n",current_click.index);
		printf("button		=	%d\n",last_click.button);
		printf("screen coords	=	(%d,%d)\n",current_click.screenx,current_click.screeny);
		printf("3-d coords	=	(%f,%f,%f)\n",current_click.x,current_click.y,current_click.z);
		return(current_click.value);
	}

	if (strcmp(argv[1],"value") == 0) 
		strcpy(ret,current_click.value);
	else if (strcmp(argv[1],"index") == 0) 
		sprintf(ret,"%d",current_click.index);
	else if (strcmp(argv[1],"button") == 0) 
		sprintf(ret,"%d",last_click.button);
	else if (strcmp(argv[1],"sx") == 0) 
		sprintf(ret,"%d",current_click.screenx);
	else if (strcmp(argv[1],"sy") == 0) 
		sprintf(ret,"%d",current_click.screeny);
	else if (strcmp(argv[1],"x") == 0) 
		sprintf(ret,"%f",current_click.x);
	else if (strcmp(argv[1],"y") == 0) 
		sprintf(ret,"%f",current_click.y);
	else if (strcmp(argv[1],"z") == 0) 
		sprintf(ret,"%f",current_click.z);
	else {
		fprintf(stderr,"usage: %s [value] [index] [button] [sx] [sy] [x] [y] [z]\n",argv[0]);
		return("");
	}
		return(ret);
}

char *
show_last_click(argc,argv)
	int	argc;
	char	**argv;
{
	static char	ret[200];
	if (argc < 2) {
		fprintf(stderr,"usage: %s [value] [index] [button] [sx] [sy] [x] [y] [z]\n",argv[0]);
		printf("value		=	%s\n",last_click.value);
		printf("index		=	%d\n",last_click.index);
		printf("button		=	%d\n",last_click.button);
		printf("screen coords	=	(%d,%d)\n",last_click.screenx,last_click.screeny);
		printf("3-d coords	=	(%f,%f,%f)\n",last_click.x,last_click.y,last_click.z);
		return(last_click.value);
	}

	if (strcmp(argv[1],"value") == 0) 
		strcpy(ret,last_click.value);
	else if (strcmp(argv[1],"index") == 0) 
		sprintf(ret,"%d",last_click.index);
	else if (strcmp(argv[1],"button") == 0) 
		sprintf(ret,"%d",last_click.button);
	else if (strcmp(argv[1],"sx") == 0) 
		sprintf(ret,"%d",last_click.screenx);
	else if (strcmp(argv[1],"sy") == 0) 
		sprintf(ret,"%d",last_click.screeny);
	else if (strcmp(argv[1],"x") == 0) 
		sprintf(ret,"%f",last_click.x);
	else if (strcmp(argv[1],"y") == 0) 
		sprintf(ret,"%f",last_click.y);
	else if (strcmp(argv[1],"z") == 0) 
		sprintf(ret,"%f",last_click.z);
	else {
		fprintf(stderr,"usage: %s [value] [index] [button] [sx] [sy] [x] [y] [z]\n",argv[0]);
		return("");
	}
	return(ret);
}
