#include "xo_head.h"
#include "draw_funcs.h"

#define MAXNFUNCS 200

char	*fillstr();

struct func_name_struct {
	char	*name;
	char	*func;
};

static struct func_name_struct func_name_table[MAXNFUNCS];
static int	func_name_table_index = 0;

FuncTablePut(name,func)
char *name;
char *func;
{

	if (func_name_table_index >= MAXNFUNCS) {
		fprintf(stderr,"func table full\n");
		return;
	}
	func_name_table[func_name_table_index].name = fillstr(name);
	func_name_table[func_name_table_index].func = func;
	func_name_table_index++;
}

char *FuncTableFindFunc(name)
char	*name;
{
	int i;
	for (i = 0 ; i < func_name_table_index ; i++)
		if (strcmp(name,func_name_table[i].name) == 0)
			return(func_name_table[i].func);
	return(NULL);
}

char *FuncTableFindName(func)
char	*func;
{
	int i;
	for (i = 0 ; i < func_name_table_index ; i++)
		if (func == func_name_table[i].func)
			return(func_name_table[i].name);
	return(NULL);
}

XoInitFuncTable()
{

/* Transforms */
	FuncTablePut("z2d",z2d);
	FuncTablePut("y2d",y2d);
	FuncTablePut("x2d",x2d);
	FuncTablePut("ortho3d",ortho3d);
	FuncTablePut("perspective",perspective);

/* elementary draw routines */
	FuncTablePut("DrawPoints",DrawPoints);
	FuncTablePut("DrawLines",DrawLines);
	FuncTablePut("DrawSegs",DrawSegs);
	FuncTablePut("DrawArrows",DrawArrows);
	FuncTablePut("DrawRects",DrawRects);
	FuncTablePut("DrawIcons",DrawIcons);
	FuncTablePut("DrawString",DrawString);
	FuncTablePut("DrawArcs",DrawArcs);
	FuncTablePut("DrawBitmap",DrawBitmap);
	FuncTablePut("FillRects",FillRects);
	FuncTablePut("FillString",FillString);
	FuncTablePut("FillPoly",FillPoly);
	FuncTablePut("CFillPoly",FillPoly);
	FuncTablePut("FillArcs",FillArcs);
	FuncTablePut("ViewIcons",ViewIcons);
	FuncTablePut("DrawColoredLines",DrawColoredLines);
	FuncTablePut("DrawFatLines",DrawFatLines);
	FuncTablePut("DrawFatColoredLines",DrawFatColoredLines);
	FuncTablePut("DrawTree",DrawTree);

/* Storage mode routines */
	FuncTablePut("UseCoords",UseCoords);
	FuncTablePut("UseElms",UseElms);
	FuncTablePut("UseFile",UseFile);

/* Hilight refresh modes */
	FuncTablePut("RefreshStarHl",RefreshStarHl);
	FuncTablePut("RefreshInvertHl",RefreshInvertHl);
	FuncTablePut("RefreshCountHl",RefreshCountHl);
	FuncTablePut("RefreshIndexHl",RefreshIndexHl);

/* Hilight add modes */
	FuncTablePut("AddStarHl",AddStarHl);
	FuncTablePut("AddInvertHl",AddInvertHl);
	FuncTablePut("AddCountHl",AddCountHl);
	FuncTablePut("AddIndexHl",AddIndexHl);

/* Hilight drop modes */
	FuncTablePut("DropStarHl",DropStarHl);
	FuncTablePut("DropInvertHl",DropInvertHl);
	FuncTablePut("DropCountHl",DropCountHl);
	FuncTablePut("DropIndexHl",DropIndexHl);

/* Hilight clean modes */
	FuncTablePut("CleanViewHl",CleanViewHl);
	FuncTablePut("CleanIconHl",CleanIconHl);
	FuncTablePut("CleanTreeHl",CleanTreeHl);

/* Hilight history modes */
	FuncTablePut("LastOneHist",LastOneHist);
	FuncTablePut("LastTwoHist",LastTwoHist);
	FuncTablePut("FWBLHist",FWBLHist);
	FuncTablePut("FWBFHist",FWBFHist);
}

