#ifndef _Layout_h
#define _Layout_h

#include <X11/Constraint.h>

/***********************************************************************
 *
 * Layout Widget
 *
 ***********************************************************************/

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 defaultDistance     Thickness		int		4
 destroyCallback     Callback		Pointer		NULL
 changeCallback	     Callback		Pointer		NULL
 height		     Height		Dimension	computed at realize
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	computed at realize
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* Constraint parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 append              Boolean            Boolean         FALSE
 xtype               Int                Int             LAYOUT_ABSOLUTE_GRAVITY
 ytype               Int                Int             LAYOUT_ABSOLUTE_GRAVITY
 heightype           Int                Int             LAYOUT_ABSOLUTE_GRAVITY
 widthtype           Int                Int             LAYOUT_ABSOLUTE_GRAVITY
 layout_x            Position           Position        0
 layout_y            Position           Position        0
 layout_w            Dimension          Dimension       100
 layout_h            Dimension          Dimension       100
 layout_wx           String             String          NULL
 layout_wy           String             String          NULL
 layout_ww           String             String          NULL
 layout_wh           String             String          NULL

*/


#define LAYOUT_ABSOLUTE			0	/* 0x00000000 */
#define LAYOUT_RELATIVE			1	/* 0x00000001 */
#define LAYOUT_WIDGET			2	/* 0x00000010 */
#define	LAYOUT_LEFT			4	/* 0x00000100 */
#define LAYOUT_RIGHT			8	/* 0x00001000 */
#define LAYOUT_TOP			32	/* 0x00010000 */
#define LAYOUT_BOTTOM			64	/* 0x00100000 */
#define LAYOUT_WIDTH			128	/* 0x01000000 */
#define LAYOUT_HEIGHT			256	/* 0x10000000 */

/*	#define LAYOUT_ABSOLUTE_FLAG		0x11111111
	#define LAYOUT_RELATIVE_FLAG		0x11111110
	#define LAYOUT_WIDGET_FLAG		0x11111101
	#define	LAYOUT_LEFT_FLAG		0x11111011
	#define LAYOUT_RIGHT_FLAG		0x11110111
	#define LAYOUT_TOP_FLAG			0x11101111
	#define LAYOUT_BOTTOM_FLAG		0x11011111
	#define LAYOUT_WIDTH_FLAG		0x10111111
	#define LAYOUT_HEIGHT_FLAG		0x01111111
*/

#define XtNappend			"append"
#define XtNxtype			"xtype"
#define XtNytype			"ytype"
#define XtNheightype			"heightype"
#define XtNwidthtype			"widthtype"
#define XtNlayout_x			"layout_x"
#define XtNlayout_y			"layout_y"
#define XtNlayout_w			"layout_w"
#define XtNlayout_h			"layout_h"
#define XtNlayout_wx			"layout_wx"
#define XtNlayout_wy			"layout_wy"
#define XtNlayout_ww			"layout_ww"
#define XtNlayout_wh			"layout_wh"
#define XtNlayout_callback		"layout_callback"
#define XtNlayout_element		"layout_element"

#define XtCWidgetString			"WidgetString"
#define XtRWidgetString			"WidgetString"
#define XtCLayoutElement		"LayoutElement"

typedef struct _LayoutClassRec	*LayoutWidgetClass;
typedef struct _LayoutRec		*LayoutWidget;

extern WidgetClass layoutWidgetClass;
 
#endif _Layout_h
