#include "gen_ext.h"
#include "draw_w.h"

int	XoCreateShape();

void xshape_callback(w, client, call)
	LayoutWidget	w;
	caddr_t	client;
	caddr_t	call;
{
	struct xshape_type	*element;

	element = (struct xshape_type *)
		(((LayoutConstraints)(w->core.constraints))->
				layout.layout_element);
	if (element == NULL) {
		fprintf(stderr,"xshape_callback: null element\n");
		return;
	}
	xodus_core_set(element, w);
}

xshape_func(element,action)
	struct xshape_type *element;
	Action		*action;
{
	char	*field, *value;
	LayoutWidget	widget;
	char		**argv;
	static	XtCallbackRec	callback[2];
	static struct valid_arg xshape_args[] = {
		{"pix", 0, 2},
		{"pixname", 0, 2},
		{"pixcolor", 0, 2},
		{"drawmode", 0, 2},
		{"coords", 0, 2},
		{"-coords", 0, 2},
		{"linewidth", 0, 2},
		{"linestyle", 0, 2},
		{"capstyle", 0, 2},
		{"joinstyle", 0, 2},
		{"textmode", 0, 2},
		{"text", 0, 2},
		{"textcolor", 0, 2},
		{"font", 0, 2},
		{"iconname", 0, 2},
		{"hlhistmode", 0, 2},
		{"hldispmode", 0, 2},
		{"value", 0, 2},
		{"tx", 0, 2},
		{"ty", 0, 2},
		{"tz", 0, 2},
		{"END", -1, -1}
	};

	if(debug > 1){
		ActionHeader("Xshape",element,action);
	}

	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}
	argv = (char **) calloc(action->argc + 2,sizeof(char *));

	switch(action->type) {
    	case CREATE: 
			XoParseCoords(&(action->argc),action->argv,argv);
			XoCreateElmPix(element,
				((struct xdraw_type *)action->data)->widget,
				action->argc, argv, XoCreateShape);
			break;
    	case SET:
			XoParseCoords(&(action->argc),action->argv,argv);
			if (x_parse_set(action->argc, argv, xshape_args))
			XoSetElmPix(element, action->argc, argv);
			break;
	case RESET:
		break;
	case	COPY:
		XoCopyElmShape(element,action,XoCreateShape);
		break;
	case DELETE:
		drop_pix(Pathname(element->parent),
                        ((Pix *)(element->pix))->name);
                break;
	default:
			InvalidAction("Xshape",element,action);
			break;
	}
	free(argv);
	return(1);
}

/*
** Puts coords into single string form 
*/
XoParseCoords(argc,argv,ret_argv)
	int		*argc;
	char	**argv;
	char	**ret_argv;
{
	static char	coords[5000];
	int		droparg[500];
	int		i;
	int		j = 0;
	int		k;

	coords[0] = '\0';

	for (i = 0 ; i < 500 ; i++)
		droparg[i] = -1;

	for (i = 0 ; i < *argc ; i++) {
		if (argv[i][0] == '[') {
			/*
			do {
				droparg[j] = i;
				strcat(coords,argv[i]);
				j++;
				i++;
			} while ((argv[i][strlen(argv[i]) - 1] != ']')); 
			*/
			/* end of do-while loop */
			for (; i < *argc ; i++, j++) {
				droparg[j] = i;
				strcat(coords,argv[i]);
				if (argv[i][strlen(argv[i]) - 1] == ']') {
					j++;
					break;
				}
			}
		} else if (strcmp(argv[i],"coords") == 0 ||
			strcmp(&(argv[i][1]),"coords") == 0) {
			droparg[j] = i;
			j++;
		}
	}
	j = 0;
	k = 0;
	for (i = 0 ; i < *argc ; i++) {
		if (droparg[j] == i) {
			j++;		
		} else {
			ret_argv[k] = argv[i];
			k++;
		}
	}

	if (strlen(coords) > 0) {
		ret_argv[k] = "-coords";
		k++;
		ret_argv[k] = coords;
		*argc = k + 1;
	}
}


XoCopyElmShape(element,action,func)
	struct xshape_type	*element;
	Action	*action;
	int		(*func)();
{
	struct xshape_type	*elm;
	static	char	*argv[100];
	int		i;
	char	temp[100];
	char	*fillstr();

	elm = (struct xshape_type *)action->data;

	i = 0;
	argv[i] = "-pixname"; i++ ; argv[i] = fillstr(elm->name); i++;
	argv[i] = "-pixcolor"; i++ ; argv[i] = fillstr(elm->pixcolor); i++;
	argv[i] = "-drawmode"; i++ ; argv[i] = elm->drawmode; i++;
	argv[i] = "-coords"; i++ ; argv[i] = elm->coords; i++;
	sprintf(temp,"%d",elm->linewidth);
	argv[i] = "-linewidth"; i++ ; argv[i] = fillstr(temp); i++;
	argv[i] = "-linestyle"; i++ ; argv[i] = elm->linestyle; i++;
	argv[i] = "-capstyle"; i++ ; argv[i] = elm->capstyle; i++;
	argv[i] = "-joinstyle"; i++ ; argv[i] = elm->joinstyle; i++;
	argv[i] = "-textmode"; i++ ; argv[i] = elm->textmode; i++;
	argv[i] = "-text"; i++ ; argv[i] = elm->text; i++;
	argv[i] = "-textcolor"; i++ ; argv[i] = fillstr(elm->textcolor); i++;
	argv[i] = "-font"; i++ ; argv[i] = elm->font; i++;
	argv[i] = "-iconname"; i++ ; argv[i] = elm->iconname; i++;
	argv[i] = "-hlhistmode"; i++ ; argv[i] = elm->hlhistmode; i++;
	argv[i] = "-hldispmode"; i++ ; argv[i] = elm->hldispmode; i++;
	argv[i] = "-value"; i++ ; argv[i] = elm->value; i++;
	sprintf(temp,"%f",elm->tx);
	argv[i] = "-tx"; i++ ; argv[i] = fillstr(temp); i++;
	sprintf(temp,"%f",elm->ty);
	argv[i] = "-ty"; i++ ; argv[i] = fillstr(temp); i++;
	sprintf(temp,"%f",elm->tz);
	argv[i] = "-tz"; i++ ; argv[i] = fillstr(temp); i++;
	XoCreateElmPix(elm,((struct xdraw_type *)elm->parent)->widget,
		i,argv,func);
}

