#define BARF /* COLOR THING FOR UIPI TO FIX */
#undef BARF /* COLOR THING FOR UIPI TO FIX */
/* --------------------------------------------- */
/* The init routine for setting up a view based on
 * the draw widget.
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"
#include "draw_funcs.h"
#include "drawview_w.h"
#include "xodus_ext.h"


char	*fillstr();
int 	ElmViewUpdateFunc();
static char *GetViewValue();
static Boolean ViewSetHook();
static void	ViewGetHook();


/* --------------------------------------------- */

static XtResource ViewResources[] = {
    {XtNpixname, XtCPixname, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, name),
        XtRString, "view"
    },
    {XtNpixcolor, XtCPixcolor, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, pixcolor),
        XtRString, "Black"
    },
    {XtNviewmode, XtCViewmode, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, viewmode),
        XtRString, "colorview"
    },
    {XtNviewicon, XtCViewicon, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, viewicon),
        XtRString, "fillbox.icon"
    },
    {XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, hlhistmode),
        XtRString, "lastone"
    },
    {XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, hldispmode),
        XtRString, "star"
    },
    {XtNfield, XtCField, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, field),
        XtRString, "x"
    },
    {XtNpath, XtCPath, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, path),
        XtRString, "/"
    },
    {XtNvmin, XtCVmin, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, vmin),
        XtRString, "0.0000000000000"
    },
    {XtNvmax, XtCVmax, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, vmax),
        XtRString, "100.0000000000000"
    },
    {XtNautoscale, XtCAutoscale, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, autoscale),
        XtRString, "TRUE"
    },
    {XtNnx, XtCNx, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, nx),
        XtRString, "10        "
    },
    {XtNny, XtCNy, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, ny),
        XtRString, "10            "
    },
    {XtNautospace, XtCAutospace, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, autospace),
        XtRString, "TRUE"
    },
    {XtNox, XtCOx, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, ox),
        XtRString, "0.00000000000000"
    },
    {XtNoy, XtCOy, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, oy),
        XtRString, "0.00000000000000"
    },
    {XtNoz, XtCOz, XtRString, sizeof(char *),
        XtOffset(ViewPixPtr, oz),
        XtRString, "0.00000000000000"
    },
};


/* 
** Bare bones : give view the path + field and it displays in z2d.
**
** Modes : First item is default.
** Hilight & hilight history : index,number,inverse,border,icon
** Display modes : Most are based on icon lookups to avoid scaling
	calculations. list is in draw.h. Only Ortho proj used.
	Special cases : 
	- Color code perspective and non-standard shapes.
	- Rapid views using blitting ? (using z2d ortho)
** Setup : Using path with wildcards to specify elms and variables
	being displayed. To speed refresh, set up *value[] to variable
	during creation of widget.
*/

/*
** XoCreateView. This deals with all additions and changes to views.
** When a viewname is encountered for the first time a new viewinfo
** structure and associated pix are created. Otherwise the old 
** viewinfo is modified according to the parameters entered.
** All the parameters 
** relevant to a view are controlled from this function.
*/
Pix * 
XoCreateView(parent,args,num_args)
	DrawWidget	parent;
	ArgList	args;
	Cardinal	num_args;
{
	ViewPix			*pix;
	Pix				*image,*icon;

	parent->draw.pixvalue = (char *) calloc(200,sizeof(char));
	pix = (ViewPix *) calloc(1,sizeof(ViewPix));
	pix->viewmode = (char *)calloc(20,sizeof(char));
	pix->viewicon = (char *)calloc(20,sizeof(char));
	pix->pixcolor = (char *)calloc(20,sizeof(char));
	pix->hlhistmode = (char *)calloc(20,sizeof(char));
	pix->hldispmode = (char *)calloc(20,sizeof(char));
	pix->vmin = (char *)calloc(20,sizeof(char));
	pix->vmax = (char *)calloc(20,sizeof(char));
	pix->autoscale = (char *)calloc(20,sizeof(char));
	pix->nx = (char *)calloc(20,sizeof(char));
	pix->ny = (char *)calloc(20,sizeof(char));
	pix->autospace = (char *)calloc(20,sizeof(char));
	pix->path = (char *)calloc(20,sizeof(char));
	pix->field = (char *)calloc(20,sizeof(char));
	pix->ox = (char *)calloc(20,sizeof(char));
	pix->oy = (char *)calloc(20,sizeof(char));
	pix->oz = (char *)calloc(20,sizeof(char));
	
	image = parent->draw.images;
	icon = parent->draw.icons;
	/* Might have to do XrmGetResources here instead if the
	** routine overwrites existing images.  */
	XtGetSubresources(parent,pix,XtNimages,XtCPix,ViewResources,
		XtNumber(ViewResources),args,num_args);

	parent->draw.pixname = fillstr(pix->name);

	parent->draw.images = (Pix *)pix;
	pix->next = image;
	parent->draw.icons = icon;

	pix->resources = ViewResources;
	pix->num_resources = XtNumber(ViewResources);

	SetElmViewPix(parent,pix);
	SetElmViewPath(parent,pix);
	if (!SetElmViewRescale(parent,pix)) {
		fprintf(stderr,"Error in creating View Rescale\n");
		return(NULL);
	}
	if (!SetElmViewUpdate(parent,pix)) {
		fprintf(stderr,"Error in creating View update\n");
		return(NULL);
	}

	SetViewIcons(parent,pix);

	SetHlHistMode(pix,pix->hlhistmode);
	SetHlDispMode(pix,pix->hldispmode);
	/*
	pix->hilight->hl_add = AddViewHl;
	pix->hilight->hl_drop = DropViewHl;
	*/
	pix->hilight->get_value = GetViewValue;
	pix->hilight->hl_clean_disp = CleanViewHl;

	SetPixColor(pix,pix->pixcolor);
	
/*
** Now we can finally step in and set up the values as specified
** by args, since the resources and all have been set up
	XoSetValuesFromStrings(parent,args,num_args);
*/

	RescaleDraw(parent);
	(((ElmViewUpdate *)(pix->update))->func)(parent,pix);
	return((Pix *)pix);
}

/*
** SetElmview has to be split up to deal with the portions separately
** so that the set-values-hook routine can change things selectively.
*/
SetElmViewPix(parent,pix)
	Widget	parent;
	ViewPix	*pix;
{
	Element 	**elms;
	ElmViewUpdate		*update;
	ElmRescale		*rescale;
	ElementList		*elmlist, *WildcardGetElement();

	pix->rescale = (Rescale *) calloc(1,sizeof(ElmRescale));
	pix->update = (Update *) calloc(1,sizeof(ElmViewUpdate));
	pix->refresh_func = ViewIcons;
	pix->set_hook = ViewSetHook;
	pix->get_hook = ViewGetHook;
}

int SetElmViewPath(parent,pix)
	Widget	parent;
	ViewPix	*pix;
{
	Element 		**elms;
	ElmRescale		*rescale;
	ElementList		*elmlist, *WildcardGetElement();
	int				nptrs;

/* Hack to get the thing to work with matts version of the path
** scan routine which should be exterminated anyway
*/
	if (!(elmlist = WildcardGetElement(pix->path, 0))) {
		fprintf(stderr,"couldnt parse path %s\n",pix->path);
		return(0);
	}
	nptrs = elmlist->nelements;
	elms = elmlist->element;
/*
    if (ParseTree(path,&type,&nptrs,&elms) == 
        PATHERROR)
        return;
    if (type & CONNARRAY)
        return;
*/
    if (nptrs == 0 || (!elms)) {
        printf("No elements found for this path (%s)\n", pix->path);
        return(0);
    }

	if (pix->npts < nptrs) {
		if (pix->pts) free(pix->pts);
		if (pix->value) free(pix->value);
		pix->pts = (XPoint *) calloc(nptrs, sizeof(XPoint));
		pix->value = (int *) calloc(nptrs, sizeof(int));
	}
	pix->npts = nptrs;

	rescale = (ElmRescale *)(pix->rescale);
	rescale->elms = elms;
	rescale->path = pix->path;
	rescale->rel_path = NULL;
	rescale->func = UseElms;
	sscanf(pix->ox,"%f",&(rescale->offset.x));
	sscanf(pix->oy,"%f",&(rescale->offset.y));
	sscanf(pix->oz,"%f",&(rescale->offset.z));
	return(1);
}

int SetElmViewUpdate(parent,pix)
	Widget	parent;
	ViewPix	*pix;
{
	int		type = 0,offset = 0,nptrs = 0;
	ElmViewUpdate		*update;

	if (GetElmFieldInfo(pix->field,&type,&offset,
		((ElmRescale *)(pix->rescale))->elms) == PATHERROR) {
		fprintf(stderr,"field '%s' unknown\n",pix->field);
		type  = 0;
		offset = 0;
	}
	update = (ElmViewUpdate *) pix->update;
	update->func = ElmViewUpdateFunc;
	update->vmin = atof(pix->vmin);
	update->vmax = atof(pix->vmax);
	update->autoscale = (strcmp(pix->autoscale,"TRUE") == 0);
	update->field = pix->field;
	update->field_type = type;
	update->offset = offset;
	return(1);
}

SetHlHistMode(pix,mode)
	char *mode;
	ViewPix *pix;
{
	int	(*hist)();
	int	nhist;

	if (!pix->hilight)
		pix->hilight = (Hilight *) calloc(1,sizeof(Hilight));
	pix->hilight->nhl = 0;

	if (strcmp(mode,XtNlastonehist) == 0)
		pix->hilight->hl_hist = LastOneHist;
	else if (strcmp(mode,XtNlasttwohist) == 0)
		pix->hilight->hl_hist = LastTwoHist;
	else if (strcmp(mode,XtNfwbfhist) == 0)
		pix->hilight->hl_hist = FWBFHist;
	else if (strcmp(mode,XtNfwblhist) == 0)
		pix->hilight->hl_hist = FWBLHist;
	else
		pix->hilight->hl_hist = NULL;
}

SetHlDispMode(pix,mode)
	char *mode;
	ViewPix *pix;
{
	int	(*hist)();
	int	nhist;

	if (!pix->hilight) {
		pix->hilight = (Hilight *) calloc(1,sizeof(Hilight));
		pix->hilight->nhl = 0;
	}

	if (strcmp(mode,XtNstarhl) == 0) {
		pix->hilight->hl_refresh = RefreshStarHl;
		pix->hilight->hl_add_disp = AddStarHl;
		pix->hilight->hl_drop_disp = DropStarHl;
	} else if (strcmp(mode,XtNcounthl) == 0) {
		pix->hilight->hl_refresh = RefreshCountHl;
		pix->hilight->hl_add_disp = AddCountHl;
		pix->hilight->hl_drop_disp = DropCountHl;
	} else if (strcmp(mode,XtNinverthl) == 0) {
		pix->hilight->hl_refresh = RefreshInvertHl;
		pix->hilight->hl_add_disp = AddInvertHl;
		pix->hilight->hl_drop_disp = DropInvertHl;
	} else if (strcmp(mode,XtNindexhl) == 0) {
		pix->hilight->hl_refresh = RefreshIndexHl;
		pix->hilight->hl_add_disp = AddIndexHl;
		pix->hilight->hl_drop_disp = DropIndexHl;
	} else if (strcmp(mode,XtNborderhl) == 0) {
		printf("Borderhl not implemented yet\n");
	} else {
		pix->hilight->hl_refresh = NULL;
		pix->hilight->hl_add_disp = NULL;
		pix->hilight->hl_drop_disp = NULL;
	}
}

SetPixColor(pix,color)
	ViewPix	*pix;
	char	*color;
{
#ifdef OLD
	if (!color) color = "Black";
	pix->color = name_to_color(color);
	if (pix->color < 0) pix->color = 0;
	else if (pix->color > 255) pix->color = 255;
#else
	pix->color = (char *)g_copy(color);
#endif OLD
}

int ElmViewUpdateFunc(parent,pix)
	DrawWidget	parent;
	ViewPix	*pix;
{
	int i;
	ElmViewUpdate *update;
	float	*value;
	int		*pixvalue;
	float	vmin,vmax;
	float	scale;
	int		offset;
	Element	**elms;
	char	*e;

	if (pix->npts <= 0) return;
	value = (float *) calloc(pix->npts, sizeof(float));

	update = (ElmViewUpdate *)pix->update;

	elms = ((ElmRescale *)(pix->rescale))->elms;
	offset = update->offset;
	switch (update->field_type) {
		case	FLOATARRAY :
			for (i = 0 ; i < pix->npts; i++ ) 
				value[i]  = *((float *)((char *)elms[i] + offset));
			break;
		case	DOUBLEARRAY :
			for (i = 0 ; i < pix->npts; i++ ) 
				value[i]  = (float)(*((double *)((char *)elms[i] +
					offset)));
			break;
		case	SHORTARRAY :
			for (i = 0 ; i < pix->npts; i++ ) 
				value[i]  = (float)(*((short *)((char *)elms[i] +
					offset)));
			break;
		case	INTARRAY :
			for (i = 0 ; i < pix->npts; i++ ) 
				value[i]  = (float)(*((int *)((char *)elms[i] + 
					offset)));
			break;
		default :
			break;
	}
	if (update->autoscale) {
		vmax = vmin = value[0];
		for (i = 0 ; i < pix->npts; i++) {
			if (vmin > value[i])
				vmin = value[i];
			else if (vmax < value[i])
				vmax = value[i];
		}
		update->vmin = vmin;
		update->vmax = vmax;
		sprintf(pix->vmin,"%f",vmin);
		sprintf(pix->vmax,"%f",vmax);
	}

	pixvalue = pix->value;
	if ((scale = update->vmax - update->vmin) < EPSILON) {
		free(value);
		for (i = 0 ; i < pix->npts; i++) 
			pixvalue[i] = NICONS/2;
		return;
	}

	vmin = update->vmin;
	scale = (float)NICONS / scale;
	for (i = 0 ; i < pix->npts; i++) {
		pixvalue[i] = (value[i] - vmin) * scale;
	}
	free(value);
	return(1);
}

SetElmViewRescale(parent,pix)
	Widget	parent;
	ViewPix		*pix;
{
	ElmRescale	*rescale;
	Element		**elms;
	int			nptrs = pix->npts;
	int	i;
	float	xmax,ymax,zmax,xmin,ymin,zmin;
	float	x,y,z;
	float	dx,dy;
	float	lastx,lasty,lastz;
	float	stepx,stepy;
	int		nx,ny;

	rescale = (ElmRescale *)(pix->rescale);
	elms = rescale->elms;

	if (nptrs > 0) {
		lastx = xmax = xmin = elms[0]->x;
		lasty = ymax = ymin = elms[0]->y;
		lastz = zmax = zmin = elms[0]->z;
	} else {
		xmax = ymax = zmax = xmin = ymin = zmin = 0.0;
	}
	stepx = stepy = BIG;
	for (i = 1 ; i < nptrs ; i++) {
		x = elms[i]->x;
		y = elms[i]->y;
		z = elms[i]->z;
		if (xmax < x)
			xmax = x;
		else if (xmin > x)
			xmin = x;
		if (ymax < y)
			ymax = y;
		else if (ymin > y)
			ymin = y;
		if (zmax < z)
			zmax = z;
		else if (zmin > z)
			zmin = z;
		dx = fabs(lastx - x);
		dy = fabs(lasty - y);
		if (dx > EPSILON && dx < stepx)
			stepx = dx;
		if (dy > EPSILON && dy < stepy)
			stepy = dy;
		lastx = x;
		lasty = y;
	}
	if (strcmp(pix->autospace,"TRUE") == 0) {
		nx = 1 + (xmax - xmin)/stepx;
		ny = 1 + (ymax - ymin)/stepy;
		if (nx * ny  < nptrs) {
			if (nx > ny)
				ny = 1 + nptrs/nx ;
			else
				nx = 1 + nptrs/ny ;
		}
		sprintf(pix->nx,"%d",nx);
		sprintf(pix->ny,"%d",ny);
	} else {
		sscanf(pix->nx,"%d",&nx);
		sscanf(pix->ny,"%d",&ny);
	}

	if (fabs(xmax - xmin) < EPSILON) {
		if (stepy > EPSILON) {
			xmax += stepy/2.0;
			xmin -= stepy/2.0;
		} else
			xmax += 1.0;
	}
	if (fabs(ymax - ymin) < EPSILON) {
		if (stepx > EPSILON) {
			ymax += stepx/2.0;
			ymin -= stepx/2.0;
		} else
			ymax += 1.0;
	}
	if (xmax == xmin && stepy > EPSILON) {
		xmax += stepy/2.0;
		xmin -= stepy/2.0;
	}
	if (ymax == ymin && stepx > EPSILON) {
		ymax += stepx/2.0;
		ymin -= stepx/2.0;
	}

	rescale->nx = nx;
	rescale->ny = ny;
	rescale->xmax = xmax; 
	rescale->xmin = xmin;
	rescale->ymax = ymax; 
	rescale->ymin = ymin;
	rescale->zmax = zmax; 
	rescale->zmin = zmin;
	return(1);
}

SetViewIcons(parent,pix)
	DrawWidget	parent;
	ViewPix	*pix;
{
	Pix		**icons;
	Pix		*icon;
	char	*reficonname;
	Arg		args[2];
	int		i,n;

	reficonname = pix->viewicon;

	if (!(icons = pix->icons)) {
		icons = pix->icons = (Pix **) calloc(NICONS, sizeof(Pix *));
		for ( i = 0 ; i < NICONS ; i++) 
			icons[i] = (Pix *) calloc(1, sizeof(Pix));
	} else {
		for (icon = parent->draw.icons ;
			icon && icon->next && icon->next != icons[0] ;
			icon = icon->next);
		if (icon && icon->next) {
			icon->next = icons[NICONS - 1]->next;
		}
		for ( i = 0 ; i < NICONS ; i++) 
			icons[i]->next = NULL;
	}
	
	if (strcmp(pix->viewmode,XtNboxview) == 0) {
			RefIconView(parent,pix,"box.icon");
	} else if (strcmp(pix->viewmode,XtNfillboxview) == 0) {
			RefIconView(parent,pix,"fillbox.icon");
	} else if (strcmp(pix->viewmode,XtNcolorboxview) == 0) {
			RefIconView(parent,pix,"fillbox.icon");
	} else if (strcmp(pix->viewmode,XtNcolorview) == 0) {
			ColorViewIcons(parent,pix,"fillbox.icon");
	} else if (strcmp(pix->viewmode,XtNsizeiconview) == 0) {
			RefIconView(parent,pix,reficonname);
	} else if (strcmp(pix->viewmode,XtNcoloriconview) == 0) {
			ColorViewIcons(parent,pix,reficonname);
	} else if (strcmp(pix->viewmode,XtNcolorsizeiconview) == 0) {
			RefIconView(parent,pix,reficonname);
	} else {
		printf("viewmode '%s' not known. Using colorview\n",
			pix->viewmode);
			ColorViewIcons(parent,pix,"fillbox.icon");
	}
}

/*
** RefIconView first scales the icon it is passed to the size 
** suitable for the current view
** Then it makes copies of the icon and assigns color and size to them
*/
RefIconView(parent,pix,reficonname)
	DrawWidget	parent;
	ViewPix	*pix;
	char	*reficonname;
{
	Pix *ic,*reficon;
	Pix	**icons;
	Arg	args[2];
	Coord	*coords, *refcoords;
	Coord 	scale,offset;
	CoordRescale	*rescale, *rs;
	char	*viewmode;
	int	i,j,n;
	float fli;
	char	temp[5];

	if (!(rescale = ((CoordRescale *)(pix->rescale)))) return;

	/* Getting and rescaling the reference icon */
	offset.x = offset.y = offset.z = 0.0;
	scale.x = (rescale->xmax - rescale->xmin)/(float)(rescale->nx * 2);
	scale.y  = (rescale->ymax - rescale->ymin)/(float)(rescale->ny * 2);
	scale.z = 0.0;
	if (!(reficon = ScaleAndCopyIcon(reficonname,scale,offset))) {
		fprintf(stderr,"Could not find icon '%s'\n",reficonname);
		return;
	}

	if (!(rescale = ((CoordRescale *)(reficon->rescale)))) return;
	/* Making a bunch of icons based on the reference one */
	refcoords = rescale->coords;
	icons = pix->icons;
	viewmode = pix->viewmode;

	for (i = 0 ; i < NICONS ; i++) {
		ic = icons[i];
		*ic = *reficon;
		if (i > 0)
			icons[i - 1]->next = ic;

		fli = (float)i / (float)NICONS;
		if (strcmp(viewmode,XtNcolorsizeiconview) == 0 ||
			strcmp(viewmode,XtNcolorboxview) == 0){
#ifdef BARF
				ic->color = (char *)g_copy("blue");
#else
				ic->color = (char *)i;
#endif BARF
		}
		rs = (CoordRescale *) calloc(1,sizeof(CoordRescale));
		*rs = *rescale;
		ic->rescale = (Rescale *)rs;
		coords = rs->coords = (Coord *) calloc(reficon->npts, sizeof(Coord));
		ic->pts = (XPoint *) calloc(reficon->npts,sizeof(XPoint));
		for (j = 0 ; j < reficon->npts ; j++) {
			coords[j].x = refcoords[j].x * fli;
			coords[j].y = refcoords[j].y * fli;
			coords[j].z = refcoords[j].z * fli;
		}
	}
	/*
	** we put the icons in the draw->icon linklist so that
	** they get transformed along with the other coordinates.
	** We have to check that the icons are not already there
	** or we will end up in a closed loop.
	*/
	ic = parent->draw.icons;

	if (ic) {
		for (; ic->next ; ic = ic->next);
		ic->next = icons[0];
	} else {
		parent->draw.icons = icons[0];
	}
}

ColorViewIcons(parent,pix,reficonname)
	Widget	parent;
	ViewPix *pix;
	char	*reficonname;
{
	Pix *ic,*reficon;
	Pix	**icons;
	int	i;
	float col;
	Coord 	scale,offset;
	CoordRescale	*rescale;
	static char	tempname[200];
	Pix		*tempicon, *nexticon;

	/* Getting and rescaling the reference icon */
	if (!(rescale = ((CoordRescale *)(pix->rescale)))) return;
	offset.x = offset.y = offset.z = 0.0;
	scale.x = (rescale->xmax - rescale->xmin)/(float)(rescale->nx * 2);
	scale.y  = (rescale->ymax - rescale->ymin)/(float)(rescale->ny * 2);
	scale.z = 0.0;
	if (!(reficon = ScaleAndCopyIcon(reficonname,scale,offset))) {
		fprintf(stderr,"Could not find icon '%s'\n",reficonname);
		return;
	}
	sprintf(tempname,"%s_ref.icon",pix->name);
	ic = add_pix2(parent,tempname,sizeof(Pix));
	reficon->next = ic->next;
	*ic = *reficon;

	icons = pix->icons;
	col = 245.0 / (float)NICONS;

	for (i = 0 ; i < NICONS ; i++) {
		ic = icons[i];
		/*
		ic = icons[i] = (Pix *) calloc(1, sizeof(Pix));
		** we just assign to ic all the values from reficon
		** except the color
		*/
		*ic = *reficon;
		ic->next = NULL;
#ifdef BARF
		ic->color = (char *)g_copy("red");
#else
		ic->color = (char *) i;
#endif BARF
	}
	/* We do not need to put these into the rescale linklist since 
	** the reficon is going to be scaled and the others are using
	** its coordinates.
	*/
}

int GetElmFieldInfo(fieldname,fieldtype,fieldoffset,elms)
    char 	*fieldname;
	int		*fieldtype;
	int		*fieldoffset;
	Element **elms;
{
    int i;
    int len;
    int is_at_wildcard;
	char	*elmtype;
    char    *type;
    Info    info;

   	elmtype = elms[0]->object->type;
	if (!elmtype) 
		elmtype = "element_type";
    *fieldoffset = 
        CalculateOffset(elmtype,fieldname,&info);
    type = info.type;
	if (!type || *fieldoffset < 0)  return(0);

    if (strcmp(type,"float") == 0) 
        *fieldtype |= FLOATARRAY;
    else if (strcmp(type,"int") == 0) 
        *fieldtype |= INTARRAY;
    else if (strcmp(type,"short") == 0) 
        *fieldtype |= SHORTARRAY;
    else if (strcmp(type,"double") == 0) 
        *fieldtype |= DOUBLEARRAY;
    else {
		printf("field type '%s' is not good for numerical displays\n",
			type);
        return(PATHERROR);
	}
	return(PATHSET);
}

char *fillstr(b)
	char *b;
{
	char *a;

	a = (char *) malloc((strlen(b) + 1) * sizeof(char));
	strcpy(a,b);
	return(a);
}

/*
static int AddViewHl(pict,pix,index)
	DrawPart	*pict;
	ViewPix	*pix;
	int		index;
{
	strcpy (pict->pixvalue,
		Pathname(((ElmRescale *)(pix->rescale))->elms[index]));

	(pix->hilight->hl_add_disp)(pict,pix,index);
}

static int DropViewHl(pict,pix,index)
	DrawPart	*pict;
	ViewPix	*pix;
	int		index;
{
	(pix->hilight->hl_drop_disp)(pict,pix,index);
}
*/

static char *
GetViewValue(pict,pix,index)
	DrawPart	*pict;
	ViewPix	*pix;
	int		index;
{
	static char	path[200];

	strcpy (path,
		Pathname(((ElmRescale *)(pix->rescale))->elms[index]));
	return(fillstr(path));
}



int ViewIcons(pict,pix)
    DrawPart  *pict;
    ViewPix  *pix;
{
    int     *value;
    int     index;
    int     i,j;
    Pix     **icons,*icon;
    int     niconpts = 0;
    XPoint  *pts,*oldpts,*pixpts;
    short   x,y,w,h;
	int		colorflag = 0;


    pixpts = pix->pts;
    value = pix->value;
    icons = pix->icons;

    if (!(icons = pix->icons)) return(0);
	if (!(pict->w)) {
		fprintf(stderr,"View Window has not been displayed yet\n");
		return(0);
	}
    h = pict->w->core.height;
    w = pict->w->core.width;

    for (i = 0 ; i < NICONS ; i++) {
        if (icons[i]->npts > niconpts)
            niconpts = icons[i]->npts;
    }
	if (niconpts <= 0) {
		fprintf(stderr,"No coords for icon\n");
		return;
	}
    pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
    pixpts = pix->pts;

	if (strcmp(pix->viewmode,XtNboxview) == 0 || 
		strcmp(pix->viewmode,XtNfillboxview) == 0 || 
		strcmp(pix->viewmode,XtNsizeiconview) == 0) {
		colorflag = 1;
    	XSetForeground(pict->display,pict->gc,
			name_to_color(icons[0]->color));
	}

    for ( i = 0 ; i < pix->npts; i++) {
        x = pixpts[i].x;
        y = pixpts[i].y - h;
		if (x < -w || x > (w + w) || y < -h || y > (h + h)) 
			continue;

        index = value[i];
        if (index < 0)
            index = 0;
        else if (index >= NICONS)
            index = NICONS - 1;
        icon = icons[index];

        oldpts = icon->pts;
        for (j = 0 ; j < icon->npts ; j++) {
            pts[j].x = oldpts[j].x + x;
            pts[j].y = oldpts[j].y + y;
        }
        icon->pts = pts;
		if (!colorflag)
			if (output_flag == PSOUT)
        		XSetForeground(pict->display,pict->gc,
					(int)icon->color);
			else
        		XSetForeground(pict->display,pict->gc,
					colorscale[(int)icon->color]);
        (icon->refresh_func)(pict,icon);
        icon->pts = oldpts;
    }
    free(pts);
    XSetForeground(pict->display,pict->gc,XBlackPixel(pict->display,0));
    if (pix->hilight) {
        (pix->hilight->hl_refresh)(pict,pix);
    }
}

int UnViewIcons(pict,pix)
    DrawPart  *pict;
    ViewPix  *pix;
{
    int     *value;
    int     index;
    int     i,j;
    Pix     **icons,*icon;
    int     niconpts = 0;
    XPoint  *pts,*oldpts,*pixpts;
    short   x,y,w,h;
	int		colorflag = 1;


	if ((strcmp(pix->viewmode,XtNcolorview) == 0) ||
		(strcmp(pix->viewmode,XtNcoloriconview) == 0)) 
		return;

    pixpts = pix->pts;
    value = pix->value;
    icons = pix->icons;

    if (!(icons = pix->icons)) return(0);
	if (!(pict->w)) {
		fprintf(stderr,"View Window has not been displayed yet\n");
		return(0);
	}
    h = pict->w->core.height;
    w = pict->w->core.width;

    for (i = 0 ; i < NICONS ; i++) {
        if (icons[i]->npts > niconpts)
            niconpts = icons[i]->npts;
    }
    pts = (XPoint *) malloc(niconpts * sizeof(XPoint));
    pixpts = pix->pts;

   	XSetForeground(pict->display,pict->gc,
		XWhitePixel(pict->display,XDefaultScreen(pict->display)));

    for ( i = 0 ; i < pix->npts; i++) {
        x = pixpts[i].x;
        y = pixpts[i].y - h;
		if (x < -w || x > (w + w) || y < -h || y > (h + h)) 
			continue;

        index = value[i];
        if (index < 0)
            index = 0;
        else if (index >= NICONS)
            index = NICONS - 1;
        icon = icons[index];

        oldpts = icon->pts;
        for (j = 0 ; j < icon->npts ; j++) {
            pts[j].x = oldpts[j].x + x;
            pts[j].y = oldpts[j].y + y;
        }
        icon->pts = pts;
        (icon->refresh_func)(pict,icon);
        icon->pts = oldpts;
    }
    free(pts);
    XSetForeground(pict->display,pict->gc,
		XBlackPixel(pict->display,XDefaultScreen(pict->display)));
}


static Boolean ViewSetHook(parent,pix,argnames,nargs)
	DrawWidget	parent;
	ViewPix	*pix;
	char	**argnames;
	int		nargs;
{
	int		i;
	Boolean do_update = FALSE;
	Boolean do_rescale = FALSE;
	Boolean do_viewpath = FALSE;

	if (nargs == 0) 
		return(FALSE);

	for (i = 0 ; i < nargs ; i++) {
		if (strcmp(argnames[i],XtNpixcolor) == 0) {
			SetPixColor(parent,pix);
		} else if (strcmp(argnames[i],XtNviewmode) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNviewicon) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNpath) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNhlhistmode) == 0) {
			SetHlHistMode(pix,pix->hlhistmode);
		} else if (strcmp(argnames[i],XtNhldispmode) == 0) {
			SetHlDispMode(pix,pix->hldispmode);
		} else if (strcmp(argnames[i],XtNfield) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNvmin) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNvmax) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNautoscale) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNnx) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNny) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNautospace) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNox) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNoy) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNoz) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		}
	}
	if (do_viewpath) {
		SetElmViewPath(parent,pix);
	}
	if (do_rescale) {
		SetElmViewRescale(parent,pix);
		SetViewIcons(parent,pix);
		RescaleDraw(parent);
	}
	if (do_update) {
		SetElmViewUpdate(parent,pix);
		ElmViewUpdateFunc(parent,pix);
	}

	return(TRUE);
}

static void	ViewGetHook(pix,rl,args,nargs)
	ViewPix	*pix;
	XrmResourceList	rl;
	ArgList	args;
	Cardinal	nargs;
{
}
