#ifndef XtNlabel
#define XtNlabel      "label"
#endif 
#ifndef XtNfont
#define XtNfont       "font"
#endif

#define XtNimages		"images"
#define XtNicons		"icons"
#define XtNcx			"cx"
#define XtNcy			"cy"
#define XtNcz			"cz"
#define XtNvx			"vx"
#define XtNvy			"vy"
#define XtNvz			"vz"
#define XtNwx			"wx"
#define XtNwy			"wy"
#define XtNvalue		"value"
#define XtNpixname		"pixname"
#define XtNpixchoose	"pixchoose"
#define XtNtransform	"transform"
#define XtNrefresh_flag	"refresh_flag"
#define XtNhlhistmode   "hlhistmode"
#define XtNhldispmode   "hldispmode"


#define XtCPix			"Pix"
#define XtCValue		"Value"
#define XtCPixname		"Pixname"
#define XtCPixchoose	"Pixchoose"
#define XtCCenter		"Center"
#define XtCViewpt		"Viewpt"
#define XtCWx			"Wx"
#define XtCWy			"Wy"
#define XtCTransform	"Transform"
#define XtCRefresh_flag	"Refresh_flag"
#define XtCHlhistmode	"Hlhistmode"
#define XtCHldispmode	"Hldispmode"

#define XtCDraw		"Draw"
#define XtCDrawSize	"DrawSize"

#define PATHERROR  0
#define PATHSET    1
#define PATHNOTSET 2

#define CHUNKSIZE  500

#define ELMARRAY	0
#define CONNARRAY	1 << 4
#define FLOATARRAY	1
#define INTARRAY	2
#define SHORTARRAY	3
#define DOUBLEARRAY 4

/**********************************************************
**                                                       **
**                    HL HIST MODES                      **
**                                                       **
**********************************************************/

#define	XtNlastonehist	"lastone"
#define	XtNlasttwohist	"lasttwo"
#define	XtNfwbfhist		"fwbf"
#define	XtNfwblhist		"fwbl"

/**********************************************************
**                                                       **
**                    HL DISP MODES                      **
**                                                       **
**********************************************************/

#define XtNstarhl	"star"
#define	XtNindexhl	"index"
#define	XtNcounthl	"count"
#define	XtNinverthl	"invert"
#define	XtNborderhl	"border"


/**********************************************************
**                                                       **
**                   DATA STRUCTURES                     **
**                                                       **
**********************************************************/


/************************/
/*		RESCALE			*/
/************************/

#define RESCALE_STRUCT_TYPE \
	float	xmin,xmax; \
	float	ymin,ymax; \
	float	zmin,zmax; \
	Coord	offset; \
	int	(*func)();

typedef struct rescale_struct {
	RESCALE_STRUCT_TYPE
} Rescale;

/************************/
/*		UPDATE			*/
/************************/

typedef struct update_struct {
	int	(*func)();
} Update;

/************************/
/*		HILIGHT			*/
/************************/

#define MAXNHL	20

typedef struct hilight_struct {
	int	nhl;
	int	index[MAXNHL]; /* Index of portion of pix to be hilighted */
	int	(*hl_hist)(); /* routine which handles hist of hilight */
	char	*(*get_value)(); /* routine for getting value of pix */
	int	(*hl_refresh)(); /* routine for displaying all hilights */
	int	(*hl_add_disp)(); /* routine for displaying a new hilight */
#ifdef OLDVERSION
	int	(*hl_add)(); /* routine called when hilight is added */
	int	(*hl_drop)(); /* routine called when hilight is dropped */
#endif OLDVERSION
	int	(*hl_drop_disp)(); /* routine for undisplaying old hilight */
	int	(*hl_clean_disp)(); /* routine for cleaning up after hilight */
} Hilight;

/************************/
/*			PIX			*/
/************************/

struct pix_struct;

#define PIX_CORE_TYPE \
	char	*color; \
	/******** private parts of pix ********/ \
	char	*name; \
	struct	pix_struct	*next; \
	XPoint	*pts; \
	short	npts; \
	int		(*refresh_func)(); \
	int		(*delete_func)(); \
	Update		*update; \
	Rescale		*rescale; \
	Hilight		*hilight; \
	XtResourceList	resources; \
	Cardinal	num_resources; \
	Boolean		(*set_hook)(); \
	void		(*get_hook)();


typedef struct pix_struct {
	PIX_CORE_TYPE
} Pix;

/************************/
/*			PICT		*/
/************************/

#define PICT_CORE_TYPE \
	Pix			*icons; \
	Pix			*images; 

typedef struct picture_struct {
	PICT_CORE_TYPE 
} Picture;

/*****************************************************************
**                                                              **   
**                      derived structures                      **   
**                                                              **   
*****************************************************************/

/************************/
/*		PIXES			*/
/************************/

typedef struct string_pix_struct {
	PIX_CORE_TYPE
	char **string;
}	StringPix;

typedef struct unival_pix_struct {
	PIX_CORE_TYPE
	int	*value;
}	UnivalPix;


typedef struct bival_pix_struct {
	PIX_CORE_TYPE
	int	*value;
	int	*value2;
}	BivalPix;

typedef struct icon_pix_struct {
	PIX_CORE_TYPE
	Pix		**icons;
} IconPix;

/************************/
/*		RESCALES		*/
/************************/

typedef struct coord_rescale_struct {
	RESCALE_STRUCT_TYPE
	int		nx,ny;
	Coord	*coords;
} CoordRescale;

typedef struct elm_rescale_struct {
	RESCALE_STRUCT_TYPE
	int		nx, ny;
	Element	**elms;
	char	*path;
	char	*rel_path;
} ElmRescale;

/************************/
/*		UPDATES			*/
/************************/
typedef struct elm_view_update_struct {
	int		(*func)();
	float	vmin,vmax;
	int		autoscale;
	char	*field;
	short	field_type;
	int		offset;
} ElmViewUpdate;

typedef struct coord_view_update_struct {
	int		(*func)();
	float	vmin,vmax;
	int		autoscale;
} CoordViewUpdate;

/*************************************************************/

#ifdef	EXPLANATION
	short		background;	/* background color */ \
	Coord		viewpt;		/* position of viewer */ \
	Coord		center;		/* center of viewplane. The line from */ \
							/* viewpt to center is the  */ \
							/* normal to the plane */
	float		width;		/* width and height of window onto */
	float		height;		/* viewplane that are shown on screen. */
							/* The center of the window == center. */
	float		rotation; 	/* In degrees, the rotation of the */
							/* viewplane wr to default: z,y axes */
#endif

/*
** pixfunc is of form 
** int pixfunc(pict,pix)
**		Picture *pict;
**		Pix(or extension thereof)	 *pix;
** All the graphics variables like w,display,d,gc are in pict.
**
** int pixfunc(w,display,d,gc,pix)
** 	Widget	w;
**	Display display;
**	Drawable d;
**	GC		gc;		
**	Pix(or extension thereof)	 *pix;
** {}
**
**	There are five functions associated with each pix :
**	1 - Refresh : Screen level draw routines for refresh.
**	2 - Rescale	: Transforms from stored form to screen coordinates.
**	3 - Update	: Routines for redisplaying changed data.
**	4 - Hilight : Routines for hilighting pixes.
**	5 - Delete	: Routines for deleting pixes.
**
**	In addition to these five, there are two other routines associated
**	with the pixes which relate it to the outside world. These are
**	the "add_pix..." routine and the "set_pix..." routine, used in
**	the creation and altering of a pix.
**
**
**
** Standard Refresh calls (many based directly on X routines)
**		DrawPoints
**		DrawLines
**		DrawSegs
**		DrawRects
***		DrawArcs
***		DrawBitmap
**		FillRects
**		FillPoly
***		FillArcs
**
**		DrawText is a few X calls doing what one ought to.
**		FillText is a few X calls doing what one ought to.
**
**		DrawIcons calculates offsets and calls subsidiary pixes.
**
**		ViewIcons uses values to index other pixes.
**
**		DrawColoredLines uses values for color
**		DrawFatLines uses values for thickness
**		DrawFatColoredLines uses values for color and thickness
**
**
** Standard transforms and coordinate sourcing calls
**
**	Coord sourcing :
**		UseCoords
**		UseElms
***		UseFile
***		UsePt
**
**	Projections onto screen.
**		z2d
**		y2d
**		x2d
**		ortho3d
**		perspective
**
**
** Standard Hilighting calls
**
**	Hilight refresh
**		RefreshStarHl
**		InvertHl
**		CountHl
**		IndexHl
**		BorderHl
**		IconHl
**
**	Hilight add
**		AddStarHl
**
**	Hilight drop
**		DropViewHl
**
**	Hilight history
**		LastOne
**		LastTwo
**		FWBLHist
**		FWBFHist
**
**
**
** Some of the widgets using the draw functionality.
**
**		logo
**		view
**		conn
**		cell
**		elmtree
**		linktree
**
**
*/


typedef struct _DrawRec *DrawWidget;
extern WidgetClass drawWidgetClass;

extern Pix *find_pix();
extern Pix *find_pix2();
extern Pix *add_pix2();
extern Pix *copy_pix2();
extern Pix *ScaleAndCopyPix();
extern Pix *ScaleAndCopyIcon();
