#include	"com_ext.h"
#include	<X11/IntrinsicP.h>
#ifdef X11R3
#include	<X11/Label.h>
#else
#include	<X11/Xaw/Label.h>
#endif X11R3
#include	"dbut_w.h"
#include	"toggle_w.h"
#include	"xodus_args.h"
#include	"header.h"
#include	"struct_defs.h"
#include	"sim_struct.h"

Widget
do_dialog(argc,argv)
	int	argc;
	char	**argv;
{
	int	xt, yt, wt, ht;
	int	usercoord;
	Widget	ret_wid;
	char	*name;

	if (argc < 2) {
		printf("usage: %s dialog-name\n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-widgets [x,y,w,h] || xwidget=str ...\n");
		printf("	-script script\n"); 
		printf("	-form str || form=str\n");
		printf("	-title str || title=str\n");
		printf("	-default str || default=str\n");
		return(NULL); 
	}

	xodus_reset_arg();
	genesis_find_form(argv[1]);

	name = (char *)GetBaseComponent(argv[1]);

	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);

	usercoord = 0;

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);

	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"%s: No parent form selected\n");
		return(NULL);
	}
	ret_wid = (Widget)x_dialog(x_arg(ARG_FORM),
		x_arg(ARG_NAME), x_arg(ARG_TITLE),
		x_arg(ARG_STRING), 
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		xt,yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);

	return(ret_wid);
}

Widget
do_toggle(argc,argv)
	int	argc;
	char	**argv;
{
	int	xt, yt, wt, ht;
	int	usercoord;
	Widget	ret_wid;
	char	*name;

	if (argc < 2) {
		printf("usage: %s toggle-name \n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-widgets [x,y,w,h] || xwidget=str ...\n");
		printf("	-script script\n"); 
		printf("	-form str || form=str\n");
		printf("	-title str || title=str\n");
		return(NULL);
	}

	xodus_reset_arg();
	genesis_find_form(argv[1]);

	name = (char *)GetBaseComponent(argv[1]);

	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);

	usercoord = 0;

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);

	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"%s: No parent form selected\n");
		return(NULL);
	}

	ret_wid = (Widget)x_toggle(x_arg(ARG_FORM),
		x_arg(ARG_NAME), x_arg(ARG_TITLE),
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		xt,yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);
	return(ret_wid);
}

Widget
do_label(argc,argv) 
	int	argc;
	char	**argv;
{
	char	*name;
	int	usercoord;
	int	xt, yt, wt, ht;
	LabelWidget	ret_wid;

	if (argc < 2) {
		printf("usage: %s label-name\n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-widgets [x,y,w,h] || xwidget=str ...\n");
		printf("	-form str || form=str\n");
		printf("	-title str || title=str\n");
		return(NULL);
	}

	xodus_reset_arg();
	genesis_find_form(argv[1]);

	usercoord = 0;

	name = (char *)GetBaseComponent(argv[1]);

	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);
	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"%s: No parent form selected\n");
		return(NULL);
	}

	ret_wid = (LabelWidget)x_label(x_arg(ARG_FORM),
		x_arg(ARG_NAME), g_copy(x_arg(ARG_TITLE)),
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		xt,yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);
	return((Widget)ret_wid);
}

/*
** do_xform:
*/
Widget
do_xform(argc,argv)
int argc;
char **argv;
{
	int	usercoord;
	int	xt,yt,wt,ht;
	char	*name;
	Widget	ret_wid;

	if(argc < 2){
		printf("usage: %s formname\n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-title str || title=str\n");
		printf("	-nolabel || label=<0|1>\n");
		return(NULL);
	}

	xodus_reset_arg();

	name = (char *)GetBaseComponent(argv[1]);
	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);


	usercoord = 0;

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);

	ret_wid = (Widget) x_form(x_arg(ARG_NAME),
		x_arg(ARG_TITLE),
		atoi(x_arg(ARG_LABEL)),
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		usercoord);
	return(ret_wid);
}

/*
** do_xbutton:
*/
Widget
do_xbutton(argc,argv)
int argc;
char **argv;
{
	int	usercoord;
	int	xt, yt, wt, ht;
	Widget	ret_wid;
	char	*name;

	if(argc < 2){
		printf("usage: %s button-name \n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-widgets [x,y,w,h] || xwidget=str ...\n");
		printf("	-script script\n"); 
		printf("	-form str || form=str\n");
		printf("	-title str || title=str\n");
		return(NULL);
	}

	xodus_reset_arg();
	genesis_find_form(argv[1]);

	name = (char *)GetBaseComponent(argv[1]);

	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);


	usercoord = 0;

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);
	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"%s: No parent form selected\n");
		return(NULL);
	}

	ret_wid = (Widget)x_button(x_arg(ARG_FORM),
		x_arg(ARG_NAME), x_arg(ARG_TITLE),
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		xt,yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);
	return(ret_wid);
}


do_slider(argc,argv)
    int argc;
    char    **argv;
{
	fprintf(stderr,"SLIDER CURRENTLY DISABLED\n");
}

Widget
do_axis_graph(argc,argv)
    int argc;
    char    **argv;
{
	int		xt,yt,wt,ht,usercoord;
	Widget	ret_wid;
	char	*name;

	if (argc < 2) {
		printf("usage: %s graphname\n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-widgets [x,y,w,h] || xwidget=str ...\n");
		printf("	-range [xmin ymin xmax ymax] || xmin=# ...\n");
		printf("	-title str || title=str\n");
		printf("	-form str || form=str\n");
		return(NULL);
	}


	xodus_reset_arg();
	genesis_find_form(argv[1]);

	name = (char *)GetBaseComponent(argv[1]);

	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);

	usercoord = 0;

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);
	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"%s: No parent form selected\n");
		return(NULL);
	}

	ret_wid = (Widget)x_axis_graph(x_arg(ARG_FORM),
		x_arg(ARG_NAME),
		g_copy(x_arg(ARG_TITLE)),
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		atof(x_arg(ARG_XMIN)),
		atof(x_arg(ARG_YMIN)),
		atof(x_arg(ARG_XMAX)),
		atof(x_arg(ARG_YMAX)),
		xt,yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);
	return(ret_wid);

}

Widget
do_simple_graph(argc,argv)
    int argc;
    char    **argv;
{
	int		xt,yt,wt,ht,usercoord;
	Widget		ret_wid;
	char		*name;

	if (argc < 2) {
		printf("usage: %s graphname\n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-widgets [x,y,w,h] || xwidget=str ...\n");
		printf("	-range [xmin ymin xmax ymax] || xmin=# ...\n");
		printf("	-title str || title=str\n");
		printf("	-form str || form=str\n");
		return;
	}


	xodus_reset_arg();
	genesis_find_form(argv[1]);

	name = (char *)GetBaseComponent(argv[1]);

	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);

	usercoord = 0;

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);
	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"%s: No parent form selected\n");
		return(NULL);
	}

	ret_wid = (Widget)x_simple_graph(x_arg(ARG_FORM),
		x_arg(ARG_NAME),
		x_arg(ARG_TITLE),
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		atof(x_arg(ARG_XMIN)),
		atof(x_arg(ARG_YMIN)),
		atof(x_arg(ARG_XMAX)),
		atof(x_arg(ARG_YMAX)),
		xt,yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);
	return(ret_wid);
}

Widget
do_image(argc,argv)
	int	argc;
	char	**argv;
{
	int	xt, yt, wt, ht;
	int	usercoord;
	Widget	ret_wid;
	char	*name;

	if (argc < 2) {
		printf("usage: %s image-name \n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-widgets [x,y,w,h] || xwidget=str ...\n");
		printf("	-form str || form=str\n");
		printf("	-title str || title=str\n");
		return(NULL);
	}

	xodus_reset_arg();
	genesis_find_form(argv[1]);

	name = (char *)GetBaseComponent(argv[1]);

	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);

	usercoord = 0;

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);

	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"%s: No parent form selected\n");
		return(NULL);
	}

	ret_wid = (Widget)x_image(x_arg(ARG_FORM),
		x_arg(ARG_NAME), x_arg(ARG_TITLE),
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		xt,yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);
	return(ret_wid);
}

/*
** genesis_find_form:	Traverse backwards to find a parent form.
**
*/
genesis_find_form(path)
	char	*path;
{
	Element *element;
	Element *parent,*GetElement();
	int 	class;
	char	*parentpath,*GetParentComponent();

	if(strlen(parentpath = GetParentComponent(path))== 0){
		parentpath = ".";
	}
	if((parent = GetElement(parentpath)) == NULL){
		return;
	}
	class = ClassID("form");
	for(;parent;parent=parent->parent){
		if(CheckClass(parent,class)){
			xodus_arg_set(ARG_FORM, Pathname(parent));
			return;
		}	
	}
}


Widget
do_xtext(argc,argv) 
	int	argc;
	char	**argv;
{
	char	*name;
	int	usercoord;
	int	xt, yt, wt, ht, i;
	LabelWidget	ret_wid;

	if (argc < 2) {
		printf("usage: %s text-name [-file text-file]\n", argv[0]);
		printf("	[x,y,w,h]> || x=#, y=#...\n"); 
		printf("	-widgets [x,y,w,h] || xwidget=str ...\n");
		printf("	-form str || form=str\n");
		printf("	-title str || title=str\n");
		return(NULL);
	}

	xodus_reset_arg();
	genesis_find_form(argv[1]);

	usercoord = 0;

	name = (char *)GetBaseComponent(argv[1]);

	xodus_arg_set(ARG_NAME, name);
	xodus_arg_set(ARG_TITLE, name);

	xodus_parse_args(argc-2, argv+2, &xt, &yt, &wt, &ht, &usercoord);
	if (strcmp(x_arg(ARG_FORM), "") == 0) {
		fprintf(stderr,"%s: No parent form selected\n");
		return(NULL);
	}
	if (x_arg(ARG_FILENAME) == NULL ||
		strcmp(x_arg(ARG_FILENAME), "") == 0) {
		fprintf(stderr,"xtext: No file selected\n");
		return(NULL);
	}
	i = open(x_arg(ARG_FILENAME), O_RDONLY, 07777);
	if (i < 0) {
		fprintf(stderr,"%s: No such file '%s'\n",argv[0],
				x_arg(ARG_FILENAME));
		return(NULL);
	}
	close(i);
	ret_wid = (LabelWidget)x_text(x_arg(ARG_FORM),
		x_arg(ARG_NAME),  x_arg(ARG_FILENAME), g_copy(x_arg(ARG_TITLE)),
		atoi(x_arg(ARG_X)),
		atoi(x_arg(ARG_Y)),
		atoi(x_arg(ARG_W)),
		atoi(x_arg(ARG_H)),
		xt,yt,wt,ht,
		g_copy(x_arg(ARG_XWIDGET)),
		g_copy(x_arg(ARG_YWIDGET)),
		g_copy(x_arg(ARG_WWIDGET)),
		g_copy(x_arg(ARG_HWIDGET)),
		usercoord);
	return((Widget)ret_wid);
}
