#include <stdio.h>
#include "sim_ext.h"
#include "tools.h"
#include "y.tab.h"
#include "result.h"
#include "symtab.h"


Result	*SymtabLook();
extern Symtab GlobalSymbols;


float get_script_float(name)
	char	*name;
{
	Result *rp;

	rp = SymtabLook(&GlobalSymbols,name);
	if (rp) { 
		if (rp->r_type == FLOAT) 
			return((float)(rp->r.r_float));
	}
	fprintf(stderr,"Could not find global float '%s'\n",name);
	return(0.0);
}


set_script_float(name,value) 
	char	*name;
	float	value;
{
	Result *rp;

	rp = SymtabLook(&GlobalSymbols,name);
	if (rp->r_type == FLOAT) {
		rp->r.r_float = value;
	} else {
		fprintf(stderr,"Could not find global '%s'\n",name);
	}
}


