
# line 2 "script.y"
#include <stdio.h>
#include <setjmp.h>
#include "parse.h"
#include "symtab.h"


/*
** Parser routines which return something other than int.
*/

extern ParseNode *vardef();
extern char *TokenStr();
extern char *MakeScriptInfo();	/* Actually a generic pointer */

/*
** Parser global variables
*/

extern jmp_buf	BreakBuf;	/* Used to break out of a loop */
extern jmp_buf	ReturnBuf;	/* Used to return out of a script */

static int	DefType;	/* Remembers type in a var decl */
static int	DefCast;	/* Remembers cast in a var decl */
static int	BreakAllowed = 0; /* In a loop control structure */
static int	ReturnIdents = 0; /* 1 ==> lexer doesn't classify IDENTs */
static int	Compiling = 0;	/* Make a statement list rather than execute */
static int	InFunctionDefinition = 0;
static int	NextLocal;	/* Next local symbol offset */
static int	ArgMatch;	/* Matches argument number to name in func */
Symtab		GlobalSymbols;	/* Symbols defined outside a function */
static Symtab	*LocalSymbols = NULL;	/* Symbols local to a function */
static ResultValue RV;			/* Dummy ReturnValue for PTNew */

# define LT 257
# define LE 258
# define GT 259
# define GE 260
# define EQ 261
# define NE 262
# define OR 263
# define AND 264
# define UMINUS 265
# define WHILE 266
# define IF 267
# define ELSE 268
# define FOR 269
# define FOREACH 270
# define END 271
# define INCLUDE 272
# define ENDSCRIPT 273
# define BREAK 274
# define INT 275
# define FLOAT 276
# define STR 277
# define RETURN 278
# define WHITESPACE 279
# define FUNCTION 280
# define INTCONST 281
# define DOLLARARG 282
# define FLOATCONST 283
# define STRCONST 284
# define LITERAL 285
# define IDENT 286
# define VARREF 287
# define FUNCREF 288
# define EXTERN 289
# define SL 290
# define COMMAND 291
# define ARGUMENT 292
# define ARGLIST 293
# define LOCREF 294
# define ICAST 295
# define FCAST 296
# define SCAST 297

# line 66 "script.y"
/*
** Start of lexical analyzer.  LEX source is in "script.l".
*/

extern YYSTYPE	yylval;

#include "lex.yy.c"
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 984 "script.y"


/*
** TokenStr
**
**	Return the token string for the given token.
*/

char *TokenStr(token)

int	token;

{	/* TokenStr --- Return token string for token */

	static char	buf[100];

	switch (token)
	  {

	  case LT: return("<");
	  case LE: return("<=");
	  case GT: return(">");
	  case GE: return(">=");
	  case EQ: return("==");
	  case NE: return("!=");

	  case OR: return("||");
	  case AND: return("&&");

#define	RET(tok)	case tok: return("tok")

	  RET(UMINUS);

	  RET(WHILE);
	  RET(IF);
	  RET(ELSE);
	  RET(FOR);
	  RET(FOREACH);
	  RET(END);
	  RET(INCLUDE);
	  RET(BREAK);
	  RET(INT);
	  RET(FLOAT);
	  RET(STR);
	  RET(RETURN);
	  RET(WHITESPACE);
	  RET(FUNCTION);
	  RET(INTCONST);
	  RET(DOLLARARG);
	  RET(FLOATCONST);
	  RET(STRCONST);
	  RET(LITERAL);
	  RET(IDENT);
	  RET(VARREF);
	  RET(FUNCREF);
	  RET(SL);
	  RET(COMMAND);
	  RET(ARGUMENT);
	  RET(ARGLIST);
	  RET(LOCREF);
	  RET(ICAST);
	  RET(FCAST);
	  RET(SCAST);

	  }

	if (token < 128)
	    if (token < ' ')
		sprintf(buf, "^%c", token+'@');
	    else
		sprintf(buf, "%c", token);
	else
	    sprintf(buf, "%d", token);

	return(buf);

}	/* TokenStr */



#ifdef COMMENT
Result *vardef(ident, type)

char	*ident;
int	type;

{	/* vardef --- Define a variable */

	Result	*rp, r;
	Symtab	*symtab;

	if (InFunctionDefinition && LocalSymbols != NULL)
	  {
	    rp = SymtabNew(LocalSymbols, ident);
	    if (rp->r_type == 0)
	      {
	        rp->r_type = LOCREF;
		rp->r.r_loc.l_type = type;
		rp->r.r_loc.l_offs = NextLocal++;
	      }
	  }
	else
	  {
	    rp = SymtabNew(&GlobalSymbols, ident);
	    switch(type)
	      {

	      case INT:
	        if (rp->r_type == 0)
	            rp->r.r_int = 0;
	        else
		    CastToInt(rp);
	        break;

	      case FLOAT:
	        if (rp->r_type == 0)
	            rp->r.r_float = 0.0;
	        else
		    CastToFloat(rp);
	        break;

	      case STR:
	        if (rp->r_type == 0)
	            rp->r.r_str = strsave("");
	        else
		    CastToStr(rp);
	        break;

	      }

	    rp->r_type = type;
	  }

	return(rp);

}	/* vardef */
#endif



ParseNode *vardef(ident, type, castop, init)

char		*ident;
int		type;
int		castop;
ParseNode	*init;

{	/* vardef --- Define a variable */

	ParseNode	*pn;
	Result		*rp, r;
	ResultValue	v, slv;

	if (InFunctionDefinition && LocalSymbols != NULL)
	  {
	    rp = SymtabNew(LocalSymbols, ident);
	    if (rp->r_type == 0)
	      {
	        rp->r_type = LOCREF;
		rp->r.r_loc.l_type = type;
		rp->r.r_loc.l_offs = NextLocal++;
	      }

	    v.r_str = (char *) rp;
	    pn = PTNew(castop, v, NULL, NULL);
	    if (init)
	      {
		slv.r_str = (char *) MakeScriptInfo();
		pn = PTNew(SL, slv, pn, PTNew('=', v, init, NULL));
	      }
	  }
	else
	  {
	    rp = SymtabNew(&GlobalSymbols, ident);
	    switch(type)
	      {

	      case INT:
	        if (rp->r_type == 0)
	            rp->r.r_int = 0;
	        else
		    CastToInt(rp);
	        break;

	      case FLOAT:
	        if (rp->r_type == 0)
	            rp->r.r_float = 0.0;
	        else
		    CastToFloat(rp);
	        break;

	      case STR:
	        if (rp->r_type == 0)
	            rp->r.r_str = (char *) strsave("");
	        else
		    CastToStr(rp);
	        break;

	      }

	    rp->r_type = type;
	    v.r_str = (char *) rp;
	    if (init)
	        pn = PTNew('=', v, init, NULL);
	    else
	        pn = NULL;
	  }

	return(pn);

}	/* vardef */


ParseInit()

{    /* ParseInit --- Initialize parser variables */

        InFunctionDefinition = 0;
	Compiling = 0;
	BreakAllowed = 0;
	LocalSymbols = NULL;
	nextchar(1);	/* Flush lexer input */
	PTInit();	/* Reinit parse tree evaluation */

}    /* ParseInit */


int NestedLevel()

{    /* NestedLevel --- Return TRUE if in func_def or control structure */

        return(InFunctionDefinition || Compiling);

}    /* NestedLevel */
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 1,
	-2, 3,
-1, 131,
	10, 58,
	59, 58,
	41, 58,
	-2, 53,
-1, 153,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 106,
-1, 154,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 107,
-1, 155,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 108,
-1, 156,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 109,
-1, 157,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 110,
-1, 158,
	257, 0,
	258, 0,
	259, 0,
	260, 0,
	261, 0,
	262, 0,
	-2, 111,
-1, 184,
	271, 32,
	-2, 3,
-1, 206,
	271, 33,
	-2, 3,
	};
# define YYNPROD 127
# define YYLAST 455
short yyact[]={

  20,  23, 128,  21,  22,  24,  34,  26,  32,  38,
  39,  40,  33,  74,  37,  75,  55,  63,  56, 128,
  35,  24,  36,  30,  72,  46, 191,  59, 139,  62,
  49, 100,  94,  86, 131, 117,  98,  96, 134,  97,
  81,  99, 218, 217, 205, 194, 190, 198,   2,  84,
  82, 122,  58, 182, 100,  94,  85, 207, 162,  98,
  96, 133,  97, 142,  99, 100,  94,   9, 132,  48,
  98,  96, 119,  97, 188,  99,  83,  42, 189, 100,
  94, 188,  91, 121,  98,  96, 214,  97,  95,  99,
 100,  94, 213, 212, 118,  98,  96, 203,  97, 100,
  99, 113,  87, 112,  98, 187,  90,  71, 188,  99,
  61,  95, 124,  77, 175, 100,  94, 176,  93,  78,
  98,  96,  95,  97, 116,  99,  43, 100,  94,  52,
  88,  51,  98,  96, 129,  97,  95,  99,  47, 136,
 130,  93,  45, 123,  44, 130, 210,  95, 160, 209,
 159,  92,  93, 161, 140,  31, 135, 137, 134,  54,
 199, 127, 170, 126, 125,  53,  93,  50,  73, 166,
 204, 165,  95, 167, 120, 211, 163,  93, 127, 168,
 126, 125, 172,  41,  95, 173, 174,   3,  25,  27,
  28,  15, 171, 177,  11,  57,  17,  13,  10,  29,
 138,  89,  93,  19,  18, 141,  16,  14,  12, 179,
 180, 197, 181,   8,  93, 184,   7, 183,   6,   5,
   4,   1,   0,   0,   0,   0,   0, 123,   0,   0,
 185,   0,   0,   0, 196,   0, 169,   0, 200,   0,
 168,   0, 201, 202,   0,   0, 169, 206, 192, 193,
 195, 103, 104, 105, 106, 107, 108, 101, 102,   0,
 215, 216, 208,   0,   0,  68,  70,  67,  69,   0,
  64,  66,  65,   0, 103, 104, 105, 106, 107, 108,
 101, 102,   0,  60, 169, 103, 104, 105, 106, 107,
 108, 101, 102,   0,   0,   0,   0,   0, 169, 103,
 104, 105, 106, 107, 108, 101, 102,   0,   0,   0,
 103, 104, 105, 106, 107, 108, 101, 102,   0, 100,
  94, 169,   0,   0,  98,  96,   0,  97,  76,  99,
   0,  79,  80,   0,   0, 103, 104, 105, 106, 107,
 108, 101, 102,   0,   0, 109, 110, 111,   0,   0,
   0,   0,   0, 101, 102, 114, 115,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  95, 143, 144, 145,
 146, 147, 148, 149, 150, 151, 152, 153, 154, 155,
 156, 157, 158,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 164,   0,   0,  93,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 178,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 186 };
short yypact[]={

-1000,-1000,-1000,-266,  67,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
 104, 102,-262,  98,   8,-255,-1000,  91,  89,-1000,
-270,-259,-1000, -16,-1000,-1000,-1000,-273,-1000,-1000,
-1000,-1000,-1000,-1000, -16,-282,  79, -16, -16,-239,
-1000,-246,-246,-1000,  66,-1000,-1000,  38,-1000,-1000,
  78, -16, -16, -16,  63,  61,-1000,-1000,-1000,-1000,
-1000, -16, -16,-244,-1000,-1000,  53,  13,-1000,  42,
  78,-104,-1000,-245,-104,-241,-1000,-104,-245,-1000,
-258,-1000,   2, -16, -16, -16, -16, -16, -16, -16,
 -16, -16, -16, -16, -16, -16, -16, -16, -16,-1000,
-1000,  90,-1000,-1000,  28,  17,-1000,-1000,-1000, -16,
-244,-1000,-245,-104,-1000,-1000,-1000,-1000,-1000,-1000,
-121,-1000,-246,-104,-1000,-246,-1000,-1000,  73,-1000,
-259,-1000, -16,  62,  62,  62,  62,  62,-1000,-1000,
-1000, 282, 282,  90,  90,  90,  90,  90,  90,-246,
-246,-1000,-1000,-1000,  -6,-104,-1000,-1000,-121,-1000,
 -16,-104,  64,  37,-225,-1000,-260,-1000,  78,-104,
-104,-226,-282,-245,-221,-104,  78,-1000,-246,-1000,
-1000,-1000,-246,-246,-1000,  56,-1000,-227,-1000, -68,
-104,  30,  30,-1000,  52,-1000,-1000,-1000,-104,  51,
  45,-1000,-1000,-1000,-1000,-228,-229,-1000,-1000 };
short yypgo[]={

   0, 221, 220,  48, 219, 218, 216, 213, 211,  67,
 208,  51,  68,  61, 112, 207, 206, 205, 204, 203,
 283, 201, 200, 199, 198, 197, 196,  52, 195,  76,
 194, 191, 190, 189, 188, 187, 183, 176, 175, 174,
  50, 170, 169, 168, 167,  49, 165,  56, 162, 160,
 159, 157, 155, 154, 151, 150, 149, 148, 146 };
short yyr1[]={

   0,   1,   3,  35,   3,  36,  36,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,  30,  37,   4,  38,   5,  39,  41,   6,
  42,   7,   8,   8,   9,  43,  34,  24,  24,  33,
  44,  10,  10,  32,  25,  46,  25,  29,  29,  11,
  11,  45,  45,  47,  47,  12,  12,  40,  40,  13,
  13,  14,  14,  14,  48,  49,  14,  31,  31,  23,
  23,  50,  51,  15,  21,  21,  22,  22,  52,  52,
  52,  16,  28,  53,  28,  54,  27,  17,  17,  26,
  18,  18,  19,  20,  20,  20,  20,  20,  20,  20,
  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,
  20,  20,  55,  56,  20,  57,  58,  20,  20,  20,
  20,  20,  20,  20,  20,  20,  20 };
short yyr2[]={

   0,   1,   0,   0,   4,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   0,   7,   0,  11,   0,   0,  11,
   0,   8,   0,   2,   3,   0,   3,   5,   3,   1,
   0,   4,   6,   1,   6,   0,   4,   0,   3,   1,
   3,   0,   1,   1,   2,   1,   5,   0,   1,   1,
   2,   1,   1,   1,   0,   0,   5,   2,   2,   2,
   2,   0,   0,   6,   0,   3,   1,   3,   1,   1,
   1,   2,   1,   0,   4,   0,   3,   0,   2,   1,
   2,   1,   0,   3,   3,   3,   2,   3,   3,   3,
   3,   3,   2,   3,   3,   2,   3,   3,   3,   3,
   3,   3,   0,   0,   8,   0,   0,   8,   1,   1,
   1,   1,   1,   1,   1,   3,   3 };
short yychk[]={

-1000,  -1,  -3, -35,  -2,  -4,  -5,  -6,  -7,  -9,
 -24, -30, -10, -25, -15, -31, -16, -26, -18, -19,
 266, 269, 270, 267, 287, -34, 273, -33, -32, -23,
 289, -52, 274, 278, 272, 286, 288, 280, 275, 276,
 277, -36,  10,  59,  40,  40, 287,  40,  61, 285,
 -44,  40,  40, -46, -50, 286, 288, -28, -27, 286,
 -20, 126,  45,  33, 286, 288, 287, 283, 281, 284,
 282, 123,  40, -43, 286, 288, -20,  -9,  40, -20,
 -20, 279, -40, -29, -45, -47, 279, -45, -29, -21,
  40,  44, -54, 124,  38,  94,  43,  45,  42,  47,
  37, 263, 264, 257, 258, 259, 260, 261, 262, -20,
 -20, -20,  40,  40, -20, -20, -40, 279,  41,  59,
 -39,  41, -11, -13, -14, 285, 284, 282, 123, -40,
 -47, 279, -12, -13, 279, -12, -40, -51, -22, 286,
 -53, -17,  61, -20, -20, -20, -20, -20, -20, -20,
 -20, -20, -20, -20, -20, -20, -20, -20, -20, -55,
 -57, 125,  41, -37, -20, -40, -42, -40, -47, -14,
 -48, -13, -45, -45,  -3,  41,  44, -27, -20, -45,
 -45,  -3,  59, -11,  -3, -13, -20,  41,  44,  41,
 271, 286, -12, -12, 271,  -9, -40,  -8, 268, -49,
 -45, -45, -45,  41, -41, 271,  -3, 125, -13, -56,
 -58, -38,  41,  41,  41,  -3,  -3, 271, 271 };
short yydef[]={

   2,  -2,  -2,  92,   0,   7,   8,   9,  10,  11,
  12,  13,  14,  15,  16,  17,  18,  19,  20,  21,
   0,   0,   0,   0,   0,   0,  22,  40,  45,  71,
   0,   0,  89,  91,  35,  39,  43,   0,  78,  79,
  80,   4,   5,   6,   0,   0,   0,   0,   0,  57,
  47,  51,  51,  47,  74,  67,  68,  81,  82,  85,
  90,   0,   0,   0, 120, 119, 118, 121, 122, 123,
 124,   0,   0,  57,  69,  70,   0,   0,  27,   0,
  34,  58,  38,  57,   0,  52,  53,   0,  57,  72,
   0,  83,  87,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  96,
 102, 105, 112, 115,   0,   0,  36,  58,  23,   0,
  57,  30,  57,  49,  59,  61,  62,  63,  64,  41,
   0,  -2,  51,  55,  54,  51,  46,   2,   0,  76,
   0,  86,   0,  93,  94,  95,  97,  98,  99, 100,
 101, 103, 104,  -2,  -2,  -2,  -2,  -2,  -2,  51,
  51, 125, 126,   2,   0,   0,   2,  37,   0,  60,
   0,  48,   0,   0,   3,  75,   0,  84,  88,   0,
   0,   3,   0,  57,  -2,  50,  65,  42,  51,  44,
  73,  77,  51,  51,  24,   0,  28,   0,   2,   0,
   0, 113, 116,  25,   0,  31,  -2,  66,  56,   0,
   0,   2,   2, 114, 117,   3,   3,  26,  29 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 2:
# line 81 "script.y"
{ 
		    yyval.pn = NULL;
 		  } break;
case 3:
# line 85 "script.y"
{
		    yyval.str = (char *) MakeScriptInfo();
		    SetLine(yyval.str);
		  } break;
case 4:
# line 90 "script.y"
{
		    ResultValue	v;

		    if (InFunctionDefinition || Compiling)
			if (yypvt[-1].pn != NULL)
			  {
			    v.r_str = yypvt[-2].str;
			    yyval.pn = PTNew(SL, v, yypvt[-3].pn, yypvt[-1].pn);
			  }
			else
			    yyval.pn = yypvt[-3].pn;
		    else
		      {
		        /* execute statement */
			if (setjmp(BreakBuf) == 0)
			    if (setjmp(ReturnBuf) == 0)
				PTEval(yypvt[-1].pn);
			    else
				EndScript();
			PTFree(yypvt[-1].pn);
		      }
		  } break;
case 22:
# line 136 "script.y"
{
		    /*
		    ** When the end of a script is encountered, the simulator
		    ** sgets routine returns NULL.  The nextchar routine in the
		    ** lexer returns a special character '\200' which is lexed
		    ** as ENDSCRIPT.  We need this when we include a script
		    ** in a function or control structure so that the script
		    ** local variable storage is allocated and deallocated.
		    */

		    if (Compiling || InFunctionDefinition)
		      {
			yyval.pn = PTNew(ENDSCRIPT, RV, NULL, NULL);
		      }
		    else
			yyval.pn = NULL;
		  } break;
case 23:
# line 156 "script.y"
{
		    Compiling++;
		    BreakAllowed++;
		    yyval.str = (char *) MakeScriptInfo();
		  } break;
case 24:
# line 162 "script.y"
{
		    ResultValue	v;

		    v.r_str = yypvt[-2].str;
		    yyval.pn = PTNew(WHILE, v, yypvt[-4].pn, yypvt[-1].pn);
		    Compiling--;
		    BreakAllowed--;
		  } break;
case 25:
# line 173 "script.y"
{
		      Compiling++;
		      BreakAllowed++;
		      yyval.str = (char *) MakeScriptInfo();
		    } break;
case 26:
# line 180 "script.y"
{
		    ResultValue	v;
		    ParseNode	*forbody, *whilepart;

		    v.r_str = (char *) MakeScriptInfo();
		    forbody = PTNew(SL, v, yypvt[-1].pn, yypvt[-4].pn);
		    v.r_str = yypvt[-2].str;
		    whilepart = PTNew(WHILE, v, yypvt[-6].pn, forbody);
		    yyval.pn = PTNew(SL, v, yypvt[-8].pn, whilepart);
		    Compiling--;
		    BreakAllowed--;
		  } break;
case 27:
# line 195 "script.y"
{
			BEGIN FUNCLIT;
			Compiling++;
			BreakAllowed++;
		    } break;
case 28:
# line 201 "script.y"
{
			BEGIN 0;
		    } break;
case 29:
# line 205 "script.y"
{
		    Result	*rp;
		    ResultValue	v;
		    char        buf[100];

		    rp = (Result *) yypvt[-9].str;
		      {
			if ((rp->r_type != STR && rp->r_type != LOCREF) ||
			    (rp->r_type == LOCREF && rp->r.r_loc.l_type != STR))
			  {
			   yyerror("Variable in FOREACH not a string variable");
			    /* No Return */
			  }
		      }

		    v.r_str = (char *) rp;
		    yyval.pn = PTNew(FOREACH, v, yypvt[-5].pn, yypvt[-1].pn);
		    Compiling--;
		    BreakAllowed--;
		  } break;
case 30:
# line 228 "script.y"
{
		    Compiling++;
		    yyval.str = (char *) MakeScriptInfo();
		  } break;
case 31:
# line 233 "script.y"
{
		    ResultValue	v;
		    ParseNode	*stmntlists;

		    stmntlists = PTNew(0, v, yypvt[-2].pn, yypvt[-1].pn);
		    v.r_str = yypvt[-3].str;
		    yyval.pn = PTNew(IF, v, yypvt[-5].pn, stmntlists);
		    Compiling--;
		  } break;
case 32:
# line 245 "script.y"
{
 		    yyval.pn = NULL;
 		  } break;
case 33:
# line 249 "script.y"
{ yyval.pn = yypvt[-0].pn; } break;
case 34:
# line 253 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    char        buf[100];

		    yyval.pn = NULL;
		    rp = (Result *) yypvt[-2].str;
			  {
			    v.r_str = (char *) rp;
		            yyval.pn = PTNew('=', v, yypvt[-0].pn, NULL);
			  }
		  } break;
case 35:
# line 268 "script.y"
{
		    Pushyybgin(LIT);
		  } break;
case 36:
# line 272 "script.y"
{
		    yyval.str = NULL;
		  } break;
case 37:
# line 278 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    int		argc;
		    char	*argv[100];
		    char	argbuf[1000];
		    jmp_buf	save;
		    Result	r;

		    Popyybgin();
		    sprintf(argbuf, "%s", yypvt[-3].str);
		    argc = 1;
		    argv[0] = argbuf;
		    do_cmd_args(yypvt[-1].pn, &argc, argv, argbuf+strlen(argbuf)+1, NULL, NULL);
		    argv[argc] = NULL;

		    if (!IncludeScript(argc, argv))
		      {
			sprintf(argbuf, "Script '%s' not found", yypvt[-3].str);
			PTFree(yypvt[-1].pn);
			free(yypvt[-3].str);
			yyerror(argbuf);
		      }

		    if (Compiling || InFunctionDefinition)
		      {
			v.r_str = yypvt[-3].str;
			yyval.pn = PTNew(INCLUDE, v, yypvt[-1].pn, NULL);
		      }
		    else
		      {
			PTFree(yypvt[-1].pn);
			free(yypvt[-3].str);
			yyval.pn = NULL;
		      }
		  } break;
case 38:
# line 315 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    int		argc;
		    char	*argv[100];
		    char	argbuf[1000];
		    jmp_buf	save;
		    Result	r;

		    Popyybgin();
		    sprintf(argbuf, "%s", yypvt[-1].str);
		    argc = 1;
		    argv[0] = argbuf;
		    argv[argc] = NULL;

		    if (!IncludeScript(argc, argv))
		      {
			sprintf(argbuf, "Script '%s' not found", yypvt[-1].str);
			free(yypvt[-1].str);
			yyerror(argbuf);
		      }

		    if (Compiling || InFunctionDefinition)
		      {
			v.r_str = yypvt[-1].str;
			yyval.pn = PTNew(INCLUDE, v, NULL, NULL);
		      }
		    else
		      {
			free(yypvt[-1].str);
			yyval.pn = NULL;
		      }
		  } break;
case 39:
# line 351 "script.y"
{
		    Pushyybgin(FUNCLIT);
		    yyval.str = yypvt[-0].str;
		  } break;
case 40:
# line 358 "script.y"
{
		    BEGIN LIT;
		  } break;
case 41:
# line 362 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    int		argc;
		    char	*argv[100];
		    char	argbuf[1000];
		    jmp_buf	save;
		    Result	r;

		    Popyybgin();
		    if (!IsCommand(yypvt[-3].str))
		      {
			if (!IsInclude(yypvt[-3].str))
			  {
			    v.r_str = yypvt[-3].str;
			    yyval.pn = PTNew(COMMAND, v, yypvt[-1].pn, NULL);
			  }
			else
			  {
			    sprintf(argbuf, "%s", yypvt[-3].str);
			    argc = 1;
			    argv[0] = argbuf;
			    do_cmd_args(yypvt[-1].pn, &argc, argv, argbuf+strlen(argbuf)+1, NULL, NULL);
			    argv[argc] = NULL;
			    IncludeScript(argc, argv);

			    if (Compiling || InFunctionDefinition)
			      {
				v.r_str = yypvt[-3].str;
				yyval.pn = PTNew(INCLUDE, v, yypvt[-1].pn, NULL);
			      }
			    else
			      {
				PTFree(yypvt[-1].pn);
				free(yypvt[-3].str);
				yyval.pn = NULL;
			      }
			  }
		      }
		    else
		      {
			v.r_str = yypvt[-3].str;
			yyval.pn = PTNew(COMMAND, v, yypvt[-1].pn, NULL);
		      }
		  } break;
case 42:
# line 408 "script.y"
{
		    ResultValue	v;
		    Result	*rp;
		    int		argc;
		    char	*argv[100];
		    char	argbuf[1000];
		    jmp_buf	save;
		    Result	r;

		    Popyybgin();
		    if (!IsCommand(yypvt[-5].str))
		      {
			if (!IsInclude(yypvt[-5].str))
			  {
			    v.r_str = yypvt[-5].str;
			    yyval.pn = PTNew(COMMAND, v, yypvt[-2].pn, NULL);
			  }
			else
			  {
			    sprintf(argbuf, "%s", yypvt[-5].str);
			    argc = 1;
			    argv[0] = argbuf;
			    do_cmd_args(yypvt[-2].pn, &argc, argv, argbuf+strlen(argbuf)+1, NULL, NULL);
			    argv[argc] = NULL;
			    IncludeScript(argc, argv);

			    if (Compiling || InFunctionDefinition)
			      {
				v.r_str = yypvt[-5].str;
				yyval.pn = PTNew(INCLUDE, v, yypvt[-2].pn, NULL);
			      }
			    else
			      {
				PTFree(yypvt[-2].pn);
				free(yypvt[-5].str);
				yyval.pn = NULL;
			      }
			  }
		      }
		    else
		      {
			v.r_str = yypvt[-5].str;
			yyval.pn = PTNew(COMMAND, v, yypvt[-2].pn, NULL);
		      }
		  } break;
case 43:
# line 456 "script.y"
{
		    Pushyybgin(FUNCLIT);
		    yyval.str = yypvt[-0].str;
		  } break;
case 44:
# line 463 "script.y"
{
		    ResultValue	v;
		    Result	*rp;

		    Popyybgin();
		    rp = (Result *) yypvt[-5].str;
		    yyval.pn = PTNew(FUNCTION, rp->r, yypvt[-2].pn, NULL);
		  } break;
case 45:
# line 472 "script.y"
{
		    BEGIN LIT;
		  } break;
case 46:
# line 476 "script.y"
{
		    ResultValue	v;
		    Result	*rp;

		    Popyybgin();
		    rp = (Result *) yypvt[-3].str;
		    yyval.pn = PTNew(FUNCTION, rp->r, yypvt[-1].pn, NULL);
		  } break;
case 47:
# line 487 "script.y"
{
		    yyval.pn = NULL;
		  } break;
case 48:
# line 491 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, yypvt[-2].pn, yypvt[-0].pn);
		  } break;
case 49:
# line 497 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, NULL, yypvt[-0].pn);
		  } break;
case 50:
# line 501 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, yypvt[-2].pn, yypvt[-0].pn);
		  } break;
case 55:
# line 515 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, NULL, yypvt[-0].pn);
		  } break;
case 56:
# line 519 "script.y"
{
		    yyval.pn = PTNew(ARGLIST, RV, yypvt[-4].pn, yypvt[-0].pn);
		  } break;
case 59:
# line 529 "script.y"
{
			    ResultValue	v;

			    yyval.pn = PTNew(ARGUMENT, v, NULL, yypvt[-0].pn);
			  } break;
case 60:
# line 535 "script.y"
{
			    ResultValue	v;

			    yyval.pn = PTNew(ARGUMENT, v, yypvt[-1].pn, yypvt[-0].pn);
			  } break;
case 61:
# line 543 "script.y"
{
		    ResultValue	v;

		    v.r_str = yypvt[-0].str;
		    yyval.pn = PTNew(LITERAL, v, NULL, NULL);
		  } break;
case 62:
# line 550 "script.y"
{
		    ResultValue	v;

		    v.r_str = yypvt[-0].str;
		    yyval.pn = PTNew(LITERAL, v, NULL, NULL);
		  } break;
case 63:
# line 557 "script.y"
{
		    ResultValue	v;

		    v.r_int = yypvt[-0].iconst;
		    yyval.pn = PTNew(DOLLARARG, v, NULL, NULL);
		  } break;
case 64:
# line 564 "script.y"
{
		    Pushyybgin(0);
		  } break;
case 65:
# line 568 "script.y"
{
		    Popyybgin();
		  } break;
case 66:
# line 572 "script.y"
{
		    if (yypvt[-2].pn->pn_val.r_type == STRCONST)
			yypvt[-2].pn->pn_val.r_type = LITERAL;

		    yyval.pn = yypvt[-2].pn;
		  } break;
case 67:
# line 581 "script.y"
{
		    ParseNode	*funcpn;
		    ResultValue	v;
		    Result	*rp;

		    rp = SymtabNew(&GlobalSymbols, yypvt[-0].str);
		    if (rp->r_type != 0 && rp->r_type != FUNCTION)
			fprintf(stderr, "WARNING: function name '%s' is redefining a variable!\n", yypvt[-0].str);

		    rp->r_type = FUNCTION;

		    v.r_str = (char *) NULL;
		    funcpn = PTNew(SL, v, NULL, NULL);
		    rp->r.r_str = (char *) funcpn;

		    yyval.pn = NULL;
		  } break;
case 68:
# line 599 "script.y"
{
		    yyval.pn = NULL;
		  } break;
case 69:
# line 605 "script.y"
{
		    ParseNode	*funcpn;
		    ResultValue	v;
		    Result	*rp;
		    char	*script;

		    if (InFunctionDefinition)
		      {
			fprintf(stderr, "Function definition within another function or\n");
			fprintf(stderr, "within a control structure (FUNCTION %s).\n", yypvt[-0].str);
			yyerror("");
			/* No Return */
		      }

		    InFunctionDefinition++;
		    NextLocal = 0;
		    rp = SymtabNew(&GlobalSymbols, yypvt[-0].str);
		    if (rp->r_type != 0 && rp->r_type != FUNCTION)
			fprintf(stderr, "WARNING: function name '%s' is redefining a variable!\n", yypvt[-0].str);

		    rp->r_type = FUNCTION;

		    LocalSymbols = SymtabCreate();
		    v.r_str = (char *) LocalSymbols;
		    funcpn = PTNew(SL, v, NULL, NULL);
		    rp->r.r_str = (char *) funcpn;

#ifdef COMMENT
		    rp = SymtabNew(LocalSymbols, "*SCRIPT*");
		    script = (char *) CurrentScriptName();
		    if (script == NULL)
			rp->r.r_str = (char *) strsave("<stdin>");
		    else
			rp->r.r_str = (char *) strsave(script);
		    rp = SymtabNew(LocalSymbols, "*FUNCTION*");
		    rp->r.r_str = (char *) strsave(yypvt[-0].str);
#endif
		    yyval.pn = funcpn;
		  } break;
case 70:
# line 645 "script.y"
{
		    ParseNode	*funcpn;
		    ResultValue	v;
		    Result	*rp;
		    char	*script;

		    rp = (Result *) yypvt[-0].str;
		    if (InFunctionDefinition)
		      {
			fprintf(stderr, "Function definition within another function or\n");
			fprintf(stderr, "within a control structure (FUNCTION %s).\n", yypvt[-0].str);
			yyerror("");
			/* No Return */
		      }

		    /*
		    ** Free old function parse tree and symtab
		    */

		    funcpn = (ParseNode *) rp->r.r_str;
		    if (funcpn->pn_val.r.r_str != NULL)
			SymtabDestroy(funcpn->pn_val.r.r_str);
		    PTFree(funcpn->pn_left);
		    PTFree(funcpn->pn_right);

		    InFunctionDefinition++;
		    NextLocal = 0;
		    LocalSymbols = SymtabCreate();
		    funcpn->pn_val.r.r_str = (char *) LocalSymbols;

#ifdef COMMENT
		    rp = SymtabNew(LocalSymbols, "*SCRIPT*");
		    script = (char *) CurrentScriptName();
		    if (script == NULL)
			rp->r.r_str = (char *) strsave("<stdin>");
		    else
			rp->r.r_str = (char *) strsave(script);
		    rp = SymtabNew(LocalSymbols, "*FUNCTION*");
		    rp->r.r_str =(char *)strsave(SymtabKey(&GlobalSymbols, yypvt[-0].str));
#endif

		    yyval.pn = funcpn;
		  } break;
case 71:
# line 691 "script.y"
{
		    ReturnIdents = 1;
		  } break;
case 72:
# line 695 "script.y"
{
		    ReturnIdents = 0;
		  } break;
case 73:
# line 699 "script.y"
{
		    InFunctionDefinition--;

		    yypvt[-5].pn->pn_left = yypvt[-3].pn;
		    yypvt[-5].pn->pn_right = yypvt[-1].pn;

		    LocalSymbols = NULL;
		    yyval.pn = NULL;
		  } break;
case 74:
# line 711 "script.y"
{ yyval.pn = NULL; } break;
case 75:
# line 713 "script.y"
{ yyval.pn = yypvt[-1].pn; } break;
case 76:
# line 717 "script.y"
{
		    ResultValue	v;
		    ParseNode	*init;

		    ArgMatch = 1;
		    v.r_int = ArgMatch++;
		    init = PTNew(DOLLARARG, v, NULL, NULL);
		    yyval.pn = vardef(yypvt[-0].str, STR, SCAST, init);
		  } break;
case 77:
# line 727 "script.y"
{
		    ResultValue	v;
		    ParseNode	*init;

		    v.r_int = ArgMatch++;
		    init = PTNew(DOLLARARG, v, NULL, NULL);
		    v.r_str = (char *) MakeScriptInfo();
		    yyval.pn = PTNew(SL, v, yypvt[-2].pn, vardef(yypvt[-0].str, STR, SCAST, init));
		  } break;
case 78:
# line 739 "script.y"
{
		    ReturnIdents = 1;
		    DefType = INT;
		    DefCast = ICAST;
		  } break;
case 79:
# line 745 "script.y"
{
		    ReturnIdents = 1;
		    DefType = FLOAT;
		    DefCast = FCAST;
		  } break;
case 80:
# line 751 "script.y"
{
		    ReturnIdents = 1;
		    DefType = STR;
		    DefCast = SCAST;
		  } break;
case 81:
# line 759 "script.y"
{
		    yyval.pn = yypvt[-0].pn;
		  } break;
case 83:
# line 766 "script.y"
{
		    ReturnIdents = 1;
		  } break;
case 84:
# line 770 "script.y"
{
		    ResultValue	v;

		    v.r_str = (char *) MakeScriptInfo();
		    yyval.pn = PTNew(SL, v, yypvt[-3].pn, yypvt[-0].pn);
		  } break;
case 85:
# line 779 "script.y"
{
		    ReturnIdents = 0;
		  } break;
case 86:
# line 783 "script.y"
{
		    yyval.pn = vardef(yypvt[-2].str, DefType, DefCast, yypvt[-0].pn);
		  } break;
case 87:
# line 789 "script.y"
{ yyval.pn = NULL; } break;
case 88:
# line 791 "script.y"
{ yyval.pn = yypvt[-0].pn; } break;
case 89:
# line 795 "script.y"
{
		    ResultValue	v;

		    if (BreakAllowed)
			yyval.pn = PTNew(BREAK, v, NULL, NULL);
		    else
			yyerror("BREAK found outside of a loop");
			/* No Return */
		  } break;
case 90:
# line 807 "script.y"
{
		    ResultValue	v;

		    yyval.pn = PTNew(RETURN, v, yypvt[-0].pn, NULL);
		  } break;
case 91:
# line 813 "script.y"
{
		    ResultValue	v;

		    yyval.pn = PTNew(RETURN, v, NULL, NULL);
		  } break;
case 92:
# line 821 "script.y"
{ yyval.pn = NULL; } break;
case 93:
# line 825 "script.y"
{ yyval.pn = PTNew('|', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 94:
# line 827 "script.y"
{ yyval.pn = PTNew('&', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 95:
# line 829 "script.y"
{ yyval.pn = PTNew('^', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 96:
# line 831 "script.y"
{ yyval.pn = PTNew('~', RV, yypvt[-0].pn, NULL); } break;
case 97:
# line 834 "script.y"
{ yyval.pn = PTNew('+', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 98:
# line 836 "script.y"
{ yyval.pn = PTNew('-', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 99:
# line 838 "script.y"
{ yyval.pn = PTNew('*', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 100:
# line 840 "script.y"
{ yyval.pn = PTNew('/', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 101:
# line 842 "script.y"
{ yyval.pn = PTNew('%', RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 102:
# line 844 "script.y"
{ yyval.pn = PTNew(UMINUS, RV, yypvt[-0].pn, NULL); } break;
case 103:
# line 847 "script.y"
{ yyval.pn = PTNew(OR, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 104:
# line 849 "script.y"
{ yyval.pn = PTNew(AND, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 105:
# line 851 "script.y"
{ yyval.pn = PTNew('!', RV, yypvt[-0].pn, NULL); } break;
case 106:
# line 854 "script.y"
{ yyval.pn = PTNew(LT, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 107:
# line 856 "script.y"
{ yyval.pn = PTNew(LE, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 108:
# line 858 "script.y"
{ yyval.pn = PTNew(GT, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 109:
# line 860 "script.y"
{ yyval.pn = PTNew(GE, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 110:
# line 862 "script.y"
{ yyval.pn = PTNew(EQ, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 111:
# line 864 "script.y"
{ yyval.pn = PTNew(NE, RV, yypvt[-2].pn, yypvt[-0].pn); } break;
case 112:
# line 867 "script.y"
{
			BEGIN FUNCLIT;
		    } break;
case 113:
# line 871 "script.y"
{
			BEGIN 0;
		    } break;
case 114:
# line 875 "script.y"
{
		    ResultValue	v;
		    Result	*rp;

		    v.r_str = yypvt[-7].str;
		    yyval.pn = PTNew(COMMAND, v, yypvt[-3].pn, NULL);
		  } break;
case 115:
# line 884 "script.y"
{
			BEGIN FUNCLIT;
		    } break;
case 116:
# line 888 "script.y"
{
			BEGIN 0;
		    } break;
case 117:
# line 892 "script.y"
{
		    ResultValue	v;
		    Result	*rp;

		    rp = (Result *) yypvt[-7].str;
		    if (rp != NULL && rp->r_type == FUNCTION)
		        yyval.pn = PTNew(FUNCTION, rp->r, yypvt[-3].pn, NULL);
		  } break;
case 118:
# line 902 "script.y"
{ 
		    Result	*rp;
		    ResultValue	v;

		    /*
		    ** Variable reference
		    */

		    rp = (Result *) yypvt[-0].str;
		      {
			if (rp->r_type == FUNCTION || rp->r_type == LOCREF)
			    v = rp->r;
			else /* Global Variable */
			    v.r_str = (char *) rp;

		        yyval.pn = PTNew(rp->r_type, v, NULL, NULL);
		      }
 		  } break;
case 119:
# line 922 "script.y"
{ 
		    Result	*rp;
		    ResultValue	v;

		    /*
		    ** Function call
		    */

		    rp = (Result *) yypvt[-0].str;
		    yyval.pn = PTNew(FUNCTION, rp->r, NULL, NULL);
 		  } break;
case 120:
# line 935 "script.y"
{ 
		    Result	*rp;
		    ResultValue	v;

		    /*
		    ** Command
		    */

		    v.r_str = yypvt[-0].str;
		    yyval.pn = PTNew(COMMAND, v, NULL, NULL);
 		  } break;
case 121:
# line 948 "script.y"
{ 
		    ResultValue	v;

		    v.r_float = yypvt[-0].fconst;
		    yyval.pn = PTNew(FLOATCONST, v, NULL, NULL);
 		  } break;
case 122:
# line 955 "script.y"
{ 
		    ResultValue	v;

		    v.r_int = yypvt[-0].iconst;
		    yyval.pn = PTNew(INTCONST, v, NULL, NULL);
 		  } break;
case 123:
# line 962 "script.y"
{ 
		    ResultValue	v;

		    v.r_str = yypvt[-0].str;
		    yyval.pn = PTNew(STRCONST, v, NULL, NULL);
 		  } break;
case 124:
# line 970 "script.y"
{
		    ResultValue	v;

		    v.r_int = yypvt[-0].iconst;
		    yyval.pn = PTNew(DOLLARARG, v, NULL, NULL);
		  } break;
case 125:
# line 978 "script.y"
{ yyval.pn = yypvt[-1].pn; } break;
case 126:
# line 982 "script.y"
{ yyval.pn = yypvt[-1].pn; } break; 
		}
		goto yystack;  /* stack new state and value */

	}
