#define FLOATTIME

/*
** bit usage of the element flag (16 bits)
** 0-4		5 bits		clock
** 5-6		2 bits 		enable
** 7		1 bit 		internal marker
** 8-12		4 bits 		reserved for future expansion
** 12-15	4 bits 		user
*/
#define CLOCKMASK		0x1F
#define BLOCKMASK		0x20
#define VISIBILITYMASK		0x40
#define MARKERMASK		0x80
#define USERMASK		0xF0
#define USERBITSHIFT		12

/*
** usable flags = 0-3
*/
#define SetElementFlag(E,N) (E)->flags |= (1<<(N + USERBITSHIFT))
#define ClearElementFlag(E,N) (E)->flags &= ~(1<<(N + USERBITSHIFT))
#define CheckElementFlag(E,N) (((E)->flags & (1<<(N + USERBITSHIFT))) != 0)

/*
** pre-defined classes
*/
#define	INVALID_CLASS		0
#define	ELEMENT_ELEMENT		1
#define	SEGMENT_ELEMENT		2
#define	BUFFER_ELEMENT		3
#define	PROJECTION_ELEMENT	4
#define	CONNECTION_ELEMENT	5

#define NCLOCKS 		100
#define SIM_CLOCK 		0

/*
** pre-defined action types
*/
#define PROCESS			0
#define INIT			1
#define RESET			2
#define CHECK			3
#define COPY			4
#define SET			5
#define CREATE			6
#define RECALC			7
#define SHOW			8
#define DELETE			9
#define SAVE			10
#define RESTORE			11
#define SAVE2			12
#define RESTORE2		13
#define SETUP			14
#define RESULTS			15

#ifndef PI
#define	PI			3.1415926536
#endif

#ifndef TRUE
#define	TRUE			1
#define	FALSE			0
#endif

#define BUFFER_INCREASE_HINT	10
#define WRAP 			0
#define EXPAND 			1

#define CurrentEventTime(B) 	((B)->event[(B)->current].time)	
#define CurrentEvent(B)		((B)->event[(B)->current])	
#define ValidEvent(B)		((B)->start != (B)->current)
#define BufferFull(B) 		((((B)->end +1) % (B)->size) == (B)->start)

#define Euler(y,dy,dt) 		((y) + (dy)*(dt))
#define CheckInterval(T,DT)	(GetCurrentStep() % (int)(0.5 + (T)/(DT)) == 0)
#define MATCH(A,B) 		(strncmp(A,B,strlen(A)) == 0)

/*
** quick but dangerous
#define MsgValue(M,T,N) 	(*((T *)((M)->data[N])))
*/

/* slow but safe */
#define MsgValue(M,T,N) 	(MessageData(M->slot + N))

#define ClockValue(C)		(clock_value[C])
/*
** get clock information from the element
*/
#define Clockrate(I)		(ClockValue(((I)->flags) & CLOCKMASK))
#define Clock(I)		(((I)->flags) & CLOCKMASK)

#define CORRECTION 		(ClockValue(0)/10.0)

#define SimulationTime()	simulation_time

#define Type(I) 		((I)->object->type)
#define Size(I) 		((I)->object->size)
#define Function(I) 		((I)->object->function)

#define MSGLOOP(C,M) 		for(M=(C)->msg_in;M;M=M->next) switch(M->type)
#define MSGVALUE(M,N) 		(MessageData(M->slot + N))
#define MSGPTR(M,N) 		(M->slot[N].data)

#define SELECT_ACTION(A)	switch((A)->type)

#define ENABLED(E)	(!((E)->flags & BLOCKMASK))
#define ACTIVE(E)	((E)->object->function)
