#include <stdio.h>
#include <varargs.h>

typedef struct {
	int	arg[50];
} VARG;

char	*ctime();

static 	FILE	*logfp = NULL;
static 	long	log_clock = 0;
static	int	monitor_time = 0;
static	int	monitor_interval = 1;

int do_logon(argc,argv) 
int	argc;
char	**argv;
{ 
    if(argc < 2){
	printf("usage: %s logfile\n",argv[0]);
	return(0);
    }
    if(strcmp(argv[1],"-off") == 0){
	do_logoff();
    } else {
	OpenLog(argv[1]);
	LogHeader(argv[1]);
    }
    return(1);
}

do_logoff() 
{ 
    if(logfp){
	LogTrailer();
	CloseLog();
    }
}

OpenLog(file)
char	*file;
{
    if((logfp = fopen(file,"a")) == NULL){
	Error();
	printf("unable to write to logfile '%s'\n",file);
    }
}

CloseLog()
{
    fclose(logfp);
    logfp = NULL;
}

char *Time()
{
long	clock;
char	*timestr;
    time(&clock);
    timestr = ctime(&clock);
    return(timestr);
}

LogHeader(file)
char	*file;
{
char *timestr;

    if(logfp){
	timestr = Time();
	printf("\nlogging to '%s' at %s\n",file,timestr);
	fprintf(logfp,"\nlogging started at %s\n",timestr);
    }
}

LogTrailer()
{
char *timestr;

    if(logfp){
	timestr = Time();
	printf("\nlogging done at %s\n",timestr);
	fprintf(logfp,"\nlogging done at %s\n",timestr);
    }
}

lprintf(com,va_alist)
char *com;
va_dcl
{
va_list ap;

#ifdef LATER
char	*arg[100];
char	*com;
char	*ptr;
int	nargs;

    va_start(ap);
    /*
    ** determine the number of arguments based on the format string
    */
    nargs = 0;
    for(ptr=com;ptr;ptr++){
	if(*ptr == '%') nargs++;
    }
    for(i=0;i<nargs;i++){
	arg[i] = va_arg(ap, char *);
    }
    va_end(ap);
#endif
    /*
    ** write to stdout
    */
    printf(com,va_alist);
    /*
    ** is logging selected
    */
    if(logfp){
	LogTime();
	/*
	** write to the log
	*/
	fprintf(logfp,com,va_alist);
    }
}

lprint_only(com,va_alist)
char *com;
va_dcl
{
    if(logfp){
	LogTime();
	/*
	** write to the log
	*/
	fprintf(logfp,com,va_alist);
    }
}

LogTime()
{
long	clock;

    /*
    ** check the monitor time
    */
    if(logfp && monitor_time > 0){
	time(&clock);
	if(clock - log_clock >= monitor_interval){
	    log_clock = clock;
	    /*
	    ** print the time
	    */
	    fprintf(logfp,"===> %s\n",ctime(&log_clock));
	}
    }
}
