#include "shell_ext.h"

static char	*history[1000];
static int	history_cnt = 0;
static int history_enabled = 1;

char *History(number)
int number;
{
    return(history[number]);
}

HistoryCnt()
{
    return(history_cnt);
}

int IsHistoryEnabled() 
{ 
    return(history_enabled); 
}

EnableHistory(state)
int state;
{
    history_enabled = state;
}

AddHistory(string)
char *string;
{
char *CopyString();
char *ptr;
char *strchr();

    if(string != NULL && history_enabled){
	/*
	** copy the string in and increment the history counter
	*/
	history[history_cnt] = CopyString(string);
	if(ptr = strchr(history[history_cnt],'\n')){
	    /*
	    ** remove CRs from the string
	    */
	    *ptr = '\0';
	}
	history_cnt++;
    }
}

char *GetHistory(string)
char *string;
{
int	index;
char	*new_string;
char	cmp_string[100];
char	*nptr;
char	*sptr;

    if(string != NULL && strlen(string) > 1){
	/*
	** get the last command
	*/
	if(string[1] == '!'){
	    return(history[history_cnt-1]);
	} else
	if(string[1] >= '0' && string[1] <= '9'){
	    /*
	    ** retrieve by number
	    */
	    sscanf(string+1,"%d",&index);
	    if(index >= 0 && index < history_cnt){
		return(history[index]);
	    }
	} else {
	    /*
	    ** retrieve by match
	    */
	    /*
	    ** get the match string
	    */
	    sptr = string+1;
	    nptr = cmp_string;
	    while(!IsWhiteSpace(*sptr) && *sptr != '\0'){
		*nptr++ = *sptr++;
	    }
	    *nptr = '\0';
	    for(index=history_cnt-1;index>=0;index--){
		if(strncmp(cmp_string,history[index],strlen(cmp_string)) == 0){
		    return(history[index]);
		}
	    }
	}
    } 
    return("\n");
}

void ShowHistory(argc,argv)
int	argc;
char	**argv;
{
int	i;
int	start,end;

    start = 0;
    end = history_cnt - 1;
    if(argc > 1){
	start = atoi(argv[1]);
	if(start < 0 || start > history_cnt -1){
	    start = 0;
	}
    }
    if(argc > 2){
	end = atoi(argv[2]);
	if(end < 0 || end > history_cnt -1){
	    end = history_cnt - 1;
	}
    }
    for(i=start;i<=end;i++){
	printf("%6d    %s\n",i,history[i]);
    }
}

