#include "seg_ext.h"

int	DEBUG_SymCompartment = 0;

#define	Field(F) (compartment->F)

/* 7/88 Matt Wilson */
SymCompartment(compartment,action)
register struct symcompartment_type *compartment;
Action		*action;
{
double		A;
double		B;
double		dt;
double		Vm1,Ra1;
double 		Ra_sum,Ra_sum2;
MsgIn		*msg;

    if(Debug(DEBUG_SymCompartment) > 1){
	ActionHeader("SymCompartment",compartment,action);
    }
    SELECT_ACTION(action){
    case INIT:
	compartment->previous_state = compartment->Vm;
	break;
    case PROCESS:
	dt = Clockrate(compartment);
	/*
	** calculate the integration parameters
	*/
	A = Field(Em)/Field(Rm) + Field(inject);
	B = 1.0/Field(Rm);
	compartment->Im = 0;
	/*
	** Read the msgs. These are factors used in the integration
	** across the membrane capacitance
	**
	** A = SUM(Ek*Gk) + I
	** B = SUM(Gk)
	*/
	MSGLOOP(compartment,msg){
	    case 0:			/* channel */
		/*
		** 0 = Gk 	1 = Ek
		*/
		A += MSGVALUE(msg,1)*MSGVALUE(msg,0);
		B += MSGVALUE(msg,0);
		break;
	    case 1:			/* resistive axial head */
		/*
		** 0 = Ra(n-1) 	1 = Vm(n-1)
		*/
		Vm1 = MSGVALUE(msg,1);
		Ra1 = MSGVALUE(msg,0)*compartment->coeff;
		A += Vm1/Ra1;
		B += 1.0/Ra1;
		/* inward positive current convention */
		compartment->Im += (Vm1 - compartment->Vm)/Ra1;
		break;
	    case 2:			/* resistive axial tail */
		/*
		** 0 = Ra(n-1) 	1 = Vm(n-1)
		*/
		Vm1 = MSGVALUE(msg,1);
		Ra1 = MSGVALUE(msg,0)*compartment->coeff2;
		A += Vm1/Ra1;
		B += 1.0/Ra1;
		/* inward positive current convention */
		compartment->Im += (Vm1 - compartment->Vm)/Ra1;
		break;
	    case 3:			/* current injection */
		/*
		** 0 = inject
		*/
		compartment->Im += MSGVALUE(msg,0);
		A += MSGVALUE(msg,0);
		break;
	}
	/*
	** Integrate the component membrane currents
	** to get the net membrane potential
	*/
	compartment->Vm =
	IntegrateMethod(Field(method),compartment,
	compartment->Vm,A/Field(Cm),B/Field(Cm),dt,"Vm");
	break;
    case RESET:
	compartment->Vm = compartment->Em;
	Ra_sum = Ra_sum2 = 0;
	MSGLOOP(compartment,msg){
	case 1:			/* incoming head axial resistance */
	    Ra1 = MSGVALUE(msg,0);
	    if(Ra1 <= 0.0){
		ErrorMessage("SymCompartment","Incoming Ra invalid.",
		compartment);
	    }
	    Ra_sum += compartment->Ra/Ra1;
	    break;
	case 2:			/* incoming tail axial resistance */
	    Ra1 = MSGVALUE(msg,0);
	    if(Ra1 <= 0.0){
		ErrorMessage("SymCompartment","Incoming Ra invalid.",
		compartment);
	    }
	    Ra_sum2 += compartment->Ra/Ra1;
	    break;
	}
	/*
	** divide the axial resistance into 2
	*/
	compartment->coeff = (1 + Ra_sum)/2.0;
	compartment->coeff2 = (1 + Ra_sum2)/2.0;
	break;
    case CHECK:
	/*
	** membrane leakage resistance
	*/
	if(Field(Rm) <= 0.0){
	    ErrorMessage("SymCompartment", "Invalid Rm.", compartment);
	}
	/*
	** membrane capacitance
	*/
	if(Field(Cm) <= 0.0){
	    ErrorMessage("SymCompartment", "Invalid Cm.", compartment);
	}
	MSGLOOP(compartment,msg){
	    case 1:			/* incoming axial resistance */
		if(MSGVALUE(msg,0) <= 0.0){
		    ErrorMessage("SymCompartment","Incoming Ra invalid.",
		    compartment);
		}
		break;
	}
	break;
    }
}

#undef Field

