#include "struct_defs.h"

/*
*******************************
**         SEGMENT           **
*******************************
*/

struct unit_type {
    SEGMENT_TYPE
    double	state;
    float	Rm;
    float	Cm;
    float	Em;
    float	inject;
    short	method;
};

struct RCunit_type {
    SEGMENT_TYPE
    double	state;
    float	R;
    float	C;
    float	V0;
    float	inject;
    short	method;
};

struct site_type {
    SEGMENT_TYPE
    double	Ik;
};

struct leakage_type {
    SEGMENT_TYPE
    double	Ik;
    double	Gk;
    float	Ek;
    float 	inject;
};

struct channelA_type {
    SEGMENT_TYPE
    double	Ik;
    double	Gk;
    float	Ek;
};

struct channelB_type {
    SEGMENT_TYPE
    double	Ik;
    double	Gk;
    float	Ek;
    double	Ak;
    double	Yk;
    float	tau_ak;
    float	tau_gk;
    float	gain_ak;
    float	gain_gk;
    short	method;
};

struct conductanceA_type {
    SEGMENT_TYPE
    double	Ik;
    double	Gk;
    float	Ek;
    double	Ak;
    double	Yk;
    float	tau1;
    float	tau2;
    float	gmax;
    short	method;
};

struct channelC_type {
    SEGMENT_TYPE
    double	Gk;
    float	Ek;
    double	X;
    double	Y;
    float	tau1;
    float	tau2;
    float	gmax;
    double	xconst1;
    double	xconst2;
    double	yconst1;
    double	yconst2;
    float	norm;
};

struct channelC2_type {
    SEGMENT_TYPE
    double	Ik;
    double	Gk;
    float	Ek;
    double	X;
    double	Y;
    float	tau1;
    float	tau2;
    float	gmax;
    double	xconst1;
    double	xconst2;
    double	yconst1;
    double	yconst2;
    float	norm;
};

struct membrane_type {
    float	Cm;
    float	Rm;
    float	Em;
    float	pot;
    float	inject;
    short 	method;
    short	spikes;
};

struct compartment_type {
    SEGMENT_TYPE
    double	Vm;
    double	previous_state;
    float	Im;
    float	Em;
    float	Rm;
    float	Cm;
    float	Ra;
    float	inject;
    short	method;
};

struct symcompartment_type {
    SEGMENT_TYPE
    double	Vm;
    double	previous_state;
    float	Im;
    float	Em;
    float	Rm;
    float	Cm;
    float	Ra;
    float	inject;
    short	method;
    float	coeff;
    float	coeff2;
};

struct manuelconduct_type {
    SEGMENT_TYPE
    double	Ik;
    double	Gk;
    float	Ek;
    double	H;
    double	Z;
    float	tau_g;
    float	tau_h;
    float	tau_d;
    float	gmax;
    float	K_r;
};

struct Ca_concen_type {
    SEGMENT_TYPE
    double	Ca;
    double	C;
    double	Ca_base;
    float	tau;
    float	B;
};

