#include "seg_ext.h"

/*
** Implementation of single shell Ca concentration computation
*/
/* 1/89 Matt Wilson */
CaConcen(pool,action)
register struct Ca_concen_type *pool;
Action		*action;
{
double 	dt;
MsgIn 	*msg;

    if(debug > 1){
	ActionHeader("CaConcen",pool,action);
    }
    SELECT_ACTION(action){
    case INIT:
	pool->activation = 0;
	break;
    case PROCESS:
	dt = Clockrate(pool);
	MSGLOOP(pool,msg){
	    case 0:		/* pool activation (I_Ca) */
		pool->activation += MSGVALUE(msg,0);
		break;
	    case 1:		/* fractional pool activation (I_Ca) */
		pool->activation += MSGVALUE(msg,0)*MSGVALUE(msg,1);
		break;
	}
	/*
	** dC/dt = B*I_Ca - C/tau
	*/
	pool->C = IntegrateMethod(0,pool,
	    pool->C,
	    pool->B*pool->activation,
	    1/pool->tau,
	    dt,"C");
	/*
	** set the new values of the state variables
	*/
	pool->Ca = pool->Ca_base + pool->C;
	break;
    case RESET:
	pool->activation = 0;
	pool->C = 0;
	pool->Ca = pool->Ca_base;
	break;
    case CHECK:
	if(pool->tau <= 0.0){
	    ErrorMessage("CaConcen", "Invalid tau parameters.", pool);
	}
	if(pool->Ca_base < 0.0){
	    ErrorMessage("CaConcen", "Base Ca level must be >= 0.", pool);
	}
	break;
    }
}
