#include "olf_ext.h"

/*
** Does a table lookup with interpolation. Also permits one to modify
** the table with sum and product messages, so as to extend the
** dimensionality of the table.
*/

TableFunc(table,action)
register struct table_type *table;
Action		*action;
{
MsgIn	*msg;
double	sy,py;
int		xdivs;
float	xmin,xmax;
Interpol *create_interpol();

    if(debug > 1){
	ActionHeader("VDepGate",table,action);
    }

    SELECT_ACTION(action){
    case PROCESS:
        /*
        ** check all of the messages to the table
        */
		sy = 0;
		py = 1;
        MSGLOOP(table,msg) {
            case 0:				/* index */
        	table->input = MSGVALUE(msg,0);
        	break;
			case 1:				/* summed y */
				sy += MSGVALUE(msg,0);
			break;
			case 2:				/* product y */
				py *= MSGVALUE(msg,0);
			break;
        }

        /* 
        ** calculate the voltage dependent state variable m
        */
		if (table->alloced)
        	table->output = TabInterp(table->table,table->input) * py + sy;
		else
			table->output = py + sy;
        break;

    case RESET:
        table->output = 0;
        break;

    case TABCREATE:
		if (action->argc < 3) {
			printf("usage : %s xdivs xmin xmax\n","tabcreate");
			return(0);
		}
		xdivs = atoi(action->argv[0]);
		xmin = atof(action->argv[1]);
		xmax = atof(action->argv[2]);
		table->table = create_interpol(xdivs,xmin,xmax);
		table->alloced = 1;
        break;
    }
}
