//genesis
newclass	channel
newclass	membrane
newclass	gate

/*
******************************************************************************
**                   Hodgkin-Huxley OBJECT TABLE                            **
******************************************************************************
*/
//============================================================================
//	name		data		function	class		
//============================================================================

object	hh_channel	hh_channel_type	hh_channel	segment	channel	\
	-author		"M.Nelson Caltech 8/88" \
	-actions	INIT RESET PROCESS CHECK \
	-messages	VOLTAGE 0	1 Vm \
			METHOD 1	1 integration_method 

addaction CALC_MINF 100
addaction CALC_ALPHA 101
addaction CALC_BETA 102

object	vdep_gate	vdep_gate_type	VDepGate	segment	gate	\
	-author		"M.Wilson Caltech 2/89" \
	-actions	RESET \
			PROCESS \
			*CALC_MINF VDepGate_CALC_MINF \
			*CALC_ALPHA VDepGate_CALC_ALPHA \
			*CALC_BETA VDepGate_CALC_BETA \
	-messages	VOLTAGE 0	1 voltage \
			METHOD 	1	1 integration_method \
			EREST 	2	1 Erest

object	vdep_channel	vdep_channel_type VDepChannel segment channel \
	-author		"M.Wilson Caltech 2/89" \
	-actions	INIT RESET PROCESS CHECK \
	-messages	VOLTAGE 0	1 voltage \
			MULTGATE 1	2 gate_state power \
			ADDGATE 2	2 gate_state power \
			GMAX 3		1 gmax \
			EK 4		1 Ek \
	-description	"The activation of the channel corresponds to" \
			"the voltage across it. Computes channel current Ik."

/* lookup table implementation of Hodgkin-Huxley 

object	HH_channel	HH_channel_type	HH_channel	segment	channel	\
	-author		"M.Wilson Caltech 8/88" \
	-actions	INIT RESET PROCESS CHECK

object	HH_compartment	HH_compartment_type HH_compartment segment membrane \
	-author		"M.Wilson Caltech 8/88" \
	-actions	INIT RESET PROCESS CHECK
*/
