#include "hh_ext.h"

/*
** calculates the voltage dependent gate state 
** using activation as the default voltage
*/
VDepGate(gate,action)
register struct vdep_gate_type *gate;
Action		*action;
{
MsgIn	*msg;
int	int_method = 0;
double	GateState();
double	GateSteadyState();

    if(debug > 1){
	ActionHeader("VDepGate",gate,action);
    }

    SELECT_ACTION(action){
    case PROCESS:
	/*
	** check all of the messages to the gate
	*/
	MSGLOOP(gate,msg) {
	    case 0:				/* compartment */
		/*
		** 0 = membrane potential
		*/
		gate->activation = MSGVALUE(msg,0);
		break;
	    case 1:				/* integration method */
		int_method = MSGVALUE(msg,0);
		break;
	}

	/* 
	** calculate the voltage dependent state variable m
	*/
	if(gate->instantaneous){
	    /*
	    ** calculate the steady state value of the state variable
	    */
	    gate->m = GateSteadyState(gate,
		gate->activation,
		gate->alpha_A,
		gate->alpha_B,
		gate->alpha_C,
		gate->alpha_D,
		gate->alpha_F,
		gate->beta_A,
		gate->beta_B,
		gate->beta_C,
		gate->beta_D,
		gate->beta_F);
	} else {
	    gate->m = GateState(gate, gate->m, gate->activation,
		gate->alpha_A,
		gate->alpha_B,
		gate->alpha_C,
		gate->alpha_D,
		gate->alpha_F,
		gate->beta_A,
		gate->beta_B,
		gate->beta_C,
		gate->beta_D,
		gate->beta_F,
		int_method, "m");
	}
	break;
    case RESET:
	/*
	** check all of the messages to the gate
	*/
	MSGLOOP(gate,msg) {
	    case 2:				/* Erest */
		gate->activation = MSGVALUE(msg,0);
		break;
	}

	/*
	** calculate the steady state value of the state variable
	*/
	gate->m = GateSteadyState(gate,
	    gate->activation,
	    gate->alpha_A,
	    gate->alpha_B,
	    gate->alpha_C,
	    gate->alpha_D,
	    gate->alpha_F,
	    gate->beta_A,
	    gate->beta_B,
	    gate->beta_C,
	    gate->beta_D,
	    gate->beta_F);
	break;
    }
}

VDepGate_CALC_MINF(gate,action)
register struct vdep_gate_type *gate;
Action		*action;
{
double	GateSteadyState();

    if(action->argc > 0){
	gate->activation = Atof(action->argv[0]);
    } else {
	Error();
	printf("CALC_MINF action requires voltage argument\n");
    }
    /*
    ** calculate the steady state value of the state variable
    */
    gate->m = GateSteadyState(gate,
	gate->activation,
	gate->alpha_A,
	gate->alpha_B,
	gate->alpha_C,
	gate->alpha_D,
	gate->alpha_F,
	gate->beta_A,
	gate->beta_B,
	gate->beta_C,
	gate->beta_D,
	gate->beta_F);
    action->passback = ftoa(gate->m);
}

VDepGate_CALC_ALPHA(gate,action)
register struct vdep_gate_type *gate;
Action		*action;
{
double	RateState();
double	Vm;
double	alpha;

    if(action->argc > 0){
	Vm = Atof(action->argv[0]);
    } else {
	Error();
	printf("CALC_ALPHA action requires voltage argument\n");
    }
    /*
    ** calculate the steady state value of the state variable
    */
    alpha = RateState(gate,
	Vm,
	gate->alpha_A,
	gate->alpha_B,
	gate->alpha_C,
	gate->alpha_D,
	gate->alpha_F);
    action->passback = ftoa(alpha);
}

VDepGate_CALC_BETA(gate,action)
register struct vdep_gate_type *gate;
Action		*action;
{
double	RateState();
double	Vm;
double	beta;

    if(action->argc > 0){
	Vm = Atof(action->argv[0]);
    } else {
	Error();
	printf("CALC_BETA action requires voltage argument\n");
    }
    /*
    ** calculate the steady state value of the state variable
    */
    beta = RateState(gate,
	Vm,
	gate->beta_A,
	gate->beta_B,
	gate->beta_C,
	gate->beta_D,
	gate->beta_F);
    action->passback = ftoa(beta);
}
