#include "buf_ext.h"

int	DEBUG_LinearEvent = 0;

/* 
** LinearEvent intended for unit types
*/
/* 6/88 Matt Wilson */
LinearEvent(buffer,action)
register struct linear_type	*buffer;
Action 	*action;
{
MsgIn	*msg;
double 	fval;
double 	state;
double 	thresh;
int	stat;

    if(Debug(DEBUG_LinearEvent) > 1){
	ActionHeader("LinearEvent",buffer,action);
    }
    switch(action->type){
    case PROCESS:
	thresh = buffer->thresh;
	/*
	** read the msgs
	*/
	for(msg=buffer->msg_in;msg;msg=msg->next){
	    switch(msg->type){
	    /*
	    ** type 0 : x value used to calculate y=G*(x - thresh)
	    */
	    case 0:
		buffer->state = MsgValue(msg,double,0);
		break;
	    /*
	    ** type 1 : x-intercept threshold
	    */
	    case 1:
		thresh = MsgValue(msg,double,0);
		break;
	    }
	}
	/*
	** add an event to the potential buffer
	*/
	fval = buffer->gain* (buffer->state - thresh);

	PutEvent(buffer, fval, NULL, WRAP);
	break;
    case RESET:
	ClearBuffer(buffer);
	break;
    case CHECK:
	stat = 0;
	for(msg=buffer->msg_in;msg;msg=msg->next){
	    switch(msg->type){
	    case 0:
		stat = 1;
		break;
	    }
	}
	if(!stat){
	    ErrorMessage("LinearEvent","No input state",buffer);
	}
	break;
    }
}

