//genesis

//
// GENERAL PURPOSE GRAPHICS FUNCTIONS:
//
// The following functions affect all graphs in the path subtree:
//    cleargraph(path), graphclock(path,clock), overlaygraph(path) 
//
// The follow functions affect all forms in the path subtree:
//    hidegraphics(path), showgraphics(path)
//
// The follow function affects all forms:
//    hideall


function cleargraph(path)
str path
str name
int oldoverlay
    foreach name ({EL({path}/##[TYPE=xgraph])})
	push {path}/graph{i}/graph
	oldoverlay = get(.,overlay)
	set overlay 0
	call . RESET
	set overlay {oldoverlay}
    end
end


function graphclock(path,clock)
str path
int clock
str name
    foreach name ({EL({path}/##[TYPE=xgraph])})
	useclock {name} {clock}
    end
end

function overlaygraph(path)
str path
str name
    foreach name ({EL({path}/##[TYPE=xgraph])})
	set {name} overlay $1
    end
end

function hidegraphics(path)
str path
str name
    foreach name ({EL({path}/##[TYPE=xform])})
	xhide {name}
    end
end

function showgraphics(path)
str path
str name
    foreach name ({EL({path}/##[TYPE=xform])})
	xshow {name}
    end
end

function hideall
str name
    foreach name ({EL(/##[TYPE=xform])})
	xhide {name}
    end
end
