/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/tools/sources/RCS/scan2.l,v $
  SHORTNAME      : scan2
  SNNS VERSION   : 4.1

  PURPOSE        : Second Scanner for SNNS batch interpreter 
                   scans the output of a shell command

		   For translation with flex lexical analyzer generator

  NOTES          : Use flex option '-P yyy' to change symbol name prefixes
                   in order to avoid name conflicts with the other scanners.

  AUTHOR         : Jens Wieland
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  SCCS VERSION   : $Revision: 1.2 $
  LAST CHANGE    : $Date: 1995/07/10 07:39:25 $

             Copyright (c) 1995 SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

%{  /* C definitions */

#include <math.h>
#include <string.h> 

#include "symtab.h"
#include "glob_typ.h"     /* SNNS-Kernel: Global Datatypes and Constants */
#include "error.h"

#define yyywrap() 1       /* terminate scanner at EOF of input */

/* change the type of the scanning function: */
#undef YY_DECL
#define YY_DECL Data_type yyylex(void) 

Val_type yyylval;         /* token type (usually declared by parser) */

%}

DIGIT  [0-9]
REAL   [+-]?[0-9]*"."?[0-9]+([eE][+-]?[0-9]+)?
STRING [^" \t\n]*

%%  /* rules */

[+-]?{DIGIT}+    { yyylval.int_val = atoi(yytext);
	      return INT; }

{REAL}      { yyylval.real_val = strtod(yytext, NULL);
	      return REAL; }

TRUE        { yyylval.bool_val = TRUE; 
       	      return BOOL; }

FALSE       { yyylval.bool_val = FALSE; 
       	      return BOOL; }

{STRING}    { yyylval.string_val = strdup(yytext); 
              return STRING; }

\n            return 0; /* terminate scanner at end of line */

[\t ]+        /* eat up whitespace */

.             yyyerror("Unknown symbol in output of shell command");

