/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/xgui/sources/RCS/pr_main.c,v $
  SHORTNAME      : pr_main.c
  SNNS VERSION   : 4.0

  PURPOSE        : Creates the pruning window.
  NOTES          :

  AUTHOR         : Tobias Schreiner
  DATE           : 13.3.94

  CHANGED BY     :
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.6 $
  LAST CHANGE    : $Date: 1995/04/24 13:31:54 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>

#include "ui.h"
#include "ui_xWidgets.h"
#include "kr_typ.h"
#include "kr_ui.h"
#include "kr_funcs.h"
#include "glob_typ.h"
#include "prun_f.h"
#include "ui_netUpdate.h"
#include "ui_display.h"
#include "ui_main.h"
#include "ui_mainP.h"
#include "ui_infoP.h"
#include "ui_confirmer.h"
#include "ui_control.h"
#include "done.xbm"
#include "select.xbm"
#include "ui_key.h"

#include "pr_main.ph"


/*****************************************************************************
  FUNCTION : pr_doneProc

  PURPOSE  : callback function of the done-button
  NOTES    :

  UPDATE   :
******************************************************************************/

static void pr_doneProc(void)
{

    /* store maximum error increase from dialog */
    pr_maxErrorInc = ui_xFloatFromAsciiWidget (pr_maxErrorIncDialog);
    if (pr_maxErrorInc < 0.0)
	pr_maxErrorInc = 0.0;

    /* store accepted error from dialog */
    pr_acceptedError = ui_xFloatFromAsciiWidget (pr_acceptedErrorDialog);
    if (pr_acceptedError < 0.0)
	pr_acceptedError = 0.0;

    /* store value of toggle item for recreating */
    pr_recreate = ui_xGetToggleState (pr_recreateToggleYes);

    /* store values for training and retraining of network */
    pr_trainCycles = ui_xIntFromAsciiWidget (pr_trainCyclesDialog);
    if (pr_trainCycles < 0)
	pr_trainCycles = 0;
    pr_retrainCycles = ui_xIntFromAsciiWidget (pr_retrainCyclesDialog);
    if (pr_retrainCycles < 0)
	pr_retrainCycles = 0;

    /* store minimum error from dialog */
    pr_minError = ui_xFloatFromAsciiWidget (pr_minErrorDialog);
    if (pr_minError < 0.0)
	pr_minError = 0.0;

    /* store obs init parameter from dialog */
    pr_obs_initParameter = ui_xFloatFromAsciiWidget (pr_obsInitParamDialog);
    if (pr_obs_initParameter < 0)
	pr_obs_initParameter = 0;

    /* store value of toggle item for input/hidden pruning */
    pr_inputPruning  = ui_xGetToggleState (pr_inputPruningToggleYes);
    pr_hiddenPruning = ui_xGetToggleState (pr_hiddenPruningToggleYes);

    /* close pruning window */
    XtDestroyWidget (pr_mainWidget);
    pr_open = FALSE;

}


/*****************************************************************************
  FUNCTION : pr_createWindow

  PURPOSE  : creates the PRUNING-window
  NOTES    : 

  UPDATE   :
******************************************************************************/


void pr_createWindow (void)
{

    Widget box, formprun, formtrain, formobs, formnodeprun,
           frameTitle, done, prunFuncButton, maxErrorIncText,
           acceptedErrorText, recreateText, recreateToggleNo,
           learnFuncButton, trainCyclesText, retrainCyclesText,
           minErrorText, obsInitParamText, inputPruningText,
           inputPruningToggleNo, hiddenPruningText,
           hiddenPruningToggleNo;
    static struct SimpleListType listLearnFunc, listPrunFunc;
    Arg arg [25];
    char buf [40];
    int form_width, text_width, text_width2, dialog_width;

    if(!pr_open)
	/* window is not displayed */
    {
	pr_open = TRUE;

	/* initialize geometry variables */
	form_width = ui_fontStruct->max_bounds.width * 50;
	text_width = ui_fontStruct->max_bounds.width * 40;
	text_width2 = ui_fontStruct->max_bounds.width * 38;
	dialog_width = ui_fontStruct->max_bounds.width * 10;

	/* open window */
	pr_mainWidget = XtCreatePopupShell
	    ("Pruning", topLevelShellWidgetClass, ui_toplevel, arg, 0);

	/* open box */
	box = XtCreateManagedWidget
	    ("box", boxWidgetClass, pr_mainWidget, arg, 0);


	/* --- panel for pruning parameter input --- */
	formprun = XtCreateManagedWidget
	    ("panelprun", formWidgetClass, box, arg, 0);

	/* creating frame title */
	frameTitle = ui_xCreateFrameLabelItemCentered
	    ("General Parameters for Pruning", formprun, form_width,
	     NULL, NULL);

	/* creating button for input of pruning function */
 	sprintf (buf, "Pruning function: %s",
		 krf_getCurrentNetworkFunc (PRUNING_FUNC));
 	pr_prunFuncText = ui_xCreateLabelItem
 	    (buf, formprun, form_width, NULL, frameTitle);
	prunFuncButton = ui_xCreateButtonItem
 	    ("select", formprun, NULL, pr_prunFuncText);
 	sprintf (listPrunFunc.msg,"Select pruning function");
 	listPrunFunc.unitPtr  = NULL;
 	listPrunFunc.widgetPtr= prunFuncButton;
 	listPrunFunc.listType = UI_LIST_PRUN_FUNC;
 	XtAddCallback (prunFuncButton, XtNcallback,
 		       (XtCallbackProc) ui_info_displayList,
 		       (caddr_t) &listPrunFunc);

	/* creating dialog for maximum error increase */
 	maxErrorIncText = ui_xCreateLabelItem
 	    ("Maximum error increase in %: ", formprun,
	     text_width, NULL, prunFuncButton);
 	sprintf (buf, "%g", pr_maxErrorInc);
 	pr_maxErrorIncDialog = ui_xCreateDialogItem
	    ("dialogE", formprun, buf, dialog_width,
	     maxErrorIncText, prunFuncButton);

	/* creating dialog for accepted error */
 	acceptedErrorText = ui_xCreateLabelItem
 	    ("Accepted error: ", formprun,
	     text_width, NULL, maxErrorIncText);
 	sprintf (buf, "%g", pr_acceptedError);
 	pr_acceptedErrorDialog = ui_xCreateDialogItem
	    ("dialogE", formprun, buf, dialog_width,
	     acceptedErrorText, maxErrorIncText);

	/* creating toggle widget for selecting recreating */
	recreateText = ui_xCreateLabelItem
	    ("Recreate last pruned element ?", formprun, text_width2,
	     NULL, acceptedErrorText);
	pr_recreateToggleYes = ui_xCreateToggleItem
	    ("yes", formprun, NULL, recreateText, acceptedErrorText);
	ui_xSetToggleState (pr_recreateToggleYes, pr_recreate);
	recreateToggleNo = ui_xCreateToggleItem
	    ("no", formprun, pr_recreateToggleYes,
	     pr_recreateToggleYes, acceptedErrorText);
	ui_xSetToggleState (recreateToggleNo, !pr_recreate);

	/* --- panel for training parameter input --- */
	formtrain = XtCreateManagedWidget
	    ("paneltrain", formWidgetClass, box, arg, 0);

	/* creating frame title */
	frameTitle = ui_xCreateFrameLabelItemCentered
	    ("General Parameters for Training", formtrain, form_width,
	     NULL, NULL);

	/* creating button for input of learning function */
  	sprintf (buf, "Learning function: %s", 
		 krf_getCurrentNetworkFunc 
		 (FF_LEARN_FUNC | LEARN_FUNC));
  	pr_learnFuncText = ui_xCreateLabelItem
  	    (buf, formtrain, form_width, NULL, frameTitle);
	learnFuncButton = ui_xCreateButtonItem
	    ("select", formtrain, NULL, pr_learnFuncText);
 	sprintf (listLearnFunc.msg,"Select learning function");
 	listLearnFunc.unitPtr  = NULL;
 	listLearnFunc.widgetPtr= learnFuncButton;
 	listLearnFunc.listType = UI_LIST_FF_LEARN_FUNC;
 	XtAddCallback (learnFuncButton, XtNcallback,
 		       (XtCallbackProc) ui_info_displayList,
 		       (caddr_t) &listLearnFunc);

	/* creating dialog for learn cycles */
 	trainCyclesText = ui_xCreateLabelItem
 	    ("Learn cycles for first training: ", formtrain, 
	     text_width, NULL, learnFuncButton);
 	sprintf (buf, "%d", pr_trainCycles);
 	pr_trainCyclesDialog = ui_xCreateDialogItem
	    ("dialogT", formtrain, buf, dialog_width,
	     trainCyclesText, learnFuncButton);

	/* creating dialog for retrain cycles */
 	retrainCyclesText = ui_xCreateLabelItem
 	    ("Learn cycles for retraining: ", formtrain, 
	     text_width, NULL, trainCyclesText);
 	sprintf (buf, "%d", pr_retrainCycles);
 	pr_retrainCyclesDialog = ui_xCreateDialogItem
	    ("dialogR", formtrain, buf, dialog_width,
	     retrainCyclesText, trainCyclesText);

	/* creating dialog for minimum error */
 	minErrorText = ui_xCreateLabelItem
 	    ("Minimum error to stop: ", formtrain, 
	     text_width, NULL, retrainCyclesText);
 	sprintf (buf, "%g", pr_minError);
 	pr_minErrorDialog = ui_xCreateDialogItem
	    ("dialogM", formtrain, buf, dialog_width,
	     minErrorText, retrainCyclesText);


	/* --- panel for obs parameters --- */
	formobs = XtCreateManagedWidget
	    ("panelobs", formWidgetClass, box, arg, 0);

	/* creating frame title */
	frameTitle = ui_xCreateFrameLabelItemCentered
	    ("Parameters for OBS", formobs, form_width, NULL, NULL);

	/* creating dialog for pruning parameter */
 	obsInitParamText = ui_xCreateLabelItem
 	    ("Initial value for matrix: ", formobs, text_width,
	     NULL, frameTitle);
 	sprintf (buf, "%g", pr_obs_initParameter);
 	pr_obsInitParamDialog = ui_xCreateDialogItem
	    ("dialogI", formobs, buf, dialog_width,
	     obsInitParamText, frameTitle);


	/* ------ panel for node pruning parameters ------ */
	formnodeprun = XtCreateManagedWidget
	    ("panelnodeprun", formWidgetClass, box, arg, 0);

	/* create frame title */
	frameTitle = ui_xCreateFrameLabelItemCentered
	    ("Parameters for Node Pruning", formnodeprun, form_width,
	     NULL, NULL); 

	/* create toggle widget for selecting input pruning */
	inputPruningText = ui_xCreateLabelItem
	    ("Input Pruning ?", formnodeprun, text_width2,
	     NULL, frameTitle);
	pr_inputPruningToggleYes = ui_xCreateToggleItem
	    ("yes", formnodeprun, NULL, inputPruningText, frameTitle);
	ui_xSetToggleState (pr_inputPruningToggleYes, pr_inputPruning);
	inputPruningToggleNo = ui_xCreateToggleItem
	    ("no", formnodeprun, pr_inputPruningToggleYes,
	     pr_inputPruningToggleYes, frameTitle);
	ui_xSetToggleState (inputPruningToggleNo, !pr_inputPruning);

	/* create toggle widget for selecting hidden pruning */
	hiddenPruningText = ui_xCreateLabelItem
	    ("Hidden Pruning ?", formnodeprun, text_width2,
	     NULL, inputPruningText);
	pr_hiddenPruningToggleYes = ui_xCreateToggleItem
	    ("yes", formnodeprun, NULL, hiddenPruningText, pr_inputPruningToggleYes);
	ui_xSetToggleState (pr_hiddenPruningToggleYes, pr_hiddenPruning);
	hiddenPruningToggleNo = ui_xCreateToggleItem
	    ("no", formnodeprun, pr_hiddenPruningToggleYes,
	     pr_hiddenPruningToggleYes, inputPruningToggleNo);
	ui_xSetToggleState (hiddenPruningToggleNo, !pr_hiddenPruning);


	/* --- done button --- */
	done = ui_xCreateButtonItem ("done", box, NULL, NULL);
	XtAddCallback (done, XtNcallback, (XtCallbackProc)
		       pr_doneProc, NULL);


	XtAddEventHandler(formprun,KeyPressMask,FALSE,
			  (XtEventHandler)ui_key_control,(Cardinal *) 0);
	ui_checkWindowPosition (pr_mainWidget);
	XtPopup (pr_mainWidget, XtGrabNone);
	ui_xDontResizeWidget (pr_mainWidget);
    }
    else
	/* window is displayed */
    {
	/* get window into foreground */
	XRaiseWindow (XtDisplay (pr_mainWidget), XtWindow (pr_mainWidget));
    }
}

