/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/kr_slave.x,v $
  SHORTNAME      : kr_slave.x
  SNNS VERSION   : 4.0

  PURPOSE        : Inputfile for rpcgen
  NOTES          : The kernelfunctions for slave kernels

  AUTHOR         : Sven Doering
  DATE           : 17.08.94

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.2 $
  LAST CHANGE    : $Date: 1995/04/21 14:19:11 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/
%#define FILEBLOCKSIZE 1024
#define FILEBLOCKSIZE 1024

typedef int     sl_rpc_krui_err;

typedef long sl_rpc_DIRP; 

struct sl_rpc_timeval {
        long    tv_sec;         /* seconds */
        long    tv_usec;        /* and microseconds */
};



struct sl_par_get_kernel {
	string xguihost<>;
	long   xguipnumber;
	long   xguiversion;
	long   xguiid;
	long   uid;
	long   pid;
};

struct  sl_rpc_dirent {
        long            d_off;          /* offset of next disk dir entry */
        unsigned long   d_fileno;       /* file number of entry */
        unsigned short  d_reclen;       /* length of this record */
        unsigned short  d_namlen;       /* length of string in d_name */
        string          d_name<>;  	/* name (up to MAXNAMLEN + 1) */
	bool		last_entry;	/* detect end of dir */
};
struct sl_par_getcwd {
	string buf<>;
	int size;
};
struct sl_par_access {
	string path<>;
	int mode;
};

struct sl_res_stat{
        short   	st_dev;
        unsigned long   st_ino;
        unsigned short  st_mode;
        short   	st_nlink;
        unsigned short  st_uid;
        unsigned short  st_gid;
        short		st_rdev;
        long		st_size;
        long		st_atime;
        long		st_mtime;
        long		st_ctime;
        long    	st_blksize;
        long    	st_blocks;
	int		return_value;
};

struct sl_kernel_info {
    int             errornr;
    int             uid;
    int             pid;
    int             port;
    string          hostname <>;
    string          hostadr < 16 >;
};

/**************************************************** 
 * ATTENTION this struct also exist in ui_rpcsnns.x
 *   as par_config2 and in kr_ui_rpc.x as par_config
 ****************************************************/

struct sl_par_config{

/* Configuration of the Kernel */
	u_int   lastEpoch;
	float	lastLearnError;
	u_int   epochsToLearn;
	long	starttime;
	long	cputime;
	int	kernelMode;
	sl_rpc_timeval timeout;
	sl_rpc_timeval timeoutlong;
	long	exittimeout;
	long    switchtolocalall;
	long    switchtolocalsingle;
	bool	isUDP;
	int	status;

/* current configuration of remote panel */
	int       ui_noOfCurrentPattern;  /* number of current pattern
                                         0 means, no patterns loaded */
	int       ui_patternLoadMode;
	int       ui_numberOfStepsDone;
	int       subIPatSize[5];
	int       subIPatPos[5];
	int       subIPatStep[5];	
	int       subOPatStep[5];
	int       subOPatSize[5];
	int       subOPatPos[5];
	int       subIPatNo;
	int       subIPatDims;
	int       subOPatDims;
	float     ui_learnParameters[25];
	float     ui_updateParameters[5];
	float     ui_initParameters[5];
	bool      ui_shuffleFlg;

	/* from ui_fileP.ph */
	char   ui_filenameNET[100];
	char   ui_filenamePAT[100];
	char   ui_filenameRES[100];
	char   ui_filenameCFG[100];
	char   ui_filenameTXT[100];

	int    NO_OF_PATTERN_SETS;
	int    CURR_PATTERN_SET;
	char   PATTERN_SET_FILE[100];

	/* ui_remote.ph */
	int       ui_numberOfCycles;
	int       ui_numberOfSteps;

	/* are static */
	/* static int   INIT_KOHONEN_PRINT;
	   static int   ui_noErrorArrayElements;
	*/

	/* only for displaying */
	int noOfPatterns;
	int noOfUnits;
	int noOfInput;
	int noOfOutput;
	int noOfHidden;
};
struct sl_parallel_kernel {
	int kernelid;   /* Id for the xgui host */
	long kernelno;  /* Versionnumber for portmapper */
	char coop_id;	/* Id for the master kernel */
	string host<>;
	string domain<>;
	string hostaddr<>;
	char status;
};

struct sl_parallel_kernels {
	sl_parallel_kernel kernels<>;
	int learnFunc;
	int noOfEpochs;
};


struct sl_res_send_kernel_msg {
	int 	option;
	long	value;
	int 	return_value;
};

struct sl_par_filetransfer {
	long	epoche;
	long	laufnr;
	int	Command;
	bool	lastblock;
	long	bytes_used;
	opaque 	fileblock[FILEBLOCKSIZE];	
};

struct sl_par_upload {
	int command;
	int setno;
	int epoche;
};

struct sl_res_filetransfer {
	long	epoche;
	long	laufnr;
	int 	Command;
	sl_rpc_krui_err error;
	bool	lastblock;
	long	bytes_used;
	opaque 	fileblock[FILEBLOCKSIZE];	
};


struct  sl_par_matrix {
	char val_type;
	int  x;
	int  y;
	float values<>;
};

struct  sl_res_matrix {
	char coop_id;
	char val_type;
	float error;
	int  x;
	int  y;
	float values<>;
};

struct sl_par_learning {
	char coop_id;
	int startpat;
	int endpat;
	int learnFunc;
	int noOfEpochs;
};

struct sl_par_coopLearning {
/*	int learningFunc;
	int noOfEpochs;*/
	sl_par_learning from_to<>;
};


/*
 * Functions
 */

program         SNNSKERNELSLAVEPROG {
    version         SNNSKERNELSLAVEVERS {
	/* These funktion are also in kr_ui_rpc.x  */
	int		SL_GET_SNNS_KERNEL(sl_par_get_kernel) 		= 1;
	string		SL_GET_KERNEL_INFOTEXT(void)			= 2;
	sl_kernel_info  SL_GET_KERNEL_INFO(void)			= 3;
	sl_rpc_DIRP	SL_RPC_OPENDIR(string)				= 4;
	sl_rpc_dirent	SL_RPC_READDIR(sl_rpc_DIRP)			= 5;
	int		SL_RPC_CLOSEDIR(sl_rpc_DIRP)			= 6;
	string		SL_RPC_GETCWD(sl_par_getcwd)  			= 7;
	int		SL_RPC_ACCESS(sl_par_access)  			= 8;
	sl_res_stat	SL_RPC_STAT(string)				= 9;
	int		SL_SET_RPC_KERNEL_CONFIG(sl_par_config)		= 10;
	sl_par_config	SL_GET_RPC_KERNEL_CONFIG(int)			= 11;
	sl_res_send_kernel_msg SL_SEND_KERNEL_MSG(int)			= 12;
 	sl_rpc_krui_err	SL_DOWNLOAD_FILE(sl_par_filetransfer)		= 13;
	sl_res_filetransfer SL_UPLOAD_FILE(sl_par_upload)		= 14;
	int	        SL_SET_COOPCONFIG(sl_parallel_kernels)		= 15;

	/* only use 75 - 100 */
	int 		SL_SEND_PAR_MATRIX(sl_par_matrix)		= 75;
	int 		SL_SEND_RES_MATRIX(sl_res_matrix)		= 76;
	int		SL_START_LEARNING(sl_par_learning)		= 77;
/*	int		SL_BROAD_START_LEARNING(sl_par_cooplearning)	= 78;*/
    } =             40;     /* overwritten by the mainprog */
} =             0x211d1ae3; /* the adress for portmapper (same in kr_slave.x)*/


