/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/kernel/sources/RCS/rcc_learn.ph,v $
  SHORTNAME      : 
  SNNS VERSION   : 4.0

  PURPOSE        : Header file of correspondent '.c' file
  NOTES          :

  AUTHOR         : Michael Schmalzl
  DATE           : 5.2.1993

  CHANGED BY     : Michael Schmalzl
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.4 $
  LAST CHANGE    : $Date: 1995/03/14 14:07:25 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _RCC_LEARN_DEFINED_
#define  _RCC_LEARN_DEFINED_

/* begin global definition section */
krui_err LEARN_RecCasCor(int StartPattern, int EndPattern,
                      float *ParameterInArray, int NoOfInParams,
                      float **ParameterOutArray, int *NoOfOutParams);

krui_err rcc_searchRecurrentLinks(void);
/* end   global definition section */

/* begin privat definition section */
static int  rcc_test(int StartPattern,int EndPattern,float maxPixelError); 

static void  rcc_propagateNetForward(int PatternNo, int sub_pat_no);

static void  rcc_calculateOutputUnitError(int StartPattern,int EndPattern);

static void rcc_calculateSpecialUnitActivation(int startPattern,
					       int endPattern);
static krui_err rcc_generateSpecialUnits(int MaxSpecialUnitNo, int OutputXMax,
					 int type);

static krui_err rcc_generateHiddenUnit(int maxYPosOfHiddenUnit,
				       int *xPosOfLastInsertedHiddenUnit,
                                      int *yPosOfLastInsertedHiddenUnit);

static void  rcc_QPS_trainNet(int maxNoOfCovarianceUpdateCycles, 
			      float minCovarianceChange, 
			      int specialPatience,int StartPattern,
			      int EndPattern, float param4, float param5, 
			      float param6, int MaxSpecialUnitNo);

static float rcc_QPS_propagateNetBackward(int StartPattern,int EndPattern,
					  int counter);

static void  rcc_QPS_updateNet(float epsilon,float mu, float decay);
 
static void  rcc_QPO_trainNet(int maxNoOfErrorUpdateCycles,int backfittPatience, 
			      float minErrorChange, int outPatience, 
			      int StartPattern,int EndPattern,
			      float param1, float param2,float param3,
			      float **ParameterOutArray,int *NoOfOutParams);

static float rcc_QPO_propagateNetBackward(int PatternNo, int sub_pat_no);

static void  rcc_QPO_updateNet(float epsilon, float mu, float decay);

static void  rcc_BPS_trainNet(int maxNoOfCovarianceUpdateCycles, 
			      float minCovarianceChange, int specialPatience,
			      int StartPattern,int EndPattern, float param4, 
			      float param5, float param6, 
			      int MaxSpecialUnitNo);

static float rcc_BPS_propagateNetBackward(int StartPattern,int EndPattern,
					  int counter);

static void  rcc_BPS_updateNet(float eta,float mu, float dummy);

static void  rcc_BPO_trainNet(int maxNoOfErrorUpdateCycles,int backfittPatience, 
			      float minErrorChange, int outPatience, 
			      int StartPattern,int EndPattern,
			      float param1, float param2,float param3,
			      float **ParameterOutArray,int *NoOfOutParams);

static float rcc_BPO_propagateNetBackward(int PatternNo, int sub_pat_no,
					  float fse);

static void  rcc_BPO_updateNet(float eta,float mu,float dummy);

static void  rcc_RPS_trainNet(int maxNoOfCovarianceUpdateCycles, 
			      float minCovarianceChange, int specialPatience,
			      int StartPattern,int EndPattern, float param4, 
			      float param5, float param6, 
			      int MaxSpecialUnitNo);

static float rcc_RPS_propagateNetBackward(int StartPattern,int EndPattern,
					  int counter);

static void  rcc_RPS_updateNet(float epsilon, float mu, float decay);

static void  rcc_RPO_trainNet(int maxNoOfErrorUpdateCycles,int backfittPatience,
			      float minErrorChange, int outPatience, 
			      int StartPattern,int EndPattern,
			      float param1, float param2,float param3,
			      float **ParameterOutArray,int *NoOfOutParams);

static float rcc_RPO_propagateNetBackward(int PatternNo, int sub_pat_no);

static void  rcc_RPO_updateNet(float epsilon, float mu, float decay);

/* end privat definition section */

#endif /* _RCC_LEARN_DEFINED_ */
